#!/bin/awk -f
# Awk script to produce a single-line-per-file output format for archie.
# Output format is
#  hostname	directory	filename	size	date
# padded with many tabs.
# Note: On SunOS, sort +2 fails on this scripts' output; use sort -b +2 instead.
/^Host / {host=$2 substr("\t\t\t\t\t\t", 1, (47-length($2))/8); next}
/^ *Location:/ {dir=$2 substr("\t\t\t\t\t\t\t\t", 1, (63-length($2))/8); next}
/^ *FILE/ { print host dir $7 substr("\t\t\t\t", 1, (31-length($7))/8) $3 " " $4 " " $5 " " $6; next}
