#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>

#define XMOSAICPATH "./xmosaic"

/**************************** callxmosaic *********************************/
int callxmosaic(url)
char *url;
/* Returns non-zero on success, 0 on failure */
{
    static pid_t pid=0;
    char filename[32];
    FILE *file;
    char path[BUFSIZ];
    char *envstring;
    
    signal(SIGCHLD,SIG_IGN);
    
/* Handle quit */
    if(!strcmp(url,"quit")) {
	if (pid) {
	    sprintf(filename,"/tmp/xmosaic.%d",pid);
	    unlink(filename);
	    kill(pid,SIGTERM);
	    pid=0;
	}
	return 3;
    }
/* If xmosaic is not up, exec it */
    if ((!pid) || kill(pid,0)) {
	if (!(pid=fork())) {
	    envstring=getenv("XMOSAICPATH");
	    if(!envstring) {
		sprintf(path,"%s",XMOSAICPATH);
	    }
	    else {
		sprintf(path,"%s/xmosaic",envstring);
	    }
	    execl(path,"xmosaic",url,0);
	    perror("Could not start Xmosaic");
	    return 0;
	}
	return 1;
    }
/* Xmosaic is up ,send message through file */
    sprintf(filename,"/tmp/xmosaic.%d",pid);
    if (!(file=fopen(filename,"w"))) return 0;
    fputs("goto\n", file);
    fputs(url,file);
    fclose(file);
    kill(pid,SIGUSR1);
    return 2;
}


main()
{
    static char line[BUFSIZ];
    int ret;

    for(;;) {
	printf("Enter URL: \n");
	gets(line);
	if(*line == '\0') {
	    callxmosaic("quit");
	    exit(0);
	}
	printf("URL is: %s\n",line);
	ret=callxmosaic(line);
	printf("Callxmosaic returned %d\n",ret);
    }
}
