/*
 * Copyright (c) 1993,1995
 *	Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Texas A&M University
 *	and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *             David K. Hess, Douglas Lee Schales, David R. Safford
 */
/*
 * Prototypes.
 */

/*
 * nit.c
 */
int nit_open(char *device,u_short type);
int nit_write(int fd,char *b,int len);

/*
 * util.c
 */
void longSwap(unsigned long *buf,unsigned long length);
void shortSwap(unsigned short *buf,unsigned long length);
void printError(unsigned char code,FILE *theOutput);

/*
 * comm.c
 */
void initCommunications(void);
int startTransaction(void);
unsigned char *sendMessage(unsigned char type,void *data,unsigned long size);

/*
 * fm.c
 */
void handleSet(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleShow(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleNewKey(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleGenKey(FILE *theInput,FILE *theOutput,FILE *theMessages);
char *tildeExpand(char *filename,FILE *theMessages);
void handleLoad(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleQuery(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleUpload(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleWrite(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleClear(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleReset(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleRelease(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleReboot(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleHelp(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleInput(FILE *theInput,FILE *theOutput,FILE *theMessages);
void usage(void);
void readRc(void);
int main(int argc,char *argv[]);

void clientInit(unsigned char *,Key *,SyncPacket *);
void serverInit(unsigned char *,Key *,SyncPacket *);
void buildNewSessionKey(Key *,Key *,Key *);
void potpEncrypt(unsigned char *,unsigned char *,Key *,unsigned short);
void potpDecrypt(unsigned char *,unsigned char *,Key *,unsigned short);
void initFromPass(unsigned char *,Key *);
void initFromTime(Key *);
unsigned long randLong(Key *);
unsigned char randByte(Key *);
unsigned char randBit(Key *);
unsigned char lfsr(unsigned long *,unsigned long);
void initPotp(void);

/*
 * lex.l
 */
int tokenize(char *string);


unsigned char *buildBuf(unsigned char *,unsigned long);
