/*
 * mygetopt.h --
 *
 *      Header file to scan UNIX-style short and long command line options.
 *
 * Copyright(C) 1995, 1996 NEC Corporation. All rights reserved.
 * This is a genuine component of Socks5Toolkit(TM).
 *
 * $Header: /insg/project/socks/s5watch/include/mygetopt.h,v 1.1 1997/01/22 21:07:04 miked Exp $
 * $Log: mygetopt.h,v $
 * Revision 1.1  1997/01/22 21:07:04  miked
 * Initial version.
 *
 */

#ifndef _MYGETOPT_H
#define _MYGETOPT_H 1

#ifdef  __cplusplus
extern "C" {
#endif

extern char *optarg;
extern int optind;
extern int opterr;

struct my_option
{
  const char *name;

#define NOARG       1
#define REQARG      2
#define OPTARG      3
  int argtype;

  int *flag;
  int val;
};

extern int my_getopt (int argc, char *const *argv, const char *shortopts,
                     const struct my_option *longopts, int *longind);

#ifdef  __cplusplus
}
#endif

#endif /* _MYGETOPT_H */
