/* xgopher.c
   Xgopher main program */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.2     20 November 1991               */
     /*                version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include <stdio.h>

#include <string.h>

#if defined(sun) || defined(sgi)
#include <strings.h>
#endif

#include "conf.h"
#include "gui.h"
#include "appres.h"
#include "util.h"
#include "osdep.h"

#define GLOBALS
#include "globals.h"
#undef GLOBALS

BOOLEAN	getOptions(
#ifdef PROTO
	int,
	char **
#endif
);


/* noOptions
   Cannot find the resources file... help the user a bit */

void
noOptions()
{
	fprintf (stderr,
		"The %s Application Resources file is not available.\n",
		GOPHER_CLASS);
	fprintf (stderr,
		"The file \'%s\' should be stored in the directory\n",
		GOPHER_CLASS);
	fprintf (stderr, "%s.\n", APP_DEFAULTS_DIR);
	fprintf (stderr, "It can also be located in your own ");
	fprintf (stderr, "app-defaults directory, or the contents\n");
	fprintf (stderr, "can be copied to one of your other ");
	fprintf (stderr, "X windows resources files.\n");
	fprintf (stderr, "\n%s cannot continue without this file.\n",
		GOPHER);
}


/* usage
   print usage message */

usage(name)
char	*name;
{
	fprintf (stderr, "usage:\n");
	fprintf (stderr,
		"\t%s [gopher server [port number]] [X Toolkit options].\n",
		name);
}


/* xgopher
   main program */

main(argc, argv)
int	argc;
char	**argv;
{
	char			*p;
	gopherItemP		mainItem;
	char			errorString[MESSAGE_STRING_LEN];

	/* save last component of path name */

	if ((p = rindex(argv[0], '/')) == 0) p = argv[0];
	strcpy(gopherName, p);
	SOCKSinit("rxgopher");

	/* initialize the Graphical User Interface, the X window system */

	if (! initGUI(&argc, argv)) {
		noOptions();
		exit(1);
	}

	/* see if Xt left us any options.  If there is exactly one,
	   and it has no leading '-', use it as the rootServer.
	   If there are exactly two, neither with a leading '-',
	   and the second is a number greater than zero, then use
	   them as the rootServer and rootPort.

	   We may leak a few bytes in the following code, but there
	   is no guarantee that the previous values of the resources
	   were dynamically allocated. */

	if ((argc == 2  && argv[1][0] != '-')  ||
	    (argc == 3  && argv[1][0] != '-'  && argv[2][0] != '-')) {
		int	hostLen = sizeof(char) * strlen(argv[1]) + 1;
		char	*tmp;

		if (argc == 3) {
			int	port=atoi(argv[2]);
			if (port > 0) {
				appResources->rootPort = port;
			} else {
				usage(argv[0]);
				exit(1);
			}

		}

		tmp = malloc(hostLen);
		strcpy(tmp, argv[1]);
		appResources->rootServer = tmp;

		tmp = malloc(hostLen);
		strcpy(tmp, argv[1]);
		appResources->mainTitle = tmp;


	} else if (argc > 1) {
		usage(argv[0]);
		exit(1);
	}

	mainItem = makeItem(A_DIRECTORY,
			    appResources->mainTitle, appResources->rootPath,
			    appResources->rootServer, appResources->rootPort,
			    FALSE);
			

	if (processSelection(mainItem)) {
		if (appResources->markRoot) {
			markCurrentDirectory();
		}

		if (appResources->loadBookmarks) {
			loadMarks();
		}

	} else {
		sprintf(errorString,
"Unrecoverable error: cannot access the main %s directory at\nhost: %s port %d", 
			GOPHER, appResources->rootServer,
			appResources->rootPort);
		showFatalError(errorString);

	}

	doUserRequests();
}
