/*
 * Default SOCKS server host; you MUST set this for your site.
 * This is overridden at run time by the contents of environment
 * variable SOCKS_SERVER if it exists.
 */
#define SOCKS_DEFAULT_SERVER	"SOCKS.server.for.your.site"

/*
 * Default Domain Nameserver for the SOCKS clients.
 * Leave it undefined if all your client mechines can do general
 * DNS lookup for all Internet hosts correctly with the DNS servers
 * specified in /etc/resolv.conf.
 * Otherwise, define it using the IP ADDRESS (NOT NAME!) of a DNS
 * server which can resolve all Internet hosts and which is IP-reachable
 * from your client machines.
 * This is overriden at run time by the contents of environment
 * variable SOCKS_NS if it exists.
 */
/* #define SOCKS_DEFAULT_NS	"1.2.3.4" */

/*
 * Define NOT_THROUGH_INETD if you want a standalone SOCKS server,
 * one which is not under the control of inetd.
 * This is not recommended.
 */
/* #define NOT_THROUGH_INETD */

/*
 * Maximum number of concurrent clients a SOCKS server will support.
 * Meaningful only if the server is not under the control
 * of inetd, i.e., when NOT_THROUGH_INETD is defined.
 */
#define MAX_CLIENTS	5


/*
 * Default port number for SOCKS services.
 * On the SOCKS server host, if the server is under inetd control,
 * then the port must be specified in socks/tcp entry in /etc/services.
 * For servers not under inetd control and for all clients,
 * the port number is obtained from socks/tcp entry in /etc/services if
 * it exists, otherwise the number defined by SOCKS_DEF_PORT will be used.
 */
#define SOCKS_DEF_PORT	1080

/*
**  How long (in minutes) to keep a connection around while it is idle
*/
#define SOCKS_TIMEOUT	2*60*60	/* 2hr in minutes */


/*
 * Where the config file lives on the SOCKS server host.
 * This is the file that controls access to the SOCKS server
 * and its services.
 */
#define SOCKD_CONF	"/etc/sockd.conf"

/* Current SOCKS protocol version */
#define SOCKS_VERSION	4

/*
**  Response commands/codes
*/
#define SOCKS_CONNECT	1
#define SOCKS_BIND	2
#define SOCKS_RESULT	90
#define SOCKS_FAIL	91
#define SOCKS_NO_IDENTD	92 /* Failed to connect to Identd on client machine */
#define SOCKS_BAD_ID	93 /* Client's Identd reported a different user-id */

typedef struct {
	unsigned long		host; /* in network byte oreder */
	unsigned short		port; /* in network byte oreder */
	unsigned char		version;
	unsigned char		cmd;
} Socks_t;

typedef struct in_addr socks_ipaddr_t;
