/* sc_dir.c
   gopher item subclass procedures for directories */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include "conf.h"
#include "globals.h"
#include "gopher.h"
#include "util.h"
#include "status.h"
#include "appres.h"
#include "item.h"
#include "dir.h"
#include "dirList.h"
#include "sc_dir.h"
#include "sc_dirP.h"



/* getDirectory
   load a new gopher directory as indicated by the selected item */

static BOOLEAN
getDirectory(gi)
gopherItemP	gi;
{
	int		s;
	gopherDirP	d;
	BOOLEAN		fetchOK;

	if (( s = GI_connectWithStatus(gi) ) < 0 ) return FALSE;

	writeString(s, vStringValue(&(gi->selector)));
	writeString(s, EOL_STRING);

	d = newDir();

	if (noCurrentDir()) {
		showStatus("Getting main gopher directory",
			STAT_ROOT, gi->host, gi->port);
	} else {
	showStatus("Getting new directory",
			STAT_DIRECTORY, gi->host, gi->port);
	}

	fetchOK = GI_getGopherDir(s, d);

	close(s);

	if (!removeStatusPanel() ) {

		/* someone cancelled as the directory load finished */

		freeDir(d);
		return FALSE;
	}

	if (! fetchOK ) {

		/* failure to load directory */

		freeDir(d);
		showError(
			"There seems to be no information in this directory\n");
		return FALSE;
	}

	setDirTime(d);


	d->selectorItem = copyItem(gi);
	
	pushCurrentDir(d);

	displayCurrent();

	return TRUE;
}


/* GIDir_init
   initialize directory class - prefix string */

void
GIDir_init()
{
	GU_makePrefix(prefixDir,  appResources->prefixDir);
	GU_registerNewType(A_DIRECTORY, &dirSubclass);

	return;
}


/* GIDir_restart
   restart directory class - clear directory stack */

void
GIDir_restart()
{
	clearDirStack();

	return;
}


/* GIDir_process
   process a directory selection */

BOOLEAN
GIDir_process(gi)
gopherItemP	gi;
{
	BOOLEAN	result;

	result = getDirectory(gi);

	return result;
}
