/*
 * Copyright (c) 1993,1995
 *	Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Texas A&M University
 *	and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *             David K. Hess, Douglas Lee Schales, David R. Safford
 */
#include <sys/types.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>
#include <errno.h>
#include "chario.h"
#include "services.h"
#include "hosts.h"
#include "groups.h"
#include "classes.h"
#include "version.h"

int parse_error = 0;

/*
extern void perror(char *);
extern int yyparse(void);
*/

void
showcopyright(void)
{
     fprintf(stdout, "\
Drawbridge Filter Compiler version 2.0,\n\
Copyright (C) 1993,1994,1995 David K. Hess, Douglas Lee Schales, David R. Safford\n\
Drawbridge Filter Compiler comes with ABSOLUTELY NO WARRANTY.\n\
");
}

extern int optind;
extern char *optarg;

int
main(int argc, char **argv)
{
     int status;
     int byteswap = 0;
     int c;

     while((c=getopt(argc, argv, "bcv")) != -1)
	  switch(c){
	  case 'v':
	       printf("fc, version %s\n", toolversion);
	       exit(0);
	       break;
	  case 'b':
	       byteswap = 1;
	       break;
	  case 'c':
	       showcopyright();
	       break;
	  default:
	       exit(1);
	  }

     if(!argv[optind]){
	  fprintf(stderr, "Usage: %s [-b] [-c] config-file\n", argv[0]);
	  exit(1);
     }

     if(addfile(argv[optind]) != NOERR){
	  perror(argv[optind]);
	  exit(1);
     }

     init_services();
     init_groups();
     init_hosts();

     yyparse();

     if(!parse_error){
	  writehosttables(byteswap);
	  writeclasses(byteswap);
	  status = 0;
     }
     else
	  status = 1;

     exit(status);

     return status;
}

int
yyerror(void)
{
     parse_error = 1;
}
