/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

extern const char *con_types[];

const char *pkttype[] =
{"Interface Check:",
 "Hello:",
 "Db Sum:",
 "Link State Request:",
 "Link State Update:",
 "Link State Ack:"};

void
log_ospf_hdr(fp, hdr)
struct OSPF_HDR *hdr;
FILE *fp;
{

    fprintf(fp, "Type: %s Version: %d Length: %d\n",
	    pkttype[hdr->type],
	    hdr->version,
	    ntohs(hdr->length));
    fprintf(fp, "    Rtr ID: %s Area ID: %s Checksum: Ox%x\n",
	    lntoa(hdr->rtr_id),
	    lntoa(hdr->area_id),	/* area ID */
	    hdr->checksum);
    fprintf(fp, "    Auth Type: %d Auth Key: %s\n",
	    hdr->AuType,
	    hdr->Auth);
}

/*
 * Print the LSA hdr
 */
void
log_ls_hdr(fp, ls_hdr)
FILE *fp;
struct LS_HDR *ls_hdr;
{
    fprintf(fp, "     >LS type: %s LS ID: %s Adv rtr: %s Age: %d\n",
	    ls_types[ls_hdr->ls_type],
	    lntoa(ls_hdr->ls_id),
	    lntoa(ls_hdr->adv_rtr),
	    ls_hdr->ls_age);
    fprintf(fp, "     Len: %d Seq #: %x Checksum: Ox%x\n",
	    ntohs(ls_hdr->length),
	    ntohl(ls_hdr->ls_seq),
	    ntohs(ls_hdr->ls_chksum));
}

int
log_lsa(fp, adv)
FILE *fp;
union LSA_PTR adv;
{
    int cnt, i;
    struct NET_LA_PIECES *att_rtr;
    struct RTR_LA_PIECES *lnk;

    log_ls_hdr(fp, &(adv.rtr->ls_hdr));

    switch (adv.rtr->ls_hdr.ls_type) {
	case LS_RTR:
	    fprintf(fp, "     Capabilities: As Border: %s Area Border: %s\n",
		    (ntohs(adv.rtr->E_B) & bit_E) ? "On" : "Off",
		    (ntohs(adv.rtr->E_B) & bit_B) ? "On" : "Off");

	    for (cnt = ntohs(adv.rtr->lnk_cnt),
		 i = 0,
		 lnk = (struct RTR_LA_PIECES *) & (adv.rtr->link);
		 i < cnt;
		 lnk = (struct RTR_LA_PIECES *) ((long) lnk +
						  RTR_LA_PIECES_SIZE +
			      ((lnk->metric_cnt) * RTR_LA_METRIC_SIZE)),
		 i++) {
		fprintf(fp,
			"     link id: %-12s data: %-12s type: %-7s metric: %-4d\n",
			lntoa(lnk->lnk_id),
			lntoa(lnk->lnk_data),
			con_types[lnk->con_type - 1],
			ntohs(lnk->tos0_metric));
	    }
	    break;

	case LS_NET:
	    fprintf(fp, "     Net mask: %s\n",
		    lntoa(adv.net->net_mask));

	    cnt = ntohs(adv.net->ls_hdr.length) - NET_LA_HDR_SIZE;
	    for (att_rtr = &(adv.net->att_rtr), i = 0;
		 i < cnt;
		 att_rtr++, i += 4) {
		fprintf(fp, "     Attached router: %s\n",
			lntoa(att_rtr->lnk_id));
	    }
	    break;

	case LS_SUM_NET:
	    fprintf(fp, "     Net mask: %-12",
		    lntoa(adv.sum->net_mask));

	    /* Fall through */
	case LS_SUM_ASB:
	    fprintf(fp, "      Tos 0 metric: %-4d\n",
		    ntohl(adv.sum->tos0.tos_metric));
	    break;

	case LS_ASE:
	    fprintf(fp, "      Net mask: %-12s Tos 0 metric: %-5d External type: %-2d\n",
		    lntoa(adv.ase->net_mask),
		    ADV_BIG_METRIC(adv.ase),
		    ADV_ASE_TYPE2(adv.ase) ? 2 : 1);

	    fprintf(fp, "    Forwarding Address: %-12s Tag: %-8x\n",
		    lntoa(adv.ase->tos0.ForwardAddr),
		    ntohl(adv.ase->tos0.ExtRtTag));
	    break;
    }
    return (ntohs(adv.rtr->ls_hdr.length));
}


void
pkt_log(fp, pkt, len, type, direction, addr)
FILE *fp;
int len;
int type, direction;
void *pkt;
u_long32 addr;
{
    int i, adv_len;
    u_char8 *p = (u_char8 *) pkt;
    struct LS_UPDATE_HDR *lsup;
    struct DB_HDR *dbh;
    struct HELLO_HDR *hello;
    struct RHF *rhf;
    struct LS_HDR *dbp;
    struct LS_REQ_HDR *ls_req;
    struct LS_REQ_PIECE *req;
    struct LS_ACK_HDR *ls_ack;
    struct LS_HDR *ack;
    union LSA_PTR adv;

    EVENT_UPDATE();
    if (direction) {
	fprintf(fp, "RX: %s \n", lntoa(addr));
    } else
	fprintf(fp, "TX: %s \n", to2str(addr));

    log_ospf_hdr(fp, pkt);

    switch (type) {
	case O_HELLO:

    	    hello = &(((struct OSPF_HDR *) pkt)->un.hello);

	    fprintf(fp,"    Netmask: %-12s Hello Int: %-4d Options: %-4x Priority: %-4d\n",
    		lntoa(hello->netmask),
    		ntohs(hello->HelloInt),
    		hello->options,
    		hello->rtr_priority);
	    fprintf(fp,"    Dead Int: %-4d Dr: %-12s BDr: %-12s\n",
    		ntohl(hello->DeadInt),
    		lntoa(hello->dr),
    		lntoa(hello->bdr));
	    fprintf(fp,"     Attached routers:\n");
    	    for (rhf = (struct RHF *) & (hello->rhf);
	         rhf < (struct RHF *) ((u_long) & (hello->rhf) +
		       (len - (OSPF_HDR_SIZE + HELLO_HDR_SIZE)));
	 	 rhf++)
	    {
		fprintf(fp,"        %-12s\n",lntoa(rhf->rtr));
	    }
	    break;

	case O_DB_DESCRIPT:

    	    dbh = &(((struct OSPF_HDR *) pkt)->un.database);

    	    fprintf(fp,"    DD hdr: options: %x init: %d more: %d ms: %d seq: Ox%x\n",
			dbh->options,
	    		(dbh->I_M_MS & bit_I) ? 1 : 0,
	    		(dbh->I_M_MS & bit_M) ? 1 : 0,
	    		(dbh->I_M_MS & bit_MS) ? 1 : 0,
			ntohl(dbh->seq));
    	    for ( dbp = &(dbh->dbp), len -= (OSPF_HDR_SIZE + DB_HDR_SIZE);
	          len;
		  len -= DB_PIECE_SIZE, dbp++ ) 
	    {
	    	if (dbp->ls_type < LS_RTR || dbp->ls_type > LS_ASE) {
	            fprintf(fp,"BAD_LSA_TYPE %d\n",dbp->ls_type);
		    continue;
	    	}
		log_ls_hdr(fp,dbp);
	    }
	    break;

	case O_LSR:

	    ls_req = &(((struct OSPF_HDR *) pkt)->un.ls_req);

    	    for ( req = &(ls_req->req), len -= OSPF_HDR_SIZE;
    		  len; 
		  len -= LS_REQ_PIECE_SIZE, req++ ) 
	    {
		if (req->ls_type < LS_RTR || req->ls_type > LS_ASE) {
	           	fprintf(fp,"BAD_LSA_TYPE %d\n",req->ls_type);
		    	continue;
	    	}
    	    	fprintf(fp,"       LS type: %s LS ID: %s Adv rtr: %s\n",
    		    ls_types[req->ls_type],
    		    lntoa(req->ls_id),
    		    lntoa(req->adv_rtr));
	    }
	    break;

	case O_LSU:

	    lsup = &(((struct OSPF_HDR *) pkt)->un.ls_update);

	    fprintf(fp, "    Advertisement count: %-4d\n",
		    ntohl(lsup->adv_cnt));
	    for (i = 0, adv.rtr = (struct RTR_LA_HDR *) & (lsup->adv.rtr);
		 (i < ntohl(lsup->adv_cnt)) && len;
		 i++,
		 len -= adv_len,
	    adv.rtr = (struct RTR_LA_HDR *) ((long) adv.rtr + adv_len)) {
		adv_len = log_lsa(fp, adv);
	    }
	    break;

	case O_ACK:

	    ls_ack = &(((struct OSPF_HDR *) pkt)->un.ls_ack);

    	    for( ack = &(ls_ack->ack_piece), len -= OSPF_HDR_SIZE;
		 len > 0;
		 len -= ACK_PIECE_SIZE, ack++ )
	    {
		if (ack->ls_type < LS_RTR || ack->ls_type > LS_ASE) {
	            	fprintf(fp,"BAD_LSA_TYPE %d\n",ack->ls_type);
		    	continue;
		}
		log_ls_hdr(fp,ack);
	    }
	    break;
    }
    fprintf(fp, "\n\n");
}
