/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

void
same_instance_dbg(A,B)
struct LS_HDR *A, *B;
{
	sprintf(_ospf_prt_buf,"A: seq %x age %d Chksum %x",
		(A)->ls_seq,
	    	ntohs((A)->ls_age),
		(ntohs((A)->ls_chksum)));
	DBG_LOG(_ospf_prt_buf);

	sprintf(_ospf_prt_buf,"B: seq %x age %d Chksum %x",
		(B)->ls_seq,
	    	(B)->ls_age,
		(ntohs((B)->ls_chksum)));
	DBG_LOG(_ospf_prt_buf);

        sprintf(_ospf_prt_buf,"%x %x %x %x %d",
                (A)->ls_seq == (B)->ls_seq,
                (!(((A)->ls_age == MaxAge) ^ ((B)->ls_age == MaxAge))),
                (ODIFF((((B)->ls_age)),((A)->ls_age)) <= MaxAgeDiff),
                (ntohs((A)->ls_chksum) == ntohs((B)->ls_chksum)),
                ODIFF((((B)->ls_age)),((A)->ls_age)));
	DBG_LOG(_ospf_prt_buf);
}


int
RxLsAck(ack, intf, ipsrc, rtrid, olen, mc)
struct LS_ACK_HDR *ack;
struct INTF *intf;
u_long32 ipsrc, rtrid;
int olen;
int mc;
{
    struct NBR *nbr = NBRNULL, *n;
    struct LS_HDR *ap = &(ack->ack_piece);
    struct LSDB *db = LSDBNULL;
    struct AREA *a, *area = AREA_PTR(intf);
    struct LSDB_LIST *trans = LLNULL, *asetrans = LLNULL;
    int ret_flag;

    /* list of db entries to be freed */

    /* Locate nbr */
    n = FirstNbr(intf);
    if (intf->type > NONBROADCAST) {
	if (n->nbr_id == rtrid)
	    nbr = n;
    } else
	for (n = FirstNbr(intf); n != NBRNULL; n = n->next) {
	    if (ipsrc == n->nbrip_addr) {
		nbr = n;
		break;
	    }
	}

    DBG_LOG("RxAck Here1");
    if (nbr == NBRNULL)
	return (NO_ACK_NBR);
    if (nbr->state < NEXCHANGE)
	return (LOW_NBR_STATE3);

    DBG_LOG("RxAck Here2");
    for (olen -= OSPF_HDR_SIZE;
	 olen > 0;
	 olen -= ACK_PIECE_SIZE)
    {
	ret_flag = 0;

	if (ap->ls_type < LS_RTR || ap->ls_type > LS_ASE) {
	    RX_LOG(mc, BAD_LSA_TYPE, intf->ifspfndx, nbr->nbrip_addr);
	    ap++;
	    DBG_LOG("RxAck Cont1");
	    continue;
	}
	if ((db = FindLSA(area, ap->ls_id, ap->adv_rtr, ap->ls_type))
	    == LSDBNULL) {
	    ap++;
	    DBG_LOG("RxAck Cont2");
	    continue;
	}

	/* MODIFIED 10/5/92 - added ntohs */
	ap->ls_age = ntohs(ap->ls_age);
	same_instance_dbg(ap,&(DB_RTR(db)->ls_hdr));
	if (SAME_INSTANCE(ap, &(DB_RTR(db)->ls_hdr), 0))
	{
	    if (DB_RETRANS(db) != NLNULL) {	/* on retrans list */
		/*
	         * check for enough buffers to send a new one
	         */
		if (DB_SEQ_MAX(db) == TRUE && (!QueueChk(LS_TYPE(db),a))) {
		    ap++;
	    	    DBG_LOG("RxAck Cont3");
		    continue;
		}

		/* remove from lsdb */
		if (rem_nbr_ptr(db, nbr))
	        {
	    	    DBG_LOG("rem_nbr_ptr success");
		}

		/* remove from nbr */
		if (rem_db_ptr(nbr, db))
		{	
	    	    DBG_LOG("rem_nbr_ptr success");
		}

		/*
	         * If MaxSeq and this is last ack, generate a new one
	         */
		/* MODIFIED 2/6/92  |= */
		if (DB_SEQ_MAX(db) == TRUE &&
		    DB_RETRANS(db) == NLNULL &&
		    DB_FREEME(db) != TRUE)
		    	area->spfsched |= beyond_max_seq(area,
					     intf,
					     db,
					     &trans,
					     &asetrans,
					     0);


		/* 
	 	 * if MaxAge we have flooded this one - check for empty
		 * retrans list - if empty, remove from lsdb 
		 */
		if (DB_CAN_BE_FREED(db)) {
		    db_free(db);
		}
	    }
	}
	else
	{
    	    DBG_LOG("RxAck Not Same Instance");
	}
	ap++;
    }

    if (asetrans != LLNULL) {		/* new self originated ls_ase */
	for (a = FirstArea; a < &(ospf.area[ospf.acnt]); a++)
	    if (a->ext_option == EXT_OPT_NORMAL)
		self_orig_area_flood(a, asetrans, LS_ASE);
	ospf_freeq(&asetrans, OMEM_LL);
    }
    if (trans != LLNULL) {
	self_orig_area_flood(area, trans, LS_RTR);
	ospf_freeq(&trans, OMEM_LL);
    }
    if (area->spfsched)
	RX_RUN_SPF(area);

    return (GOOD_RX);
}

#endif				/* PROTO_OSPF */
