/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   **     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#ifdef	__GATED__
#include "../include.h"
#endif	/* __GATED__ */
#include "../ospf.h"
#include <ctype.h>

#define HISTORY_SIZE 30			/* Size of history cache */

#define HNEXT(NDX) (((NDX+1) == HISTORY_SIZE) ? 0 : (NDX + 1))
#define HLAST(NDX) (((NDX) == 0) ? HISTORY_SIZE - 1 : (NDX - 1))

int gwsock;				/* socket to receive gw info from */
int gw;					/* gw connection */
u_short16 port;				/* port to listen on */
FILE *localfp = stdout;

void
got_int()
{
    if (gw && (close(gw) < 0))
	printf("Badclose\n");
    /* reset */
    signal(SIGINT, got_int);
}

char *
lntoa(addr)
u_long addr;
{
    static int i = 0;
    static char bufs[8][20];
    unsigned char *p = (unsigned char *) &addr;

    i = (i + 1) % (sizeof bufs / sizeof bufs[0]);
    sprintf(bufs[i], "%d.%d.%d.%d", p[0], p[1], p[2], p[3]);
    return bufs[i];
}

void
print_params(fp, buf)
FILE *fp;
char *buf;
{
    int i;

    for (i = 0; i < 70; i++) {
	if (buf[i] == '\0')
	    fprintf(fp, " ");
	else if ((buf[i] == '\n') || (buf[i] == '\r'))
	    break;
	else
	    fprintf(fp, "%c", buf[i]);
    }
    fprintf(fp, "\n");
    fflush(fp);
}

void
remote_help()
{
    printf("Remote-commands:\n");
    printf("   a <area id> <type> <ls id> <adv rtr>: show link state advertisement\n");
    printf("   b: print ospf area info\n");
    printf("   c: show cumulative log\n");
    printf("   d <type>: turn on pkt dump for type and above\n");
    printf("   e: show cumulative errors\n");
    printf("   g: print ospf general info\n");
    printf("   h: print ospf configured host info\n");
    printf("   k: kill\n");
    printf("   l <r>: dump lsdb - if r is set will print retrans lst\n");
    printf("   m : show lsdb in sorted order \n");
    printf("   n <0|1 delete|add> <addr> <mask> <fwd addr> <cost> <age> <type> <tag>:\n");
    printf("        add static network to be exported to OSPF as AS External\n");
    printf("   o: print ospf routing table\n");
    printf("   q: show timerq log\n");
    printf("   r <type>: set rx and tx log level log for pkt type and above\n");
    printf("   s: print configured summary ranges\n");
    printf("   t: toggle timer log\n");
    printf("   A: toggle asb capability for router \n");
    printf("   D <IP Addr>: disable ospf interface\n");
    printf("   I: show interfaces\n");
    printf("   L <bit mask>: Log 1: LSAs built, 2: running spf,\n");
    printf("                 4: LSAs flooded, 8: received LSAs; default is 15\n");
    printf("   N <r>: show neighbors - if r is set will print retrans lst\n");
    printf("   O: turn off tx, rx and timer log \n");
}


void
help()
{
    printf("Local commands:\n");
    printf("   ?: help \n");
    printf("   ?R: remote command information \n");
    printf("   d: show configured destinations\n");
    printf("   h: show history\n");
    printf("   x: exit\n");
    printf("   @ <remote command>: use last destination \n");
    printf("   @<dest index> <remote command>: use configured destination \n");
    printf("   F <filename>: write monitor information to filename\n");
    printf("   S: write monitor information to stdout (default)\n");
}


struct DEST {
    u_long32 dest;
    char name[30];
} *dtab;

int destcnt;


/*
 * Syntax:
 *    <gw ip addr> <gw name>
 *
 */
void
monconf(fn)
{
    FILE *fp, *fopen();
    char buf[1024], new[30], dest_st[80], name_st[30];

    if ((fp = fopen(fn, "r")) == (FILE *) NULL) {
	fprintf(stderr, "monconf: Can't open monitor conf file %s\n", fn);
	exit(1);
    }
    if ((dtab = (struct DEST *) calloc(10, sizeof(struct DEST))) ==
	(struct DEST *) NULL)
	ciao("monitor: calloc returned NULL");

    while (fgets(buf, 1024, fp)) {
	if (!strcmp(buf, "\n"))
	    continue;			/* blank line */
	sscanf(buf, "%s", new);
	if (new[0] == '#')
	    continue;

	destcnt++;
	if ((dtab = (struct DEST *)
	     realloc(dtab, sizeof(struct DEST) * (destcnt + 1))) == (struct DEST *) NULL)
	    ciao("monitor: realloc returned NULL\n");
	sscanf(buf, "%s %s", dest_st, dtab[destcnt].name);
	if ((!strlen(dtab[destcnt].name)) || (!strlen(dest_st)))
	    ciao("monitor: bad entry\n");
	if ((dtab[destcnt].dest = inet_addr(dest_st)) == -1) {
	    fprintf(stderr, "monitor: (%s) unknown host \n", dest_st);
	    exit(1);
	}
    }
}

void
print_local(fp, to, name)
FILE *fp;
u_long32 to;
char *name;
{
#ifdef FD_ZERO
    fd_set ready;

#else
    int ready;

#endif
    struct timeval wait;
    char buf[100];
    int rval, i;
    int fd;

#ifndef FD_ZERO
#define FD_ZERO(SET) (*SET) = 0
#define FD_SET(FD,SET)	((*SET) |= (1 << (FD)))
#define FD_ISSET(FD,SET) ((*SET) & (1 << (FD)))
#endif
    FD_ZERO(&ready);
    FD_SET(gwsock, &ready);
    wait.tv_sec = 20;
    wait.tv_usec = 0;
    if (select(gwsock + 1, &ready, 0, 0, &wait) < 0) {
	perror("select");
	return;
    }
    if (FD_ISSET(gwsock, &ready)) {
	if ((gw = accept(gwsock, (struct sockaddr *) 0, (int *) 0)) < 0) {
	    perror("accept:");
	    return;
	}
	fd = fileno(fp);
	bzero(buf, sizeof(buf));
	sprintf(buf, "\n          Source <<%-16s", lntoa(to));
	if (name)
	    sprintf(&buf[35], " %s>>\n", name);
	else
	    sprintf(&buf[35], ">>\n");
	write(fd, buf, 80);
	bzero(buf, sizeof(buf));
	while ((i = read(gw, buf, 100)) > 0) {
	    write(fd, buf, sizeof(buf));
	    bzero(buf, sizeof(buf));
	}
	if (i < 0)
	    perror("read");
	if (close(gw) < 0)
	    printf("Badclose\n");
    } else
	printf("Connection timeout: try again...\n");
}


void
txmon(fd, req, buf, to, name)
int fd;
u_char8 req;
u_char8 buf[200];
u_long32 to;
u_char *name;
{
    u_long32	p[MAXPARAMS];
    u_short16 	len = OSPF_HDR_SIZE + MON_REQ_SIZE;
    u_char 	packet[OSPF_HDR_SIZE + MON_REQ_SIZE];
    struct 	OSPF_HDR *o_hdr = (struct OSPF_HDR *) packet;
    struct 	MON_HDR *m = &(o_hdr->un.mon);
    struct 	sockaddr_in dst;
    int 	dstlen = sizeof(dst);
    int 	local_wait = FALSE, i;
    int		ret;
    char 	ip_addr_st[20], ip_mask_st[20], faddr_st[20], area_id_st[20];

    bzero(p, (MAXPARAMS * 4));
    printf("   remote-command <%c ", req);

    if ( req == 'a' || req == 'b' || req == 'c' || req == 'e' || req == 'g' ||
	 req == 'h' || req == 'l' || req == 'm' || req == 'o' || req == 'q' || 
	 req == 't' || req == 'x' || req == 'y' || req == 'z' ||
	 req == 'N' || req == 'I' )
	local_wait = TRUE;


    switch(req) {
    	case 'a':
    	case 'x':
	/* 
	 * show advertisement 
	 */
	sscanf(buf, "%*s %*s %s %d %s %s",
		area_id_st,
		&p[1],
	       	ip_addr_st,
	       	ip_mask_st);

	p[0] = inet_addr(area_id_st);
	p[2] = inet_addr(ip_addr_st);
	p[3] = inet_addr(ip_mask_st);
	printf("%s %d %s %s ",
		 lntoa(p[0]),
		 p[1],
		 lntoa(p[2]),
	         lntoa(p[3]));
	break;
	
	case 'n':
	/* 
	 * Add static net to be exported as ASE 
	 */
	sscanf(buf, "%*s %*s %*s %s %s %s %ld %ld %ld %ld",
	       ip_addr_st,
	       ip_mask_st,
	       faddr_st,
	       &p[4],
	       &p[5],
	       &p[6],
	       &p[7]);

	p[1] = inet_addr(ip_addr_st);
	p[2] = inet_addr(ip_mask_st);
	p[3] = inet_addr(faddr_st);
	printf("%s %s %s ",
		lntoa(p[1]),
		lntoa(p[2]),
		lntoa(p[3]),
		p[4],
		p[5],
		p[6],
		p[7]);

	case 'D': /* Disable/Inable interface */
	case 'y': /* rtab_get_next tester */
	sscanf(buf, "%*s %*s %s", ip_addr_st);
	p[0] = inet_addr(ip_addr_st);
	printf("%s ", lntoa(p[0]));
	break;

 	default:

	ret = sscanf(buf, "%*s %*s %ld %ld %ld %ld %ld %ld %ld",
	       &p[0],
	       &p[1],
	       &p[2],
	       &p[3],
	       &p[4],
	       &p[5],
	       &p[6]);
	for (i = 0; i < ret; i++) {
    		if (p[i])
	    	    printf("%d ", p[i]);
	}
    }

    printf("> sent to %s %d\n", lntoa(to),local_wait);

    m->type = MREQUEST;
    m->req = req;
    for (i = 0; i < MAXPARAMS; i++) {
	m->p[i] = htonl(p[i]);
    }
    if (local_wait) {
	m->port = port;
	m->local = 1;
    } else {
	m->port = 0;
	m->local = 0;
    }
    o_hdr->version = OSPF_VERSION;
    o_hdr->type = O_MON;
    o_hdr->length = htons(len);
    o_hdr->rtr_id = 0;
    o_hdr->area_id = 0;
    o_hdr->checksum = 0;
    bzero(o_hdr->Auth, 8);

    o_hdr->AuType = 0;
    o_hdr->checksum = inet_chksum(packet, len);


    dst.sin_family = AF_INET;
    dst.sin_port = 0;
    dst.sin_addr.s_addr = (u_long) to;
    if ((sendto(fd, (char *) packet, len, 0,
		(struct sockaddr *) & dst, dstlen)) < 0) {
	perror("txpkt sendto");
	close(fd);
	exit(1);
    }
    if (local_wait) {
	print_local(localfp, to, name);
    	local_wait = FALSE;
    }
}

main(argc, argv)
int argc;
char *argv[];
{
    int sock, ndx, n;
    int bufndx = 0, curndx = 0;
    int length, cc, val;
    char buf[50][200];
    char dest_st[30], req_st[5], ndx_st[10], filename[30];
    char *name, *lastname;
    u_long32 p[MAXPARAMS], dest, lastdest = 0;
    struct sockaddr_in sin;
    FILE *hp = (FILE *) NULL;

    signal(SIGINT, got_int);
    /* create a raw Multicast socket */
    if ((sock = socket(AF_INET, SOCK_RAW, IPPROTO_OSPF)) < 0)
	ciao("> socket(AF_INET, SOCK_RAW) fails");

    /* create a stream socket for receiving info */
    if ((gwsock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	perror("> socket(AF_INET, SOCK_RAW) fails");
	exit(1);
    }
    cc = sizeof(val);
#ifdef SO_RCVBUF
    if (getsockopt(gwsock, SOL_SOCKET, SO_RCVBUF,
		   (char *) &val, &cc)) {
	perror("getsockopt");
	exit(1);
    }
#endif
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = INADDR_ANY;
    sin.sin_port = 0;
    if (bind(gwsock, &sin, sizeof(sin))) {
	perror("bind: gw sock");
	exit(1);
    }
    length = sizeof(sin);
    if (getsockname(gwsock, &sin, &length)) {
	perror("getsockname failed");
	exit(1);
    }
    port = sin.sin_port;
    listen(gwsock, 5);

    if (argc > 1)
	monconf(argv[1]);

    printf("[ %d ] dest command params > ", curndx);
    while (1) {
	bufndx = HNEXT(bufndx);
	curndx++;
	bzero(buf[bufndx], 200);
	if (!gets(buf[bufndx]))
	    exit(1);

	if (!strlen(buf[bufndx])) {	/* blank line */
	    bufndx = HLAST(bufndx);
	    curndx--;
	    goto again;
	}
	sscanf(buf[bufndx], "%s %s",
	       dest_st,
	       req_st);

	if (buf[bufndx][0] == '!') {
	    sscanf(&buf[bufndx][1], "%s", ndx_st);
	    ndx = atoi(ndx_st);
	    if ((ndx > (curndx - 1)) ||
		(ndx < (curndx + 1 - HISTORY_SIZE))) {
		printf("Bad history index\n");
		goto again;
	    }
	    ndx = (ndx % HISTORY_SIZE);
	    sscanf(buf[ndx], "%s %s",
		   dest_st,
		   req_st);
	    bcopy(buf[ndx], buf[bufndx], 200);
	}
	if (isalpha(dest_st[0]) || ispunct(dest_st[0])) {
	    switch (dest_st[0]) {
		case 'd':
		    if (destcnt)
			for (ndx = 1; ndx <= destcnt; ndx++)
			    printf("%d: %-16s %-30s\n",
				   ndx,
				   lntoa(dtab[ndx].dest),
				   dtab[ndx].name);
		    else
			printf("No destinations configured\n");
		    break;

		case 'h':
		    {
			int i;
			int start, end;

			/* wrap around? */
			if (curndx > (HISTORY_SIZE - 1)) {
			    start = curndx - HISTORY_SIZE;
			    end = curndx;
			} else {
			    start = 1;
			    end = curndx;
			}
			for (i = start;
			     i < end;
			     i++) {
			    printf("%d > ", i);
			    print_params(stdout,
					 buf[i % HISTORY_SIZE]);
			}
		    }
		    break;

		case '?':
		    if (dest_st[1] == 'r' || dest_st[1] == 'R') {
			remote_help();
			break;
		    }
		    help();
		    break;

		case 'x':
		    if (localfp != stdout) {
			fclose(localfp);
			if (hp)
			    fclose(hp);
		    }
		    exit(1);

		case '@':
		    if (dest_st[1] == 0) {
			if (lastdest) {
			    name = lastname;
			    dest = lastdest;
			    goto lastd;
			} else {
			    printf("No last dest\n");
			    goto again;
			}
		    } else if (isdigit(dest_st[1])) {
			if (!destcnt) {
			    printf("Destination table not configured\n");
			    goto again;
			}
			ndx = atoi(&dest_st[1]);
			if (ndx > 0 && ndx <= destcnt) {
			    dest = dtab[ndx].dest;
			    name = dtab[ndx].name;
			    lastdest = dest;
			    lastname = name;
			    goto lastd;
			} else {
			    printf("Invalid index %c\n", dest_st[1]);
			    goto again;
			}
		    } else {
			printf("Invalid index %c\n", dest_st[1]);
			goto again;
		    }

		case 'F':
		    n = sscanf(buf[bufndx], "%*s %s", filename);
		    if (n < 0) {
			printf("Filename not given\n");
		    } else if ((localfp = fopen(filename, "w")) == (FILE *) NULL) {
			fprintf(stderr, "Can't open %s\n",
				filename);
			localfp = stdout;
		    }
		    break;
		case 'H':
		    n = sscanf(buf[bufndx], "%*s %s", filename);
		    if (n < 0) {
			printf("Turning off history log\n");
			if (hp) {
			    fclose(hp);
			    hp = (FILE *) NULL;
			}
		    } else if ((hp = fopen(filename, "w")) == (FILE *) NULL) {
			fprintf(stderr, "Can't open %s\n",
				filename);
			hp = (FILE *) NULL;;
		    } else
			printf("Turning on history log\n");
		    break;

		case 'S':
		    if (localfp != stdout) {
			fclose(localfp);
			localfp = stdout;
		    }
		    break;

	    }
	    goto again;
	} else {
	    if (dest_st[0] == '\n' || !strlen(dest_st)) {
		bufndx = HLAST(bufndx);
		curndx--;
		goto again;
	    }
	    dest = inet_addr(dest_st);
	    if (dest == -1 ||
		dest < htonl(0x2000001) ||
		(!(dest & htonl(0x000000ff)))) {
		printf("   dest: (%s): unknown host \n", dest_st);
		goto again;
	    }
	    lastdest = dest;
	    lastname = name;
	}
      lastd:
	if (!strlen(req_st)) {
	    printf("   Illegal request: %s\n\n", req_st);
	    help();
	    goto again;
	}
	if (hp)
	    print_params(hp, buf[bufndx]);
	txmon(sock, req_st[0], buf[bufndx], dest, name);
      again:
	bzero(p, (MAXPARAMS * 4));
	dest = 0;
	name = (char *) NULL;
	bzero(dest_st, 30);
	bzero(req_st, 5);
	printf("[ %d ] dest command params > ", curndx);
    }
}
