/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

/***************************************************************************

	   		PACKET HEADER STRUCTURES

****************************************************************************/

/* 
 * General Link State Advertisement Hdr 
 */
struct LS_HDR {
    u_short16 	ls_age;
    u_char8 	ls_options;
    u_char8 	ls_type;	/* Type of advertisement */
    u_long32 	ls_id;		/* Link State Id */
    u_long32 	adv_rtr;	/* Advertising router */
    long32 	ls_seq;
    u_short16 	ls_chksum;
    u_short16 	length;		/* ls adv length */
};

/* 	MONITOR REQUEST PACKET */
#define MREQUEST 	1
#define MAXPARAMS	12

/*
 * OMON packet header
 */ 
struct MON_HDR {
    u_char8 type, req, more, param_cnt;
    u_short16 port;		/* port that gw writes to */
    u_short16 local;		/* true if returning info */
    u_long32 p[MAXPARAMS];
};

#define MON_REQ_SIZE (8 + (MAXPARAMS * 4))

/*
 *	HELLO packet
 */
struct RHF {			/* router heard from */
    u_long32 rtr;		/* part of the hello hdr, IDs of recently seen
				   (via hellos) rtrs on this net */
};

#define RHF_SIZE 4

#define OPT_T_bit	0x01
#define OPT_E_bit	0x02

struct HELLO_HDR {
    u_long32 netmask;		/* net mask */
    u_short16 HelloInt;		/* seconds between this rtr's Hello packets */
    u_char8 options;		/* options capabilities supported by router */
    u_char8 rtr_priority;	/* this router's priority */
    u_long32 DeadInt;		/* seconds before declaring this router down */
    u_long32 dr;		/* ID of DR for this net */
    u_long32 bdr;		/* ID of the backup DR for this net */
    struct RHF rhf;		/* router heard from */
};

#define HELLO_HDR_SIZE 20		/* less RHF */

/*	
 * Database description header
 */
#define DB_PIECE_SIZE	20


struct DB_HDR {
    u_short16 phill2;
    u_char8 options;
    u_char8 I_M_MS;		/* bits: init, more, master/slave */
#define		bit_I	0x04
#define		bit_M 	0x02
#define		bit_MS	0x01
    u_long32 	seq;		/* seq num of the database description pkts */
    struct LS_HDR dbp;
};

#define DB_HDR_SIZE	8


/*	
 * Link-state request header
 */
/* MODIFIED 5//24/92 */
struct LS_REQ_PIECE {
    u_long32 ls_type;			/* Type of the piece */
    u_long32 ls_id;			/* Link State Id */
    u_long32 adv_rtr;			/* Advertising router */
};

#define LS_REQ_PIECE_SIZE 12

struct LS_REQ_HDR {
    struct LS_REQ_PIECE req;
};


/*	
 * Link-state advertisements
 */

/* 
 * Link State Types 
 */
#define LS_STUB		0
#define LS_RTR		1
#define LS_NET		2
#define LS_SUM_NET	3
#define LS_SUM_ASB	4
#define LS_ASE		5


/* 
 * Router Advertisement 
 */
struct RTR_LA_METRIC {
    u_short16 tos;		/* type of service; used with mask */
#define		RTR_LS_TOS_MASK  0x0700
    u_short16 metric;		/* cost of using this interface */
};

#define RTR_LA_METRIC_SIZE 4

struct RTR_LA_PIECES {
    u_long32 lnk_id;		/* interface ID */
    u_long32 lnk_data;		/* net mask */
    u_char8 con_type;		/* what the interface connects to */
#define		RTR_IF_TYPE_RTR		1
#define		RTR_IF_TYPE_TRANS_NET	2
#define		RTR_IF_TYPE_STUB_NET	3
#define		RTR_IF_TYPE_HOST	RTR_IF_TYPE_STUB_NET
#define		RTR_IF_TYPE_VIRTUAL	4
#define 	HOST_NET_MASK 		0xFFFFFFFF
    u_char8 metric_cnt;		/* number of metrics */
    u_short16 tos0_metric;	/* metric for TOS 0 */
};

#define RTR_LA_PIECES_SIZE  12


struct RTR_LA_HDR {
    struct LS_HDR ls_hdr;	/* General hdr - type is LS_RTR */
    u_short16 E_B;		/* external or border bits; used with mask */
#define		bit_B	 0x100	/* border bit mask */
#define		bit_E	 0x200	/* external bit mask */
    u_short16 lnk_cnt;		/* number of links */
    struct RTR_LA_PIECES link;
};

#define RTR_LA_HDR_SIZE 24	/* less the pieces */

/*  
 * Network Links Advertisement 
 */
struct NET_LA_PIECES {
    u_long32 lnk_id;
};

#define NET_LA_PIECES_SIZE 4

struct NET_LA_HDR {
    struct LS_HDR ls_hdr;		/* General hdr - type is LS_NET */
    u_long32 net_mask;
    struct NET_LA_PIECES att_rtr;
};

#define NET_LA_HDR_SIZE 24


/*  
 * Summary links advertisements 
 */
struct SUM_LA_PIECES {
    u_long32 tos_metric;
#define		 SUM_LA_TOS_MASK  0x7000000
};

#define SUM_LA_PIECES_SIZE 4

struct SUM_LA_HDR {
    struct LS_HDR ls_hdr;	/* General hdr - type is LS_SUM_NET or RTR */
    u_long32 net_mask;
    struct SUM_LA_PIECES tos0;
};

#define SUM_LA_HDR_SIZE 28


/* 
 * AS External links advertisments 
 */
struct ASE_LA_PIECES {
    u_long32 tos_metric; 	/* 0:type 1  1:type 2 */
#define		ASE_bit_E	0x80000000 
#define    	NET_bit_E	(htonl(ASE_bit_E))
#define		ASE_TOS_MASK	0x7F000000
    u_long32 ForwardAddr;
    u_long32 ExtRtTag;
};

#define ASE_LA_PIECES_SIZE	12

struct ASE_LA_HDR {
    struct LS_HDR ls_hdr;	/* General LS hdr - type is LS_ASE */
    u_long32 net_mask;
    struct ASE_LA_PIECES tos0;
};

#define ASE_LA_HDR_SIZE 36

/* 
 * Defines for SUM and ASE metrics 
 */
#define METRIC_MASK 	  0x00FFFFFF
#define	BIG_METRIC(V)     (ntohl(DB_ASE((V))->tos0.tos_metric) & METRIC_MASK)
#define	ADV_BIG_METRIC(A) (ntohl((A)->tos0.tos_metric) & METRIC_MASK)

#define ASE_TYPE2(A)  	((ntohl(DB_ASE((A))->tos0.tos_metric) & ASE_bit_E) != 0)
#define ADV_ASE_TYPE2(A) ((ntohl((A)->tos0.tos_metric) & ASE_bit_E) != 0)
#define ASE_TYPE1(A)    ((ntohl(DB_ASE((A))->tos0.tos_metric) & ASE_bit_E) == 0)

union ADV {
    struct RTR_LA_HDR rtr;
    struct NET_LA_HDR net;
    struct SUM_LA_HDR sum;
    struct ASE_LA_HDR ase;
};

/*
 * Link-state update hdr
 */
struct LS_UPDATE_HDR {
    u_long32 adv_cnt;		/* Number of link state advertisements */
    union ADV adv;
};

#define LS_UPDATE_HDR_SIZE 4

/*	
 * Link-state ack packet
 */
#define ACK_PIECE_SIZE	20

struct LS_ACK_HDR {
    struct LS_HDR ack_piece;
};

#define LS_ACK_HDR_SIZE 4

/*	
 * OSPF packet header
 */
union PACKET_TYPES {			/* The rest of the packet */
    struct MON_HDR mon;
    struct HELLO_HDR hello;
    struct DB_HDR database;
    struct LS_REQ_HDR ls_req;
    struct LS_UPDATE_HDR ls_update;
    struct LS_ACK_HDR ls_ack;
};

#define OSPF_AUTH_SIZE	8

struct OSPF_HDR {
    u_char8 version;
    u_char8 type;
#define		O_MON 		0	/* monitor request packet */
#define		O_HELLO		1
#define		O_DB_DESCRIPT   2
#define		O_LSR		3	/* link state request */
#define		O_LSU		4	/* link state update */
#define		O_ACK		5	/* link state ack */
    u_short16 length;			/* length of entire packet in bytes */
    u_long32 rtr_id;			/* router ID */
    u_long32 area_id;			/* area ID */
    u_short16 checksum;
    u_short16 AuType;			/* Authentication scheme */
    u_char8 Auth[OSPF_AUTH_SIZE];
    union PACKET_TYPES un;
};

#define OSPF_HDR_SIZE 24

#define OSPF_HDR_NULL	((struct OSPF_HDR *) 0)
