/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

extern char *paths[];
/* MODIFIED DB_NH_NDX 1/10 */

#ifndef UMBC_SIM
static OROUTE *__ospf_last_lookup;

#else
extern void log_param_rtab();
static OROUTE *sim_ospf_last_lookup[RTR_CNT];

#define __ospf_last_lookup	sim_ospf_last_lookup[_OSPF_INDEX]
#endif


/*
 * Choose the next best route
 * 	- Since we're just running OSPF and Static,
 * 	  OSPF will win.
 */
void
choose_proto(r)
OROUTE *r;
{
    int old_nh[MAXNH];
    int nh_is_diff = FALSE;
    int old_nh_cnt = RT_NH_CNT(r);
    int old_owner = RT_OWNER(r);
    int what = 0, i;

    for (i=0;i<old_nh_cnt;i++)
	old_nh[i] = RT_NH_NDX(r,i);

    printf("%s static: %d direct: %d ospf_ifchk %d\n",
		lntoa(RT_DEST(r)),
    		STATIC_INFO(r),
	     	RT_DIRECT(r),
		ospf_ifchk(RT_IO_NDX(r,0)));
    if (ORT_INFO(r)) {
	/*
	 * If there is a static route direct route set to ospf own
	 * for the purpose of testing but use the real (static) nexthop
	 */
    	if ( (STATIC_INFO(r)) &&
	     ((RT_DIRECT(r)) && ospf_ifchk(RT_IO_NDX(r,0))) )
	{
	    /*
	     * Note that the ospf entry and rtab entry may be different
	     * due to this direct static route
	     */
	    RT_PREF(r) = ORT_OSPF_PREF(r);
	    SET_OSPF_OWN(r);
	    RT_NH_NDX(r,0) =  STATIC_NH_NDX(r);
printf("ospf static nh: %s\n",lntoa(RT_NH(r,0)));
	    RT_NH_CNT(r) = 1;
	} else if ((ORT_PTYPE(r) == LS_ASE) && (STATIC_INFO(r))) {
	   /*
	    * If there is a static route that is different from the
	    * ospf external one, prefer the static one  
	    */
	    RT_PREF(r) = STATIC_PREF(r);
	    SET_STATIC_OWN(r);
	    RT_NH_NDX(r,0) = STATIC_NH_NDX(r);
	    RT_NH_CNT(r) = 1;
	} else {
	    RT_PREF(r) = ORT_OSPF_PREF(r);
	    SET_OSPF_OWN(r);
    	    for (i=0;i<DB_NH_CNT(ORT_V(r));i++)
	    	RT_NH_NDX(r,i) = (ORT_NH_NDX(r,i) = DB_NH_NDX(ORT_V(r),i));
	    RT_NH_CNT(r) = ORT_NH_CNT(r) = DB_NH_CNT(ORT_V(r));
	}
    } else if ((STATIC_INFO(r)) &&
	       (((RT_DIRECT(r)) && ospf_ifchk(RT_IO_NDX(r,0))) ||
		(!RT_DIRECT(r)))) {
	RT_PREF(r) = STATIC_PREF(r);
	SET_STATIC_OWN(r);
	RT_NH_NDX(r,0) = STATIC_NH_NDX(r);
	RT_NH_CNT(r) = 1;
printf("static nh: %s\n",lntoa(RT_NH(r,0)));
    } else if (RT_DISCARD(r)) {
	/* Discard route has lowest priority */
	SET_DISCARD_OWN(r);
	RT_NH_NDX(r,0) = 0;
	RT_NH_CNT(r) = 1;
    } else {
	RT_DELETE(r) = TRUE;
	RT_OWNER(r) = NO_OWNER;
	RT_NH_NDX(r,0) = 0;
	RT_NH_CNT(r) = 0;
    }

#ifdef DBG
    sprintf(_ospf_prt_buf,
	    "static info %d RT_DIRECT %d RT_IO_NDX %d ifchk %d\n",
	    STATIC_INFO(r),
	    RT_DIRECT(r),
	    RT_IO_NDX(r,0),
	    ospf_ifchk(RT_IO_NDX(r,0)));
    DBG_LOG(_ospf_prt_buf);
#endif

#ifdef BSD_TEST

    if (RT_OWNER(r) != DISCARD_OWNER) {
    	if (old_nh_cnt != RT_NH_CNT(r)) {
	    nh_is_diff = TRUE;
    	} else {
	    for (i=0;i<old_nh_cnt;i++)
	    	if (old_nh[i] != RT_NH_NDX(r,i)) {
		    nh_is_diff = TRUE;
		    break;
	    	}
    	}

    	if ((old_owner == NO_OWNER) && (RT_OWNER(r) != NO_OWNER)) {
	/* 
	 * Kernel add
	 */
	    what = RTM_ADD;
    	} else if ((old_owner != NO_OWNER) && (RT_OWNER(r) == NO_OWNER)) {
	/* 
	 * Kernel delete
	 */
	    what = RTM_DELETE;
    	} else if (nh_is_diff) {
	/* 
	 * Kernel change 
 	 */
	    what = RTM_CHANGE;
    	}

    	if (what && (!RT_DIRECT(r)))
    	{
	    krt_action(r,what,old_nh_cnt,old_nh);
    	}
    }
#endif

#ifdef DBG
    sprintf(_ospf_prt_buf,
	    "Choose_proto old owner: %d new: %d",
	    old_owner, RT_OWNER(r));
    DBG_LOG(_ospf_prt_buf);
#endif
}

void
delete_route(r)
OROUTE *r;
{

#ifdef DBG
    sprintf(_ospf_prt_buf, "OSPF Deleting route %s", lntoa(RT_DEST(r)));
    DBG_LOG(_ospf_prt_buf);
#endif
    /* unbind from lsdb struct */
    ORT_UNBIND(r);
    choose_proto(r);
    LOG_RTAB(2, MY_ID, RT_DEST(r));
}

/*
 * Add a discard route; a summarized route has been added
 */
int
add_discard_route(nr)
struct NET_RANGE *nr;
{
    OROUTE *r;

    r = RT_INSERT(nr->net,nr->mask,0,0,DISCARD_OWNER,0);
    /* Add fails? */
    if (!r)
	return(FLAG_NO_BUFS);
    choose_proto(r);
    return(FLAG_NO_PROBLEM);
}


/*
 * Delete a discard route; a summarized route has been deleted
 */
void
delete_discard_route(nr)
struct NET_RANGE *nr;
{
    OROUTE *r;

    if ((r = RT_FIND(nr->net)) == ROUTENULL)
	return;
    if (RT_DEST(r) != nr->net)
	return;
    RT_DISCARD(r) = FALSE;
    choose_proto(r);
}

/* MODIFIED (entire routine) 11/26 */
/*
 * Update this routing entry
 */
int
ospf_route_update(r, area, level)
OROUTE *r;
int level;
struct AREA *area;
{
    struct NET_RANGE *foundnr = NRNULL, *nr;
    struct LSDB *db = ORT_V(r);
    int should_run_build_inter = FALSE;
    int build_flag = 0;
    int choose_flag = FALSE;

    /* A few checks - some paranoid */
    if ((!(ORT_INFO(r))) || 
	(!db) || 
	(NO_GUTS(db)) || 
	((DB_WHERE(db)) == ON_ASE_LIST) ||
	(!((PTYPE_BIT(ORT_PTYPE(r))) & level)) ||
	((PTYPE_BIT(ORT_PTYPE(r)) & PTYPE_INTRA) && area != ORT_AREA(r)))
	return(FLAG_NO_PROBLEM);

#ifdef DBG
    sprintf(_ospf_prt_buf, "ORT_CHANGE: %s %d\n",
	    lntoa(RT_DEST(r)),
	    ORT_CHANGE(r));
    DBG_LOG(_ospf_prt_buf);
#endif
    /*
     * if internal to this area and this is a border rtr,
     * set cost - build_ls will figure out what to do
     */
    if (IAmBorderRtr) {
	if ( (PTYPE_BIT(ORT_PTYPE(r)) & PTYPE_INTRA) ||
    	     (ORT_CHANGE(r) == E_WAS_INTRA_NOW_ASE) || 
    	     (ORT_CHANGE(r) == E_WAS_INTER_NOW_INTRA) ) 
	{
	    /* Should only summarize if no virtual links */
	    for (nr = area->nr.ptr[NEXT]; nr != NRNULL; nr = nr->ptr[NEXT]) {
	    	/* check for net to be summarized */
	    	if ((nr->mask & RT_DEST(r)) == nr->net) {
		    foundnr = nr;
		    break;
	        }
	    }
	    if (!foundnr)
	    	should_run_build_inter = TRUE;
    	} else if ((PTYPE_BIT(ORT_PTYPE(r)) & PTYPE_INTER) && area == ospf.area)
		should_run_build_inter = TRUE;
    }

    /*
     * Check for invalid route:
     * - Revision != current revision &&
     * - Intra route && area that is currently running dijkstra == rt's area ||
     * - Inter or Ase route - correct level (inter or ase) is checked above
     */
    if ((ORT_REV(r) != RTAB_REV) &&
	(((PTYPE_BIT(ORT_PTYPE(r)) & PTYPE_INTRA) && area == ORT_AREA(r)) ||
	 (PTYPE_BIT(ORT_PTYPE(r)) & PTYPE_LEAVES))) {
	if (should_run_build_inter) {
	    /* delete inter-area route from other areas */
	    /* May be out of memory */
	    if (build_inter(db, area, E_DELETE))
		return(FLAG_NO_BUFS);
	
	}
	/* remove route from routing table */
	freeplist(db);	/* free parent list */
	delete_route(r);
	return(FLAG_NO_PROBLEM);
    }

    /* Set low cost for net range */
    if ( (foundnr && ORT_COST(r) < foundnr->cost) &&
    	 (ORT_CHANGE(r) != E_WAS_INTRA_NOW_ASE) )
	foundnr->cost = ORT_COST(r);

    /* Handle rtab changes */
    switch (ORT_CHANGE(r)) {
    	case E_NEW:
	    /* if border rtr and bb, add intra routes to all areas */
	    if ((ORT_AREA(r) == area) && (should_run_build_inter)) {
		build_flag = E_NEW;
	    }
	    break;

    	case E_WAS_INTER_NOW_INTRA:
	    if (should_run_build_inter) 
		build_flag = E_NEW;
	    else /* Have to delete more specific inter-area route */
 		if ( (IAmBorderRtr) && 
		      foundnr && 
		      foundnr->net != DB_NETNUM(db) )
		build_flag = E_DELETE;
	    choose_flag = TRUE;
	    break;

    	case E_WAS_INTRA_NOW_ASE:
	    if (should_run_build_inter) 
		build_flag = E_DELETE;
	    choose_flag = TRUE;
	    break;

    	case E_WAS_INTER_NOW_ASE:
	    build_flag = E_DELETE;
	    choose_flag = TRUE;
	    break;

	case E_WAS_ASE:
	case E_NEXTHOP:
    	case E_WAS_INTRA_NOW_INTER:
	    if ((ORT_AREA(r) == area) && should_run_build_inter)
	    	build_flag = ORT_CHANGE(r);

	case E_METRIC:
	case E_ASE_METRIC:
	case E_ASE_TYPE:
	case E_ASE_TAG:
	    choose_flag = TRUE;
	    break;
    }

    if (build_flag && (build_inter(db, area, build_flag)))
	return(FLAG_NO_BUFS);
    if (choose_flag)
	choose_proto(r);

    ORT_CHANGE(r) = E_UNCHANGE;
    return(FLAG_NO_PROBLEM);
}

/*
 * ntab_update()
 *	- called by routine who knows which levels have been run before
 * 	- process all routes from this level up
 *      - notify changed or new net routes to real routing table
 *	- notify real routing table of deleted net routes
 *        routes are deletable if:
 *		intra && area == r->area && r->spfcnt != RTAB_REV
 *		inter && r->spfcnt != RTAB_REV
 *		ase && r->spfcnt != RTAB_REV
 */
int
ntab_update(area, level)
struct AREA *area;
int level;
{
    struct NET_RANGE *nr;
    int ret_flag;

    if (IAmBorderRtr)			/* set up for net_sum */
	for (nr = area->nr.ptr[NEXT];
	     nr != NRNULL;
	     nr = nr->ptr[NEXT])
	    nr->cost = SUMLSInfinity;

    ret_flag = RT_WALK(ospf_route_update, area, level);
    return(ret_flag);
}


OROUTE *
findroute(id, ptype)
u_long32 id;
int ptype;
{
    OROUTE *r;

    __ospf_last_lookup = ROUTENULL;

    if ((r = RT_FIND(id)) == ROUTENULL)
	return (ROUTENULL);

    /* 
     * save a lookup for build_route 
     */
    if (RT_DEST(r) == id)
	__ospf_last_lookup = r;

    if ( (!ORT_INFO(r)) || 
	 (RT_DELETE(r)) ||
	 (RT_DEST(r) != id) ||
	 (!(PTYPE_BIT(ORT_PTYPE(r)) & ptype)) )
	    return (ROUTENULL);

    return(r);
}


/*
 * Bind this route to this vertex 
 */
/* MODIFIED 1/10 */
void
rvbind(r,v,a)
OROUTE *r;
struct LSDB *v;
struct AREA *a;
{

	int oldtype = ORT_PTYPE(r), i;
	time_t 	timestamp;
	int nh_is_diff = FALSE;

	if (DB_NH_CNT(v) != RT_NH_CNT(r)) {
	    nh_is_diff = TRUE;
	} else {
	    for (i=0;i<DB_NH_CNT(v);i++)
		if (DB_NH_NDX(v,i) != ORT_NH_NDX(r,i)) {
		    nh_is_diff = TRUE;
		    break;
		}
	}

#ifdef DBG
	sprintf(_ospf_prt_buf,"In rvbind net: %s type: %d",
			lntoa(LS_ID(v)),LS_TYPE(v));
	DBG_LOG(_ospf_prt_buf);
#endif
	/* 
	 * set up links 
	 */
	if (ORT_V(r))  {
		timestamp = DB_TIME(ORT_V(r));
            	DB_ROUTE(ORT_V(r)) = ROUTENULL;
	}
	ORT_CHANGE(r) = E_UNCHANGE;

	if (LS_TYPE(v) == LS_ASE) 
	{
	    if (oldtype != LS_ASE) {
		/* MODIFIED 11/26 */
    	    	if ((IAmBorderRtr) && (PTYPE_BIT(oldtype) & PTYPE_INTRA))
			ORT_CHANGE(r) = E_WAS_INTRA_NOW_ASE;
    	    	else if ((IAmBorderRtr) && (PTYPE_BIT(oldtype) & PTYPE_INTER))
			ORT_CHANGE(r) = E_WAS_INTER_NOW_ASE;
		else ORT_CHANGE(r) = E_NEXTHOP;
	    } else {
		/* MODIFIED 1/13 */
		/* If nh is diff or both arrived at same time - flag change */
		if (nh_is_diff || timestamp == DB_TIME(v)) {
		    /* Next hop change */
		    ORT_CHANGE(r) = E_NEXTHOP;
		} else if (ASE_TYPE2(v) != ORT_ETYPE(r)) {
		    ORT_CHANGE(r) = E_ASE_TYPE;
		} else if (DB_ASE_TAG(v) != ORT_ASE_TAG(r)) {
		    /* Tag Change */
		    ORT_CHANGE(r) = E_ASE_TAG;
		} else if ((DB_DIST(v) != ORT_COST(r)) ||
			   (BIG_METRIC(v) != ORT_TYPE2COST(r))) {
		    /* Metric change */
		    ORT_CHANGE(r) = E_ASE_METRIC;
		}
	    }
	} else {
	    if (oldtype == LS_ASE) {
		ORT_CHANGE(r) = E_WAS_ASE;
	    } else if ( (oldtype == LS_SUM_NET) &&
			 (PTYPE_BIT(LS_TYPE(v)) & PTYPE_INTRA) ) {
		ORT_CHANGE(r) = E_WAS_INTER_NOW_INTRA;
	    } else if ( (PTYPE_BIT(oldtype) & PTYPE_INTRA) && 
			(LS_TYPE(v) == LS_SUM_NET) ) {
		ORT_CHANGE(r) = E_WAS_INTRA_NOW_INTER;
	    } else if (nh_is_diff || timestamp == DB_TIME(v)) {
		/* MODIFIED 1/13 */
		ORT_CHANGE(r) = E_NEXTHOP;
	    }
	    DB_WHERE(v) = ON_RTAB;
	}

	/* 
	 * Set to current revision
	 */
    	ORT_REV(r) = RTAB_REV;

    	/* 
	 * Link routing table entry to LSDB 
	 */
    	ORT_V(r) = v;
    	DB_ROUTE(v) = r;

        ORT_PTYPE(r) = LS_TYPE(v);
	ORT_AREA(r) = a;
	ORT_COST(r) = DB_DIST(v);
	for (i=0;i<DB_NH_CNT(v);i++)
	    ORT_NH_NDX(r,i) = DB_NH_NDX(v,i);
	ORT_NH_CNT(r) = DB_NH_CNT(v);
	ORT_ADVRTR(r) = ADV_RTR(v);
  	/* MODIFIED 12/20 */
	ORT_ETYPE(r) = FALSE;
	if (LS_TYPE(v) == LS_ASE) {
	    if (ASE_TYPE2(v)) {
		ORT_ETYPE(r) = TRUE;
		ORT_TYPE2COST(r) = BIG_METRIC(v);
	    }
	    ORT_ASE_TAG(r) = DB_ASE_TAG(v);
	}
}


/*
 * nexthop_cmp() - for intra and inter area networks
 *	Compare old next hop from routing table to new one in the vertex
 *		and mark the changes accordingly
 */
void
nexthop_cmp(r, v)
OROUTE *r;
struct LSDB *v;
{
    int nh_is_diff = FALSE;
    int i;

    if (DB_NH_CNT(v) != RT_NH_CNT(r)) {
        nh_is_diff = TRUE;
    } else {
        for (i=0;i<DB_NH_CNT(v);i++)
	    if (DB_NH_NDX(v,i) != ORT_NH_NDX(r,i)) {
		nh_is_diff = TRUE;
		break;
	    }
    }

    if (nh_is_diff) {
	for (i=0;i<DB_NH_CNT(v);i++)
	    ORT_NH_NDX(r,i) = DB_NH_NDX(v,i);
	ORT_NH_CNT(r) = DB_NH_CNT(v);
	ORT_COST(r) = DB_DIST(v);
	ORT_CHANGE(r) = E_NEXTHOP;
    } else if (DB_DIST(v) != ORT_COST(r)) {
	ORT_COST(r) = DB_DIST(v);
	ORT_CHANGE(r) = E_METRIC;
    } else
	ORT_CHANGE(r) = E_UNCHANGE;
}

/*
 * Compare ASE nexthops and note the change type
 *	Compare old next hop from routing table to new one in the vertex
 *		and mark the changes accordingly
 *	equal-cost compares will go here
 */
void
ase_nexthop_cmp(r, v)
OROUTE *r;
struct LSDB *v;
{
    int nh_is_diff = FALSE;
    int i;

    if (DB_NH_CNT(v) != RT_NH_CNT(r)) {
        nh_is_diff = TRUE;
    } else {
        for (i=0;i<DB_NH_CNT(v);i++)
	    if (DB_NH_NDX(v,i) != ORT_NH_NDX(r,i)) {
		nh_is_diff = TRUE;
		break;
	    }
    }

    ORT_CHANGE(r) = E_UNCHANGE;

    if (nh_is_diff) {
	/* Next hop change */
	ORT_CHANGE(r) = E_NEXTHOP;
    } else if (ASE_TYPE2(v) != ORT_ETYPE(r)) {
	ORT_CHANGE(r) = E_ASE_TYPE;
    } else if (DB_ASE_TAG(v) != ORT_ASE_TAG(r)) {
	/* Tag Change */
	ORT_CHANGE(r) = E_ASE_TAG;
    } else if ((DB_DIST(v) != ORT_COST(r)) ||
	       (BIG_METRIC(v) != ORT_TYPE2COST(r))) {
	/* Metric change */
	ORT_CHANGE(r) = E_ASE_METRIC;
    }

    if (ORT_CHANGE(r) != E_UNCHANGE)
    {
	/* 
	 * Make sure info is up to date 
	 */
	for (i=0;i<DB_NH_CNT(v);i++)
	    ORT_NH_NDX(r,i) = DB_NH_NDX(v,i);
	ORT_NH_CNT(r) = DB_NH_CNT(v);
	ORT_COST(r) = DB_DIST(v);
	ORT_PTYPE(r) = LS_TYPE(v);
	ORT_ADVRTR(r) = ADV_RTR(v);
  	/* MODIFIED 12/20 */
	ORT_ETYPE(r) = FALSE;
	if (ASE_TYPE2(v)) {
	    ORT_ETYPE(r) = TRUE;
	    ORT_TYPE2COST(r) = BIG_METRIC(v);
	}
	ORT_ASE_TAG(r) = DB_ASE_TAG(v);
    }
}


/*
 * Allocate route and install it in the routing table
 */
int
build_route(a, v)
struct AREA *a;				/* associatiated area */
struct LSDB *v;
{
    OROUTE r, *old;
    int hadroute = FALSE;

    old = __ospf_last_lookup;
    if ((old) && (RT_DEST(old) == DB_NETNUM(v))) {
	hadroute = TRUE;
    } else {
	CLEAR_BUF(&r, sizeof(OROUTE));
	RT_DEST(&r) = DB_NETNUM(v);
	RT_MASK(&r) = DB_MASK(v);
	RT_PREF(&r) = OSPF_ROUTE_PREF;
	old = &r;
    }

    if (!ORT_INFO(old)) {
	ORT_INFO_ALLOC(old);
	/* 
	 * If alloc not OK will rerun Dijkstra in 5 seconds 
	 */
	if (!ORT_INFO(old))
	    return(FALSE);
    }
    ORT_REV(old) = RTAB_REV;
    ORT_AREA(old) = a;
    ORT_COST(old) = DB_DIST(v);
    ORT_PTYPE(old) = LS_TYPE(v);
    ORT_ADVRTR(old) = ADV_RTR(v);
    ORT_OSPF_PREF(old) = OSPF_ROUTE_PREF;
    if (LS_TYPE(v) == LS_ASE) {
	if (ASE_TYPE2(v))
    	{
	    ORT_ETYPE(old) = TRUE;
	    ORT_TYPE2COST(old) = BIG_METRIC(v);
        }
	ORT_ASE_TAG(old) = DB_ASE_TAG(v);
    }
    ORT_V(old) = v;
    ORT_CHANGE(old) = E_NEW;

    if (!hadroute) {
	DB_ROUTE(v) = RT_INSERT(DB_NETNUM(v),
				DB_MASK(v),
				&DB_NH_NDX(v,0),
				DB_NH_CNT(v),
				PR_OSPF,
				ORT_INFO(old));
	if (!DB_ROUTE(v)) {
	    ZAP(ORT_INFO(old),OMEM_ORT_INFO);
	    return (FALSE);
	}
    } else {		/* had in lsdb that didn't have ospf as author */
	DB_ROUTE(v) = old;
    }
    choose_proto(DB_ROUTE(v));
    return (TRUE);
}
