/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"
#include <signal.h>

#ifdef	PROTO_OSPF


/*
 * Keep a delta queue of timer events
 */
void
insert_tq(new)
struct OTIMER *new;
{
    struct OTIMER *t;

    if (timerq.ptr[NEXT] == OTIMERNULL) {	/* none on queue */
	timerq.ptr[NEXT] = new;
	new->ptr[LAST] = &timerq;
	return;
    }
    for (t = &timerq;
	 t->ptr[NEXT] != OTIMERNULL && TMR_CMP(new, t->ptr[NEXT]);
	 t = t->ptr[NEXT]) {
	TMR_SUB(new, t->ptr[NEXT]);
    }
    if (t->ptr[NEXT]) {
	TMR_SUB(t->ptr[NEXT], new);
	t->ptr[NEXT]->ptr[LAST] = new;
    }
    /*
     * put after t and before t->ptr[NEXT]
     */
    new->ptr[NEXT] = t->ptr[NEXT];
    t->ptr[NEXT] = new;
    new->ptr[LAST] = t;
}

struct OTIMER *
makealarm(set, reset, type, routine, tq_data)
long set, reset;
int type;
void *tq_data;
void (*routine) ();
{
    struct OTIMER *tmr;

    OTIMER_ALLOC(tmr);
    SEC_SET(tmr) = set;			/* only seconds needed */
    SEC_RESET(tmr) = reset;
    tmr->type = type;
    tmr->routine = routine;
    tmr->tq_data = tq_data;
    return (tmr);
}


/*
 * The timerq interrupt handler routine
 */
void
tqhandler()
{

    int oldmask;
    struct OTIMER *new;

    sig_block(&oldmask);
    if (!timerq.ptr[NEXT])
	adios("tqhandler: queue is empty\n");
    ospf_get_sys_time();

  gottimeout:

    /* ospf_stash_refresh(); */
    /* dequeue current from timerq */
    new = timerq.ptr[NEXT];
    DEL_Q(new, FALSE, OMEM_TIMER);

    /* call routine if there is one */
    if (new->routine)
	new->routine(new);

    /* if there is a reset value install it on timerq */
    if (SEC_RESET(new) > 0) {
	SEC_SET(new) = SEC_RESET(new);
	insert_tq(new);
    }
    if (timerq.ptr[NEXT]) {
	if (SEC_SET(timerq.ptr[NEXT]) > 0) {
	    sys_timer_set(timerq.ptr[NEXT]);
	} else {
	    /* next alarm has expired (was = to current) */
	    goto gottimeout;
	}

    }
    sig_restore(oldmask);		/* restore signals */
}

/*
 * Initialize interface timers
 */
void
intf_init(intf, offset)
struct INTF *intf;
int offset;
{
#ifdef DBG
    sprintf(_ospf_prt_buf, "%d %d %d\n",
	    intf->retrans_timer,
	    (intf->retrans_timer / 2),
	    intf->hello_timer);
    DBG_LOG(_ospf_prt_buf);
#endif
    /* set an alarm per interface for retrans */
    addalarm((intf->retrans_timer + offset),
	     intf->retrans_timer,
	     TQRetrans, tq_retrans, (void *) intf);
    /* set ack timer to approx. 1/2 of retrans timer */
    addalarm(((intf->retrans_timer / 2) + offset),
	     (intf->retrans_timer / 2),
	     TQAck, tq_ack, (void *) intf);
    /* set hello timer */
    addalarm((intf->hello_timer + offset),
	     intf->hello_timer,
	     TQHelloTimer, tq_hellotmr, (void *) intf);

#ifdef UMBC_SIM
    intf->admstat = OSPF_INTF_ENABLE;
#endif
    if ((INTF_STATUS_CHANGE(intf)) &&
	(intf->type != VIRTUAL_LINK) &&
	(intf->admstat == OSPF_INTF_ENABLE))
	(*(if_trans[INTF_UP][IDOWN])) (intf);
}

/*
 *   Initialize ospf-wide timers
 */
void
ospf_sys_init()
{
    /* Age intra lsdb entries */
    addalarm(DbAgeTime,
	     DbAgeTime,
	     TQIntLsdbAge,
	     tq_int_age, (void *) 0);
    /* Age summary lsdb entries */
    addalarm(DbAgeTime + OFF1,
	     DbAgeTime,
	     TQSumLsdbAge,
	     tq_sum_age, (void *) 0);
    /* Age ase lsdb entries */
    addalarm(OFF2,
	     AseAgeTime,
	     TQAseLsdbAge,
	     tq_ase_age, (void *) 0);

    /* set lsa update intervals */
    addalarm(LSRefreshTime + OFF3,
	     LSRefreshTime,
	     TQIntLsa,
	     tq_IntLsa, (void *) 0);
    /* Area border router */
    if (IAmBorderRtr)
	addalarm(LSRefreshTime + OFF4,
		 LSRefreshTime,
		 TQSumLsa,
		 tq_SumLsa, (void *) 0);
    /* Autonomous System border rtr - start up in a few minutes */
    addalarm(((DbAgeTime + OFF5) / 2),
		 LSRefreshTime,
		 TQAseLsa,
		 tq_AseLsa, (void *) 0);

}


/*
 * Initialize ospf timers
 */
void
timerqinit()
{
    struct AREA *a;
    struct INTF *intf;
    int intf_off = 0;			/* second offset for timers */
    int i;
    int area_off = 0;			/* area offset for timers */
    struct LSDB_LIST *txq = LLNULL;

    /* Set timers for non-virtual interfaces */
    for (a = FirstArea;
	 a < &(ospf.area[ospf.acnt]);
	 area_off++, a++) {
	for (intf = a->intf; intf < &(a->intf[a->ifcnt]); intf++, intf_off++) {
	    intf_init(intf, intf_off);
	}
	/* LsaLock for net and router lsa locks */
	addalarm(MinLSInterval + area_off,
		 MinLSInterval,
		 TQLsaLock,
		 tq_lsa_lock, (void *) a);

	/* build_rtr and run spf */
	a->build_rtr = FALSE;
	a->spfsched |= build_rtr_lsa(a, &txq, 0);

	/* generate default summary for area */
	if (IAmBorderRtr && (a->ext_option == EXT_OPT_STUB))
	    build_sum_dflt(a);

	/* generate default ase */
	if (IAmASBorderRtr && ospf.dflt_metric)
	    build_ase_dflt();

	run_spf(a, 0);
	freeq(&txq, OMEM_LL);
    }
    /* Set timers for virtual links */
    if (IAmBorderRtr && ospf.vcnt)
	for (i = 0; i < ospf.vcnt; i++)
	    intf_init(&(ospf.vl[i]), 0);

    /* initialize ospf-wide timers */
    ospf_sys_init();

}

#endif
