/*
 * Send a HELLO pkt with a bad length in the hdr.
 *
 * $Id: hello-badver.c,v 1.1 1999/08/10 18:07:55 naamato Exp $
 */

#include <stdio.h>

#include "rps.h"
#include "rps_ospf.h"
#include "common.h"
#include "ospf_type.h"


#define HELLO_PKT_LEN		(OSPF_HDR_SIZE + HELLO_PACKET_SIZE)
#define HOST			0xc0a80c72 /* arten12 (192.168.12.114) 	*/
#define MASK			0xffffff00 /* 255.255.255.0 		*/
#define ROUTERID		0x00000002
#define INTF			0xc0a80c67 /* smock12 (192.168.12.103	*/

#define HELLOINTERVAL		OSPF_HELLOTIMER
#define ROUTERDEADINTERVAL	OSPF_ROUTERDEAD

int
main()
{
	int sock;
	struct HELLO_PKT hello;
	u_short len;
	u_long dst;
	struct in_addr addr;

	if ((sock = get_raw_sock()) < 0) {
		fprintf(stderr, "socket init failed.\n");
		exit(1);
	}

	len = HELLO_PKT_LEN;
	bzero(&hello, sizeof(hello));

	hello.hdr.type = (u_char) htons(1);

	/* bad version */
	hello.hdr.ver = 50;

	hello.hdr.length = htonl(len);

	hello.hdr.rt_id = htonl(ROUTERID);
	hello.hdr.authtype = OSPF_AUTHTYPE_NONE;

	hello.hdr.chcksum = 0;
	hello.hdr.auth[0] = hello.hdr.auth[1] = 0;

	hello.netmask = htonl(MASK);
	hello.hello_int = htons(HELLOINTERVAL);
	hello.dead_int = htonl(ROUTERDEADINTERVAL);
	hello.priority = htons(1);
	hello.options = E_OPTION;

	hello.hdr.chcksum = in_cksum((u_short *)&hello, len);

	dst = OSPF_ALLSPF_ADDR;
	addr.s_addr = htonl(INTF);

	if (setsockopt(sock, IPPROTO_IP, IP_MULTICAST_IF,	
	    (char *)&addr, sizeof(addr)) < 0) {
		perror("setsockopt");
		exit(1);
	}
	
	ospf_txpkt(sock, (char *)&hello, len, htonl(dst));
}
