/* $Id: crpadv.c,v 1.1 1999/08/23 16:18:29 naamato Exp $ */
/*
 * Copyright(c) 1998 by Hitachi.Ltd All rights reserved.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include "pim_def.h"

#define IF_NAME_SIZE 8

void parse_file();
void timer();

char usage[] = "Usage: crpadv [-i interface] [-s src_addr]  [-p priority] [-f list ] [-g group/masklen] [-n num] [-h holdtime] [-C count] -d dst_addr -r rp_addr\n";

int time_expire;

main(argc, argv)
int argc;
char **argv;
{
    char opt;
    extern char *optarg;
    u_long src,dst,rp_addr;
    u_long group,mask;
    u_short holdtime;
    u_char pri;
    FILE *fp;
    char *if_name;
    int num,count;
#ifndef SOLARIS
    struct sigvec sigv;
#endif

    src = dst = rp_addr = 0;
    if_name = NULL;
    fp = NULL;
    num = 0;
    holdtime = PIM_RP_HOLDTIME;
    count = 1;

    while((opt = getopt(argc,argv,"i:d:s:f:h:p:r:g:n:C:")) != -1) {
        switch(opt) {
	case 'i' : if_name = malloc(IF_NAME_SIZE);
	           strcpy(if_name,optarg);
	           break;
	case 'd' : dst = inet_stoa(optarg);
	           break;
	case 'h' : holdtime = (u_short)atoi(optarg);
	           break;
	case 'f' : if(!(fp = fopen(optarg,"r")))
	               printf(" %s open error \n",optarg);
	           break;
	case 'p' : pri = (u_char)atoi(optarg);
	           break;
	case 's' : src = inet_stoa(optarg);
	           break;
	case 'r' : rp_addr = inet_stoa(optarg);
	           break;
	case 'g' : prefix_parse(optarg,&group,&mask);
	           num = 1;
	           break;
	case 'n' : num = atoi(optarg);
	           break;
	case 'C' : count = atoi(optarg);
	           break;
	default:   fprintf(stderr,usage);
	           exit(1);
	}
    }

    if(!dst || !rp_addr) {
        fprintf(stderr,usage);
	exit(1);
    }

    interface_init();

    pim_init();
    add_crp_list(0,rp_addr,holdtime,pri);
    if(fp) parse_file(fp);
    if(num) build_grp_list(group,mask,num);

#ifdef SOLARIS
    sighold(SIGALRM);
    sigset(SIGALRM,timer);
#else
    bzero((char *)&sigv, sizeof(sigv));
    sigv.sv_flags = 0;
    sigv.sv_handler = timer;
    sigv.sv_mask = 0;
    sigvec(SIGALRM, &sigv, (struct sigvec *)NULL);
#endif

    time_expire = 1;
    while(count) {
        if(time_expire) {
	    pimsm_crp_send2(if_name,src,dst,rp_addr,holdtime,pri,0);
            time_expire = 0;
            count--;
            alarm(PIM_CRP_ADV_PERIOD);
        }
    }
}

void parse_file(fp)
FILE *fp;
{
    char c,buf[256],*bufp;
    u_long grp,mask;
    int holdtime;

    bufp = buf;
    grp = mask = 0;
    while((c=getc(fp)) != EOF) {
        if(c == 0x0a) {
	    *bufp = '\0';
	    prefix_parse(buf,&grp,&mask);
#if 0
	    add_grp_list(grp,mask);
#endif
	    add_crp_group(0,grp,mask);
	    bzero(buf,256);
	    bufp = buf;
	}
	else {
	    *bufp++ = c;
	}
    }
	
}

void timer()
{
    time_expire = 1;
}
