/*
 *  krt_symbols_sysctl.c,v 1.4.2.1 1994/08/15 20:24:03 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */


#define       INCLUDE_UDP
#define       INCLUDE_UDP_VAR
#define       INCLUDE_KVM
#include "include.h"
#ifdef        PROTO_INET
#include "inet.h"
#endif        /* PROTO_INET */
#include "krt.h"
struct __kvm {
    int kvm_fd;
    const char *kvm_nl;
    const char *kvm_core;
    const char *kvm_swap;
    char kvm_errmsg[BUFSIZ];
};
#include "krt_var.h"
#include <sys/ksym.h>

int
krt_symbols __PF1(tp, task *)
{
    char buf[BUFSIZ];
    struct mioc_rksym rks;

    rks.mirk_symname = KSYM_VERSION;
    rks.mirk_buf = buf;
    rks.mirk_buflen = sizeof(buf);
    if (ioctl(kd->kvm_fd, MIOC_READKSYM, &rks) < 0) {
      trace_log_tp(tp,
                   0,
                   LOG_INFO,
                   ("krt_symbols: mioc(KSYM_VERSION): %m"));
    } else {
      /* Set version */

      krt_version_kernel = task_mem_strdup(tp, buf);
      trace_tp(tp,
               TR_KRT_SYMBOLS,
               0,
               ("krt_symbols: kernel version: %s\n",
                krt_version_kernel));
    }

#ifdef        PROTO_INET
    rks.mirk_symname = KSYM_IPFORWARDING;
    rks.mirk_buf = buf;
    rks.mirk_buflen = sizeof(int);
    if (ioctl(kd->kvm_fd, MIOC_READKSYM, &rks) < 0) {
      trace_log_tp(tp,
                   0,
                   LOG_INFO,
                   ("krt_symbols: mioc(KSYM_IPFORWARDING): %m"));
    } else {
      inet_ipforwarding = *(int *)buf;
      trace_tp(tp,
               TR_KRT_SYMBOLS,
               0,
               ("krt_symbols: IP forwarding: %u\n",
                inet_ipforwarding));
    }

    rks.mirk_symname = KSYM_UDPCKSUM;
    rks.mirk_buf = buf;
    rks.mirk_buflen = sizeof(int);
    if (ioctl(kd->kvm_fd, MIOC_READKSYM, &rks) < 0) {
      trace_log_tp(tp,
                   0,
                   LOG_INFO,
                   ("krt_symbols: mioc(KSYM_UDPCKSUM): %m"));
    } else {
      inet_udpcksum = *(int *)buf;
      trace_tp(tp,
               TR_KRT_SYMBOLS,
               0,
               ("krt_symbols: UDP checksum: %u\n",
                inet_udpcksum));
    }
#endif        /* PROTO_INET */
    
    trace_tp(tp,
           TR_KRT_SYMBOLS,
           0,
           (NULL));

    return 0;
}

