
/* 
 * $Id: idrp_rt_ribs.c,v 1.1 1995/10/08 17:05:20 skh Exp $
 * Merit IDRP release 3.0 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */
 
/* idrp_ribs.c
 *  Susan Hares Merit/NSFNET. 
 *
 * idrp_free_rib() - move to idrp_init eventually (here just to test the idrp_ribs.c
 */

#include "include.h"
#include "idrp.h"

void
idrp_free_rib(p_rib)
idrp_qos_rib	*p_rib;
{
int	rib_id;

	/* free the following assigned
	 * information
	 * 	
	 * 1) kernel string
	 * 2) update pdu string 
	 * 3) open pdu  	
	 */

	idrp_mem_fit_free((void **)&p_rib->p_qos_str,p_rib->kern_len);
	idrp_mem_fit_free((void **)&p_rib->p_update_pdu,IDRP_UPDATE_QOS_MAX_LENGTH);
	idrp_mem_fit_free((void **)&p_rib->p_open_pdu,IDRP_OPEN_QOS_MAX_LENGTH);

}

int
rib_supported(p_qos)
idrp_distinguish_att	*p_qos;
{
int		rib_id;
idrp_qos_rib	*p_rib;

	QOS_RIB_LIST(rib_id)
		{
		p_rib = qos_rib[rib_id];
		if (p_rib->att.idrp_mask != p_qos->idrp_mask)
			continue;
	 
                /* test delay values */

                if (p_rib->att.delay.value != p_qos->delay.value)
			continue;
		
                if (p_rib->att.error.value != p_qos->error.value)
			continue;
                
		if (p_rib->att.expense.value != p_qos->expense.value)
			continue;
		
		if (p_rib->att.priority.value != p_qos->priority.value)
			continue;

		if (p_rib->att.sec_type.value != p_qos->sec_type.value)
			continue;

		if (p_rib->att.sec_value.value != p_qos->sec_value.value)
			continue;

		return(rib_id);
		} QOS_RIB_LIST_END	

	return(FALSE);


}


