/* 
 * $Id: idrp_globals.c,v 1.9 1995/10/08 17:04:44 skh Exp $
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

#include "include.h"
#include "iso.h"
#include "idrp.h"

/* Options */

/* flow control */

int acked_something;		/* True if last received packet acknowledged something */

/* task interface */

int doing_idrp = FALSE;		/* Are we running IDRP protocols? */
int idrp_reparsing = FALSE;	/* idrp is reparsing */
boolean idrp_rdi_change = FALSE; /* idrp_rdi_change occurred */

task *idrp_master_task;		/* IDRP master task block */
flag_t idrp_trace_flags;	/* Trace flags from parser */
trace *idrp_trace_options;      /* Trace options froms parser */
int   idrp_default_preference;      /* default preference */

/* task block pointers for allocation of space in task block initialization */

block_t		idrp_big_block_index = NULL;
block_t		idrp_small_blk_index = NULL;
block_t		idrp_med_blk_index = NULL ;
block_t		idrp_huge_blk_index = NULL ;

/* idrp variables for unix sockets */

u_short idrp_port = IDRP_PORT;	/* IDRP well known port */

/* global addresses for IP and OSI */
/* addresses for this box */
/* ip addresses - rt_ip_rdi - must have match to AS */
/* look at this again prior to moving to IP */

struct iso_net_addr rt_rdi;				/* Our routing domain identifier */
rdi		    *p_rt_rdi;		/* pointer to routing domain identifier in global list */
rdpath_list	    *p_my_rdpath;	/* ponter to my rdpath in global list */
RD_path		    local_rd_path;	/* fake RD pathway structure for local routes */	

int		    rt_net_cnt;				/* count of nets */
struct iso_net_addr rt_net[IDRP_MAX_LOCAL_NETS];	/* Our network entity title %% */
struct iso_net_addr rt_as_rdi;				/* our Mapping from AS to RDI */ 
snpa_list	rt_snpa;				/* snpa for this node */

/* IP information */

struct iso_net_addr rt_ip_rdi;				/* Our Routing Domain identifier for IP */
							/* only if we are running SIN idrp */
							/* for IP and OSI */ 

sockaddr_un rt_ip_net[IDRP_MAX_LOCAL_NETS];		/* our IP address for NET */
int	    rt_ip_net_cnt;				/* cnt of nets  */


/* local route information */

int		idrp_local_route_cnt;	/* count of local route blocks */
route_separator idrp_local_route_id;	/* our local route id - negative */
int local_hop_count;			/* our local hop count - zero */


/* link list of idrp neighbors - IP and OSI depends only on the address inside */

int	idrp_neighbors = 0;		/* Count of neighbors */
int	idrp_ext_neighbors = 0;		/* Count of external neighbors */
int	idrp_int_neighbors = 0;		/* Count of external neighbors */
int	idrp_n_disabled = 0;		/* configured but disabled neighbors */
int	idrp_n_established = 0;		/* established IDRP neighbors */ 
int 	idrp_n_ext_established = 0;	/* Unused? */

idrpPeer *idrp_peers;            /* front of linked list of IDRP peers */
idrpPeer *idrp_peers_end;        /* last of linked list of IDRP peers */

idrpPeer *idrp_ext_peers;        /* pointer to first external peer */
idrpPeer *idrp_last_int_peer;    /* pointer to last intternal peer */

idrpPeer idrp_this_node;         /* peer structure for this node */
				 /* used for local routes */

RD_path		local_rd_path;		/* fake RD pathway structure */ 
					/* for local routes */

int	consistency_errors;		/* consistency errors */

pref_t idrp_ext_def_pref = RTPREF_IDRP_EXT; /* external default preference */
pref_t idrp_int_def_pref = RTPREF_IDRP_INT; /* internal default preference */

/* qos rib information 
 * - maximum plus default 
 */
int	rib_cnt;
int	last_rib_cnt;

#ifdef	IDRP_QOS
u_int           qos_rib_changed;                /* flag in qos_rib */
idrp_qos_rib     *qos_rib[IDRP_MAX_QOS_RIBS+1];
idrp_qos_rib	*last_qos_rib[IDRP_MAX_QOS_RIBS+1];
#endif

/* attribute and RD pathway  lists */


#ifdef IDRP_QOS

idrp_attribute_record 	*idrp_attr_list[IDRP_MAX_QOS_RIBS+1];	/* linked list of attributes */
idrp_att_list 		*idrp_oatt_list[IDRP_MAX_QOS_RIBS+1];	/* linked list of output only attributes */

/* previous values of attribute list used in reconfiguations specified in the 
 * 
 */
 
idrp_attribute_record 	*last_attr_list[IDRP_MAX_QOS_RIBS+1];	/* linked list of attributes */
idrp_att_list 		*last_oatt_list[IDRP_MAX_QOS_RIBS+1];	/* linked list of output only attributes */

#else /* IDRP_QOS */

idrp_attribute_record 	*idrp_attr_list;	/* linked list of attributes */
idrp_att_list 		*idrp_oatt_list;	/* linked list of output only attributes */
#endif

rdi		      *rdi_list;	/* global rdi list - each rdi listed once */
idrp_rdpath_hash      *rd_path_list_hash[IDRP_RDPATH_HASH_SIZE];	
idrp_canon_rdpath     *canon_rd_list;	/* linked list of rd paths */

/* stuff for best external routes pseudo-RIB */

idrp_best_ext *ber_rib_head = NULL;	/* points to beginning of best external */

/* add structure for adding to table */
/* idrp pdu buffer */

idrpPdu	*idrp_send_buffer;		/* buffer for sending idrp pdu */

/* Policy definitions for idrp */
/* below comment carried over from idrp_init.c */
/* why are policy definitions not here??? */
/* why no definition of idrp_import_list, idrp_export_list */

int notifyLengths[];		/* Lengths of notifyData */
metric_t idrp_default_metric;	/* Default IDRP metric to use */

adv_entry *idrp_import_list = (adv_entry *) NULL;	/* List of IDRP import policies by RDI */
adv_entry *idrp_import_list_any_rdi = (adv_entry *) NULL;	/* List of IDRP import policies for ANY RDI */
adv_entry *idrp_import_rdpath_list = (adv_entry *) NULL;	/* List of IDRP RD path import policies */
adv_entry *idrp_export_list = (adv_entry *) NULL;	/* List of IDRP export entries */
adv_entry *idrp_export_list_any_rdi = (adv_entry *) NULL;	/* List of IDRP export policies for ANY RDI */

/* idrp protocol states */
 
bits idrpStates[] =		/* Values of the states */
{
	{0, ""},
	{IDRP_CLOSED, "Closed"},
	{IDRP_OPEN_RCVD, "Open_received"},
	{IDRP_OPEN_SENT, "Open_sent"},
	{IDRP_CLOSE_WAIT, "Close_wait"},
	{IDRP_ESTABLISHED, "Established"},
	{-1}
};

/* should this change to bits??? */

char *idrpManagementEvents[] =	/* Names of IDRP management events */
{
	"bad length",
	"bad PDU type",
	"bad PDU header error",
	"bad ERROR pdu",

};

char *idrpTypes[] =		/* Names of IDRP PDU types */
{
	"Bogus",
	"Open",
	"Update",
	"Error",
	"Keepalive",
	"Cease",
	"RIB Refresh"
#ifdef ECHOKLUDGE
	,"Echo",
	"Echo reply"
#endif
};

/* Maybe this should be replaced by a shift of these bits
 * Must match the sequence of ATTRIBUTE types
 */

char idrpAttrType[] =		/* Type code for IDRP Attributes */ 
{
	IDRP_ATTR_LOCAL_RD,
	IDRP_ATTR_ROUTE_SEPARATOR,
	IDRP_ATTR_EXT_INFO,
	IDRP_ATTR_RD_PATH,
	IDRP_ATTR_NEXT_HOP,
	IDRP_ATTR_DIST_LIST_INCL,
	IDRP_ATTR_DIST_LIST_EXCL,
	IDRP_ATTR_MULTI_EXIT_DISC,
	IDRP_ATTR_TRANSIT_DELAY,
	IDRP_ATTR_RESIDUAL_ERROR,
	IDRP_ATTR_EXPENSE,
	IDRP_ATTR_LOCALLY_DEF_QOS,
	IDRP_ATTR_HIERARCH_REC,
	IDRP_ATTR_HOP_COUNT,
	IDRP_ATTR_SECURITY,
	IDRP_ATTR_CAPACITY,
	IDRP_ATTR_PRIORITY
};



char *idrpAttrTypeStrings[] =		/* Type code for IDRP Attributes */ 
{
	"IDRP_ATTR_LOCAL_RD",
	"IDRP_ATTR_ROUTE_SEPARATOR",
	"IDRP_ATTR_EXT_INFO",
	"IDRP_ATTR_RD_PATH",
	"IDRP_ATTR_NEXT_HOP",
	"IDRP_ATTR_DIST_LIST_INCL",
	"IDRP_ATTR_DIST_LIST_EXCL",
	"IDRP_ATTR_MULTI_EXIT_DISC",
	"IDRP_ATTR_TRANSIT_DELAY",
	"IDRP_ATTR_RESIDUAL_ERROR",
	"IDRP_ATTR_EXPENSE",
	"IDRP_ATTR_LOCALLY_DEF_QOS",
	"IDRP_ATTR_HIERARCH_REC",
	"IDRP_ATTR_HOP_COUNT",
	"IDRP_ATTR_SECURITY",
	"IDRP_ATTR_CAPACITY",
	"IDRP_ATTR_PRIORITY"
};

/* attribute flags array */

int idrpAttrFlags[] = 		/* attribute flag values */
{
	IDRP_ATTRFLG_LOCAL_RD,          /* local RD path - not in spec */
	IDRP_ATTRFLG_ROUTE_SEPARATOR,
	IDRP_ATTRFLG_EXT_INFO,
	IDRP_ATTRFLG_RD_PATH,
	IDRP_ATTRFLG_NEXT_HOP,
	IDRP_ATTRFLG_DIST_LIST_INCL,
	IDRP_ATTRFLG_DIST_LIST_EXCL,
	IDRP_ATTRFLG_MULTI_EXIT_DISC,
	IDRP_ATTRFLG_TRANSIT_DELAY,
	IDRP_ATTRFLG_RESIDUAL_ERROR,
	IDRP_ATTRFLG_EXPENSE,
	IDRP_ATTRFLG_LOCALLY_DEF_QOS,
	IDRP_ATTRFLG_HIERARCH_REC,
	IDRP_ATTRFLG_HOP_COUNT,
	IDRP_ATTRFLG_SECURITY,
	IDRP_ATTRFLG_CAPACITY,
	IDRP_ATTRFLG_PRIORITY
};

int idrpManatt[] = 		/* attribute flag values */
{
	IDRP_ATTRMAN_LOCAL_RD,          /* local RD path - not in spec */
	IDRP_ATTRMAN_ROUTE_SEPARATOR,
	IDRP_ATTRMAN_EXT_INFO,
	IDRP_ATTRMAN_RD_PATH,
	IDRP_ATTRMAN_NEXT_HOP,
	IDRP_ATTRMAN_DIST_LIST_INCL,
	IDRP_ATTRMAN_DIST_LIST_EXCL,
	IDRP_ATTRMAN_MULTI_EXIT_DISC,
	IDRP_ATTRMAN_TRANSIT_DELAY,
	IDRP_ATTRMAN_RESIDUAL_ERROR,
	IDRP_ATTRMAN_EXPENSE,
	IDRP_ATTRMAN_LOCALLY_DEF_QOS,
	IDRP_ATTRMAN_HIERARCH_REC,
	IDRP_ATTRMAN_HOP_COUNT,
	IDRP_ATTRMAN_SECURITY,
	IDRP_ATTRMAN_CAPACITY,
	IDRP_ATTRFLG_PRIORITY
};


boolean idrpXmitatt[] = 		/* attribute flag values */
{
	IDRP_XMITATT_LOCAL_RD,          /* local RD path - not in spec */
	IDRP_XMITATT_ROUTE_SEPARATOR,
	IDRP_XMITATT_EXT_INFO,
	IDRP_XMITATT_RD_PATH,
	IDRP_XMITATT_NEXT_HOP,
	IDRP_XMITATT_DIST_LIST_INCL,
	IDRP_XMITATT_DIST_LIST_EXCL,
	IDRP_XMITATT_MULTI_EXIT_DISC,
	IDRP_XMITATT_TRANSIT_DELAY,
	IDRP_XMITATT_RESIDUAL_ERROR,
	IDRP_XMITATT_EXPENSE,
	IDRP_XMITATT_LOCALLY_DEF_QOS,
	IDRP_XMITATT_HIERARCH_REC,
	IDRP_XMITATT_HOP_COUNT,
	IDRP_XMITATT_SECURITY,
	IDRP_XMITATT_CAPACITY,
	IDRP_XMITATT_PRIORITY
};

int idrpAttrBits[] =		/* attribute bit mask */
{
	IDRP_ATTBT_LOCAL_RD,
	IDRP_ATTBT_ROUTE_SEPARATOR,
	IDRP_ATTBT_EXT_INFO,
	IDRP_ATTBT_RD_PATH,
	IDRP_ATTBT_NEXT_HOP,
	IDRP_ATTBT_DIST_LIST_INCL,
	IDRP_ATTBT_DIST_LIST_EXCL,
	IDRP_ATTBT_MULTI_EXIT_DISC,
	IDRP_ATTBT_TRANSIT_DELAY,
	IDRP_ATTBT_RESIDUAL_ERROR,
	IDRP_ATTBT_EXPENSE,
	IDRP_ATTBT_LOCALLY_DEF_QOS,
	IDRP_ATTBT_HIERARCH_REC,
	IDRP_ATTBT_HOP_COUNT,
	IDRP_ATTBT_SECURITY,
	IDRP_ATTBT_CAPACITY,
	IDRP_ATTBT_PRIORITY
};

boolean idrpAttrDIS[] =		/* Type code for IDRP Attributes */ 
{
	IDRP_ATTRDIS_LOCAL_RD,
	IDRP_ATTRDIS_ROUTE_SEPARATOR,
	IDRP_ATTRDIS_EXT_INFO,
	IDRP_ATTRDIS_RD_PATH,
	IDRP_ATTRDIS_NEXT_HOP,
	IDRP_ATTRDIS_DIST_LIST_INCL,
	IDRP_ATTRDIS_DIST_LIST_EXCL,
	IDRP_ATTRDIS_MULTI_EXIT_DISC,
	IDRP_ATTRDIS_TRANSIT_DELAY,
	IDRP_ATTRDIS_RESIDUAL_ERROR,
	IDRP_ATTRDIS_EXPENSE,
	IDRP_ATTRDIS_LOCALLY_DEF_QOS,
	IDRP_ATTRDIS_HIERARCH_REC,
	IDRP_ATTRDIS_HOP_COUNT,
	IDRP_ATTRDIS_SECURITY,
	IDRP_ATTRDIS_CAPACITY,
	IDRP_ATTRDIS_PRIORITY
};



bits idrp_flag_bits[] =		/* pretty print bits */ 
{
	{IDRPF_UNCONFIGURED, "Unconfigured"},
	{IDRPF_DELETE, "Delete"},
	{IDRPF_TRY_CONNECT, "TryConnect"},
	{IDRPF_CONNECT, "ConnectTimer"},
	{IDRPF_WRITEFAILED, "WriteFailed"},
	{IDRPF_IDLED,"Idled"},
	{0}
};

char *idrpChangeTypes[] =	/* Names of IDRP change field values */
{
	"None",
	"Modified",
	"Deleted"
};

nlri_proto_info idrp_nlri_proto_id[] =	/* protocol id info array for nlri in update */ 
{
	{IDRP_PROTO_TYPE_TR_9577,IDRP_CLNP_PROTO_LEN,CLNP_NLPID},
	{IDRP_PROTO_TYPE_TR_9577,IDRP_IP_PROTO_LEN,IP_NLPID}
};

nlri_fam nlri_family[] =		/* nlri family */
{
	{AF_ISO,IDRP_NLRI_ISO},
	{AF_INET,IDRP_NLRI_IP}
};


fam_nlri family_nlri[] =
{
	{AF_UNSPEC,IDRP_NLRI_UNDEFINED},
	{AF_UNIX,IDRP_NLRI_UNDEFINED},
	{AF_INET,IDRP_NLRI_IP},
	{AF_IMPLINK,IDRP_NLRI_UNDEFINED},
	{AF_PUP,IDRP_NLRI_UNDEFINED},
	{AF_CHAOS,IDRP_NLRI_UNDEFINED},
	{AF_NS,IDRP_NLRI_UNDEFINED},
	{AF_ISO,IDRP_NLRI_ISO},
	{AF_ECMA,IDRP_NLRI_UNDEFINED},
	{AF_DATAKIT,IDRP_NLRI_UNDEFINED},
	{AF_CCITT,IDRP_NLRI_UNDEFINED},
	{AF_SNA,IDRP_NLRI_UNDEFINED},
	{AF_DECnet,IDRP_NLRI_UNDEFINED},
	{AF_DLI,IDRP_NLRI_UNDEFINED},
	{AF_LAT,IDRP_NLRI_UNDEFINED},
	{AF_HYLINK,IDRP_NLRI_UNDEFINED},
	{AF_APPLETALK,IDRP_NLRI_UNDEFINED}
};

u_int	proto_header_len[] =		/* header length for each protocol  for update pdu */
{
	IDRP_IP_HEADER_LEN,
	IDRP_UDP_HEADER_LEN,
	IDRP_CLNP_HEADER_LEN,
	IDRP_IDRP_HEADER_LEN
};


/* these arrays are not set-up */
 
bits idrpEvents[] =			/* Event values */
{
	{IDRP_START_EVENT,"idrp start event"},
	{IDRP_STOP_EVENT,"idrp stop event"},
	{IDRP_CLOSE_TIMEOUT,"idrp close timeout"},
	{IDRP_HOLDTIME_TIMEOUT,"idrp hold timeout"},
	{IDRP_HEADER_ERROR,"idrp bispdu header error"},
	{IDRP_KEEPALIVE,"idrp keepalive received"},
	{IDRP_CEASE,"idrp cease received with no errors"},
	{IDRP_OPEN_ERROR,"idrp open pdu with errors received"},
	{IDRP_OPEN,"idrp open with no errors received"},
	{IDRP_UPDATE_ERROR,"idrp update with errors received"},
	{IDRP_UPDATE,"idrp update w/no errors recieved"},
	{IDRP_ERROR_ERROR,"idrp error with errors recieved"},
	{IDRP_ERROR,"idrp error w/no errors recieved"},
	{IDRP_REFRESH_ERROR,"idrp refresh with errors recieved"},
	{IDRP_REFRESH,"idrp refresh w/no errors recieved"},
	{IDRP_REXMIT_TIMEOUT,"idrp re-transmit timeout occurred"},
	{IDRP_KEEPALIVE_TIMEOUT,"idrp keepalive timeout occurred"},
	{IDRP_SEND_PDU,"idrp_pdu sent"},
#ifdef ECHOKLUDGE
	{IDRP_ECHO_TIMEOUT,"idrp_echo_timeout"},
#endif
	{-1," "}
};




/* trace types */

const bits idrp_trace_types[] = {
    { TR_DETAIL,	"detail packets" },
    { TR_DETAIL_SEND,	"detail send packets" },
    { TR_DETAIL_RECV,	"detail recv packets" },
    { TR_PACKET,	"packets" },
    { TR_PACKET_SEND,	"send packets" },
    { TR_PACKET_RECV,	"recv packets" },
    { TR_DETAIL_1,	"detail open" },
    { TR_DETAIL_SEND_1,	"detail send open" },
    { TR_DETAIL_RECV_1,	"detail recv open" },
    { TR_PACKET_1,	"open" },
    { TR_PACKET_SEND_1,	"send open" },
    { TR_PACKET_RECV_1,	"recv open" },
    { TR_DETAIL_2,	"detail update" },
    { TR_DETAIL_SEND_2,	"detail send update" },
    { TR_DETAIL_RECV_2,	"detail recv update" },
    { TR_PACKET_2,	"update" },
    { TR_PACKET_SEND_2,	"send update" },
    { TR_PACKET_RECV_2,	"recv update" },
    { TR_DETAIL_3,	"detail keepalive" },  
    { TR_DETAIL_SEND_3,	"detail send keepalive" },
    { TR_DETAIL_RECV_3,	"detail recv keepalive" },
    { TR_PACKET_3,	"keepalive" },
    { TR_PACKET_SEND_3,	"send keepalive" },
    { TR_PACKET_RECV_3,	"recv keepalive" },
    { 0, NULL }
};
