/*
 * GateD Releases Unicast, Multicast, IPv6, RSd
 * 
 * Copyright (c) 1996,1997,1998,1999 
 * The Regents of the University of Michigan.
 * All Rights Reserved.
 * 
 * License to use, copy, modify, and distribute this software and its
 * documentation can be obtained from Merit Network, Inc. at the 
 * University of Michigan.
 * 
 * Merit GateD Consortium
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C
 * Ann Arbor, MI 48105
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE FUNCTIONS 
 * CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR THAT 
 * OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for any special, 
 * indirect, incidental or consequential damages with respect to any claim 
 * by Licensee or any third party arising from use of the software. 
 * GateD was originated and developed through release 3.0 by Cornell 
 * University and its collaborators.
 * 
 * Please send questions or comments to gated-people@gated.org.
 *
 * Please submit bugs, bug fixes, and enhancements using the send-pr(1) 
 * utility or via the web at 
 * www.gated.org/gated-web/support/html/report_prob.html.
 * 
 * ------------------------------------------------------------------------
 *
 *      Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *          All rights reserved.
 *
 *      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 *      EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 *      LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 *      AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *      GateD is based on Kirton's EGP, UC Berkeley's routing
 *      daemon   (routed), and DCN's HELLO routing Protocol.
 *      Development of GateD has been supported in part by the
 *      National Science Foundation.
 *
 * ------------------------------------------------------------------------
 *
 *      Portions of this software may fall under the following
 *      copyrights:
 *
 *      Copyright (c) 1988 Regents of the University of California.
 *      All rights reserved.
 *
 *      Redistribution and use in source and binary forms are
 *      permitted provided that the above copyright notice and
 *      this paragraph are duplicated in all such forms and that
 *      any documentation, advertising materials, and other
 *      materials related to such distribution and use
 *      acknowledge that the software was developed by the
 *      University of California, Berkeley.  The name of the
 *      University may not be used to endorse or promote
 *      products derived from this software without specific
 *      prior written permission.  THIS SOFTWARE IS PROVIDED
 *      ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 *      INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 *      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * __END_OF_COPYRIGHT__
 */

#if !defined(_MPBGP6_SYNC_H_)
#define _MPBGP6_SYNC_H_

/*
 * The following two macros are used to make the existence of different sync
 * tries invisible to the bgp sync code.  They basically just swap the correct
 * trie in and out of the generic bgp_sync_trie pointer in the bgp_sync
 * structure.
 */
/*
 * XXX there is certainly a better way to do this.  Ideally, we'd have a single
 * trie that stored all of the information that we need in it.  To do this
 * we would probably just add the family portion of the sockaddr to the key
 * space (ie, tack it on to the beginning), and then use the length from the
 * sockaddr to determine the maximum depth we're allowed to go in the trie.
 *
 * This should simply boil down to a single extra level of depth to the tree,
 * And a single extra comparison per tree walk.  In other words, it might be
 * a smidge less efficient (because right now, in most cases, we do a single
 * comparison on entrance into the bgp_sync module... rather than one every
 * time the trie gets walked.)
 */

#define BSY_GET_SYNC_TRIE(bsp, fam) \
	do { \
		bgp_sync *Xbsp = (bsp); \
		switch ((fam)) { \
		case AF_INET: \
			Xbsp->bgp_sync_trie = Xbsp->bgp_sync_trie4; \
			break; \
		case AF_INET6: \
			Xbsp->bgp_sync_trie = Xbsp->bgp_sync_trie6; \
			break; \
		default: \
			assert(FALSE); \
		} \
	} while (0)

#define BSY_SAVE_SYNC_TRIE(bsp, fam) \
	do { \
		bgp_sync *Xbsp = (bsp); \
		switch ((fam)) { \
		case AF_INET: \
			Xbsp->bgp_sync_trie4 = Xbsp->bgp_sync_trie; \
			break; \
		case AF_INET6: \
			Xbsp->bgp_sync_trie6 = Xbsp->bgp_sync_trie; \
			break; \
		default: \
			assert(FALSE); \
		} \
	} while (0)

#define	BSY_FIND_FIRST_DIFFERENT(sa1, Xsa2, bit) \
    do { \
	sockaddr_un *Xsa1 = (sa1); \
	byte *Xbits1, *Xbits2; \
	byte Xtmp; \
	int Xlen; \
	int Xi; \
	switch (socktype(Xsa1)) { \
	case AF_INET: \
		Xlen = 4; \
		Xbits1 = (byte *)&(sock2ip(Xsa1)); \
		Xbits2 = (byte *)&(sock2ip((Xsa2))); \
		break; \
	case AF_INET6: \
		Xlen = 16; \
		Xbits1 = (byte *)&(sock2in6(Xsa1)); \
		Xbits2 = (byte *)&(sock2in6(Xsa2)); \
		break; \
	default: \
		(bit) = 0; /* Stop GCC from complaining */ \
		assert(FALSE); \
	} \
	for (Xi = 0; Xi < Xlen; Xi++) \
	    if ((Xtmp = Xbits1[Xi] ^ Xbits2[Xi])) { \
		(bit) = bsy_firstbit_lookup[Xtmp] + (NBBY * Xi); \
		break; \
	    } \
    } while (0)

/*
 * NOTE: This macro evaluates the sa1 argument more than one time, and
 * may evaluate the bit argument more than one time.
 */
#define BSY_BIT_TEST(sa, bit) \
	(socktype((sa)) == AF_INET ? \
	    BIT_TEST(sock2ip((sa)), 1 << (NBBY - ((bit) % NBBY))) : \
	(socktype((sa)) == AF_INET6 ? \
	    BIT_TEST((byte)(((byte *)&(sock2in6((sa))))[(bit) / NBBY]), \
		1 << (NBBY - ((bit) % NBBY))) : *(byte *)NULL))

#define BSY_MASK_DEST(sa, masklen) \
	do { \
		sockaddr_un *Xsa = (sa); \
		u_int32 *Xaddr; \
		u_int32 *Xmask; \
		int Xlen = (masklen); \
		int Xi; \
		switch (socktype(Xsa)) { \
		case AF_INET: \
			Xlen = 1; \
			Xaddr = (u_int32 *)&sock2ip(Xsa); \
			Xmask = (u_int32 *)&sock2ip(inet_masks[(masklen)]); \
			break; \
		case AF_INET6: \
			Xlen = 4; \
			Xaddr = (u_int32 *)&sock2in6(Xsa); \
			Xmask = (u_int32 *)&sock2in6(inet6_masks[(masklen)]); \
			break; \
		default: \
			assert(FALSE); \
		} \
		for (Xi = 0; Xi < Xlen; Xi++) { \
			Xaddr[Xi] = Xaddr[Xi] & Xmask[Xi]; \
		} \
	} while (0)

#define BSY_DEPTH_HOST6	128 /* Length of IPv6 host adress in bits */
#define BSY_MAXDEPTH6	(BSY_DEPTH_HOST6 + 1)

#endif /* !defined(_MPBGP6_SYNC_H_) */
