/*
 *  krt_lladdr_hpstreams.c
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */

#define INCLUDE_IF
#include "include.h"
#include "krt.h"
#include "krt_var.h"
#include <stropts.h>
#include <sys/dlpi.h>
#include <sys/dlpi_ext.h>

static dl_hp_ppa_ack_t *dl_ppa_ack = (dl_hp_ppa_ack_t *) 0;
static dl_hp_ppa_info_t *dl_ppa_info = (dl_hp_ppa_info_t *) 0;
static char ctlbuf[2000];


s_int32
krt_lladdr_info __PF0(void)
{
 s_int32 fd, error, flags=0, i, j;
 dl_hp_ppa_req_t dl_ppa_req;
 struct strbuf ctlblk;
 sockaddr_un *lladdr = (sockaddr_un *) 0;

 if (dl_ppa_ack == NULL)  {
 /* first time to retrieve the dlpi info */

    if ((fd = open("/dev/dlpi", O_RDWR)) < 0) {
         trace_tp(krt_task,
                  TR_ALL,
                  0,
                  ("krt_lladdr_info (open dlpi): %m"));
         return (-1); 
    }

    dl_ppa_req.dl_primitive = DL_HP_PPA_REQ;
    ctlblk.len = sizeof(dl_hp_ppa_req_t);
    ctlblk.buf = (char *) &dl_ppa_req;
    if (putmsg (fd, &ctlblk, (char *) 0, 0) < 0) {
         trace_tp(krt_task,
                  TR_ALL,
                  0,
                  ("krt_lladdr_info (putmsg) : %m"));
         close (fd);
         return (-1); 
    }
   
    ctlblk.maxlen = sizeof(ctlbuf);
    ctlblk.buf = ctlbuf;
    if ((error = getmsg (fd, &ctlblk, (char *) 0, &flags)) != 0) {
       if (error == MORECTL) {
         trace_tp(krt_task,
                  TR_ALL,
                  0,
                  ("krt_lladdr_info (getmsg) : ctlblk is too small"));
         close (fd);
         return (-1); 
       }
       else {
         trace_tp(krt_task,
                  TR_ALL,
                  0,
                  ("krt_lladdr_info (getmsg) : %m"));
         close (fd);
         return (-1); 
       }
    }

    close(fd);

    switch (*(unsigned long *)ctlbuf) {
      case DL_HP_PPA_ACK:
           dl_ppa_ack = (dl_hp_ppa_ack_t *) ctlblk.buf;
           dl_ppa_info=(dl_hp_ppa_info_t *) (ctlblk.buf+dl_ppa_ack->dl_offset);
           return 0;
   
      case DL_ERROR_ACK:
           trace_tp(krt_task,
                    TR_ALL,
                    0,
                    ("krt_lladdr_info : DL_ERROR_ACK") );
           return (-1); 
  
       default:
           trace_tp(krt_task,
                    TR_ALL,
                    0,
                    ("krt_lladdr_info : Got unexpected message %d", 
                     *(u_long *) ctlbuf) );
           return (-1); 
    }
 } 
 else
    return 0;
}


sockaddr_un *
krt_lladdr __PF1(ifr, struct ifreq *)
{
  char if_name[IFNAMSIZ+1];
  struct ifreq *ifrp;
  s_int32 i = 0, unit = 0;
  u_long mtu = 0;
  char *sp = ifr->ifr_name;
  char *cp = if_name;
  sockaddr_un  *lladdr = (sockaddr_un * ) 0;
  dl_hp_ppa_ack_t *dl_ppa_ack_p;
  dl_hp_ppa_info_t *dl_ppa_info_p;
 
  if (krt_lladdr_info () == -1) {
        return (sockaddr_un *) 0;
  }

  do {
      *cp++ = *sp ++;
  } while ( *sp && isalpha (*sp));

  /* kwy: to be deleted later */
  if (*sp == '_')  {
      *cp++ = *sp ++;
      do {
          *cp++ = *sp ++;
      } while ( *sp && isalpha (*sp));
  }
  /* kwy: end of deletion */
  
  *cp = (char) 0;

  /* get the interface name without the unit number */
  cp = strchr (ifr->ifr_name, ':');
  if (cp == NULL)  {
      cp = if_name + strlen(ifr->ifr_name);     
  }              
  do {
    unit = (unit*10) + (*sp - '0');
  } while (*++sp && sp < cp);

  dl_ppa_ack_p = dl_ppa_ack;
  dl_ppa_info_p = dl_ppa_info;

  /* retrieve the station address */
  for (i=0; i<dl_ppa_ack_p->dl_count; i++,dl_ppa_info_p++) {
       if ( (unit == dl_ppa_info_p->dl_ppa) &&
          ( !strcmp (if_name, dl_ppa_info_p->dl_module_id_1) ||
            !strcmp (if_name, dl_ppa_info_p->dl_module_id_2) ) ) {
            lladdr = sockbuild_ll (LL_8022,
                                 (byte *) dl_ppa_info_p->dl_phys_addr,
                                 dl_ppa_info_p->dl_addr_length); 
            break;
       }
  }
  return (lladdr);
}



