/*
 * Public Release 3
 * 
 * $Id: iso.h,v 1.2 1997/07/17 22:42:45 chopps Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP, UC Berkeley's routing
 * daemon	 (routed), and DCN's HELLO routing Protocol.
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#define	ISO_MAXADDRLEN	20
#define	SOCKADDR_ISO_LEN	(sizeof (iso_addr_default->iso) - 1 + ISO_MAXADDRLEN)

extern byte iso_default_prefix[];	/* the all zeros prefix */
extern sockaddr_un *iso_addr_default;	/* same thing as a sockaddr */

extern sockaddr_un *iso_masks[];	/* All possible contiguous masks */
extern byte iso_mask_list[SOCKADDR_ISO_LEN * (ISO_MAXADDRLEN * NBBY + 1)];
#define	iso_mask_default	iso_masks[0]

#define	ISO_LIMIT_MASKLEN	0, (size_t) (ISO_MAXADDRLEN * NBBY)

#define	iso_mask_natural(addr)	iso_masks[(socksize(addr) - (addr->iso.giso_addr - (byte *) addr)) * NBBY]

/* Locate an ISO mask given it's prefix length */
#define        iso_mask_prefix(pfx)    ((pfx < 0 || pfx > (ISO_MAXADDRLEN * NBBY)) ? (sockaddr_un *) 0 : iso_masks[pfx])

#define        iso_prefix_mask(mask) \
	((byte *) (mask) >= iso_mask_list && (byte *) (mask) < iso_mask_list + sizeof iso_mask_list) \
	? (((byte *) (mask) - iso_mask_list) / SOCKADDR_ISO_LEN) \
	: (u_int) -1

PROTOTYPE(iso_mask_locate,
	  extern sockaddr_un *,
	  (sockaddr_un *));
PROTOTYPE(iso_family_init,
	  extern void,
	  (void));
PROTOTYPE(iso_init,
	  extern void,
	  (void));
