/*
 * Public Release 3
 * 
 * $Id: kvm.c,v 1.4 1998/09/15 16:48:11 wfs Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP, UC Berkeley's routing
 * daemon	 (routed), and DCN's HELLO routing Protocol.
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


#define	INCLUDE_NLIST
#define	INCLUDE_FILE

#include "include.h"
#ifndef vax11c
#include <sys/file.h>
#endif				/* vax11c */

/*
 *	Emulation of kvm library for systems that do not have it
 */

struct __kvm {
    int	kvm_fd;
    const char *kvm_nl;
    const char *kvm_core;
    const char *kvm_swap;
    char kvm_errmsg[BUFSIZ];
};
typedef struct __kvm kvm_t;

#if	__GNUC__ > 1
/* To prevent a warning about missing prototypes */

PROTOTYPE(kvm_openfiles,
	  extern kvm_t *,
	  (char *,
	   char *,
	   char *,
	   int,
	   char *));
PROTOTYPE(kvm_close,
	  extern int,
	  (kvm_t *));
PROTOTYPE(kvm_nlist,
	  extern int,
	  (kvm_t *,
	   NLIST_T *,
	   size_t));
PROTOTYPE(kvm_read,
	  extern int,
	  (kvm_t *,
	   u_long,
	   void_t,
	   size_t));
PROTOTYPE(kvm_write,
	  extern int,
	  (kvm_t *,
	   u_long,
	   void_t,
	   size_t));
PROTOTYPE(kvm_geterr,
	  extern char *,
	  (kvm_t *));
#endif


kvm_t *
kvm_openfiles __PF5(nl, char *,
		    core, char *,
		    swap, char *,
		    flags, int,
		    errbuf, char *)
{
#ifndef	vax11c
    int fd;
    kvm_t *kd = (kvm_t *) 0;
    const char *corefile = core ? core : _PATH_KMEM;

    fd = task_floating_socket((task *) 0,
			      open(corefile, flags, 0),
			      corefile);
    if (fd < 0) {
	sprintf(errbuf, "kvm_openfiles: %m");
    } else {
	kd = (kvm_t *) task_mem_calloc((task *) 0, 1, sizeof (kvm_t));

	kd->kvm_fd = fd;
	kd->kvm_nl = nl ? nl : _PATH_UNIX;
	kd->kvm_core = corefile;
	kd->kvm_swap = NULL;
	*kd->kvm_errmsg = (char) 0;
    }

    return kd;
#else	/* vax11c */
    return (kvm_t *) TRUE;
#endif	/* vax11c */
}


int
kvm_close __PF1 (kd, kvm_t *)
{
#ifndef	vax11c
    int rc = 0;

    if (kd->kvm_fd >= 0) {
	rc = close(kd->kvm_fd);
	if (rc != 0) {
	    sprintf(kd->kvm_errmsg, "kvm_close: %m");
	}
    }

    (void) task_mem_free((task *) 0, (void_t) kd);

#endif	/* vax11c */

    return 0;
}


int
kvm_nlist __PF3(kd, kvm_t *,
		nl, NLIST_T *,
		sz, size_t)
{
#ifdef	vax11c
    extern char *Network_Image_File;

    return multinet_kernel_nlist(Network_Image_File, nl);
#else	/* vax11c */
    int rc = NLIST(kd->kvm_nl, nl, sz);

    if (rc < 0 && errno) {
	sprintf(kd->kvm_errmsg, "kvm_nlist: nlist (errno may not be valid): %m");
    }
    return rc;
#endif	/* vax11c */
}


int
kvm_read __PF4(kd, kvm_t *,
	       addr, u_long,
	       buf, void_t,
	       nbytes, size_t)
{
    off_t rc;
#ifdef	vax11c
    rc = klseek(offset);
    if (rc == (off_t) -1) {
	sprintf(kd->kvm_errmsg, "kvm_read: klseek: %m");
    } else {
	rc = klread(buf, nbytes);
	if (rc == (off_t) -1) {
	    sprintf(kd->kvm_errmsg, "kvm_read: klread: %m");
	}
    }
#else	/* vax11c */

    rc = lseek(kd->kvm_fd, (off_t) addr, 0);
    if (rc == (off_t) -1) {
	sprintf(kd->kvm_errmsg, "kvm_read: lseek: %m");
    } else {
	rc = read(kd->kvm_fd, buf, nbytes);
	if (rc == (off_t) -1) {
	    sprintf(kd->kvm_errmsg, "kvm_read: read: %m");
	}
    }
#endif	/* vax11c */

    return rc;
}


int
kvm_write __PF4(kd, kvm_t *,
	       addr, u_long,
	       buf, void_t,
	       nbytes, size_t)
{
    off_t rc;
#ifdef	vax11c
    rc = klseek(offset);
    if (rc == (off_t) -1) {
	sprintf(kvm_errmsg, "kvm_write: klseek: %m");
    } else {
	rc = klwrite(buf, nbytes);
	if (rc == (off_t) -1) {
	    sprintf(kvm_errmsg, "kvm_write: klwrite: %m");
	}
    }
#else	/* vax11c */

    rc = lseek(kd->kvm_fd, (off_t) addr, 0);
    if (rc == (off_t) -1) {
	sprintf(kd->kvm_errmsg, "kvm_write: lseek: %m");
    } else {
	rc = write(kd->kvm_fd, buf, nbytes);
	if (rc == (off_t) -1) {
	    sprintf(kd->kvm_errmsg, "kvm_write: write: %m");
	}
    }
#endif	/* vax11c */

    return rc;
}


char *
kvm_geterr __PF1 (kd, kvm_t *)
{
    return kd->kvm_errmsg;
}
