/*
 * Public Release 3
 * 
 * $Id: isis_base.h,v 1.2 1997/07/17 22:42:00 chopps Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP, UC Berkeley's routing
 * daemon	 (routed), and DCN's HELLO routing Protocol.
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */


#ifndef _base_h
#define _base_h

#include <sys/time.h>

#ifdef	notdef
#include "isis_netd.h"
#endif	/* notdef */
#include "isis_troll.h" /* say a prayer */
#define REALD 0
#define NETD 1
#define TROLLD 2
#include "isis_dll.h"
#include "isis_rtrace.h"

/*
 *	"Architectural Constants"
 */
#define MaximumAreaAddresses		3
#define	AreaAddressStoreSize		100
#define	MaximumAreaAddressLen		13
#define MaximumCircuits			10
/* #define	SequenceModulus			(u_int) 4294967295 */
#define	SequenceModulus			(u_int32) 0xffffffff
#define	MaxPacketSize			4096
#define	IntraDomainRPD			0x83
#define	ESISRPD				0x82
#define HoldingMultiplier               3
#define ISISHoldingMultiplier           10
#define	VersionProtoID			1
#define	Version				1
#ifndef USE_SNMP_OK_NOTOK
#define OK				1 
#define NOTOK				0 
#endif
#define	True				1
#define	False				0
#define	IDOFF				6		/* offset of local ID */
#define	OSI_NLPID			0x81		/* STEVE - this is the ISO 9577 value */
#define	IP_NLPID			0xCC		/* STEVE - this is the ISO 9577 value */


/*
 *	Size of the adjacency hash table; TODO: some comments on sizing
 */
#define AdjHashTableSize	100

/*
 *      The LSP hash table size. This table is used to hash all LSPs at the
 *      given level (hash is based upon sourceID address). Chained bucket
 *      hashing is used.
 */
#define	L1HashTableSize		100
#define L2HashTableSize		50

/*
 *	Use these types for PDU declarations. They are arrays so that
 *	the structures that result do not have padding that would
 *	screw up the packet format
 */
typedef u_char Unsigned8;
typedef u_char Unsigned16[2];
typedef u_char Unsigned32[4];

#define hostToU16(s, u) \
    do { \
        register u_short Xtmp = (u_short)(s); \
        register byte *Xcp = (byte *)(u); \
        *Xcp++ = Xtmp >> 8; \
        *Xcp = Xtmp; \
    } while (0)

#define hostToU32(l, u) \
    do { \
        register u_long Xtmp = (u_long)(l); \
        register byte *Xcp = (byte *)(u); \
        *Xcp++ = Xtmp >> 24; \
        *Xcp++ = Xtmp >> 16; \
        *Xcp++ = Xtmp >> 8; \
        *Xcp = Xtmp; \
    } while (0)

#define U16toHost(u, s) \
    do { \
        register u_short Xtmp; \
        register byte *Xcp = (byte *)(u); \
        Xtmp = ((u_short)(*Xcp++)) << 8; \
        Xtmp |= (u_short)(*Xcp); \
        (s) = Xtmp; \
    } while (0)

#define U32toHost(u, l) \
    do { \
        register u_long Xtmp; \
        register byte *Xcp = (byte *)(u); \
        Xtmp = ((u_long)(*Xcp++)) << 24; \
        Xtmp |= ((u_long)(*Xcp++)) << 16; \
        Xtmp |= ((u_long)(*Xcp++)) << 8; \
        Xtmp |= (u_long)(*Xcp); \
        (l) = Xtmp; \
    } while (0)

	
/*
 *	Generic pointer to integer returning function
 */
typedef int			(* PTIF)();
typedef	caddr_t 	AuthInfo;		/* Authentication Information */
typedef u_char		Boolean;
typedef u_char		SystemID6[6];
typedef u_char		SystemID7[7];
typedef SystemID6	MACAddress;
typedef u_char 		Metric;
typedef u_int		Counter;
typedef long		IPAddress;
typedef u_int		IPSubnetMask;
typedef u_int		SeqNumber;

typedef enum {ModuleUp, ModuleDown} RoutingModuleState;

#define MetricUnsupported	0x80	/* bit that indicates unsupported metric */

#ifndef max
#define max(a,b) ((a) < (b) ? (b) : (a))
#endif
#ifndef min
#define min(a,b) ((a) < (b) ? (a) : (b))
#endif

#define castMalloc(cast, size)\
	((cast)mallocOrDie(size))

#ifdef	ibm032
#define Offset(type, field)	_offsetof(type, field)
#else
#define Offset(type, field) /* ala fldoff in struct.h */ \
	((unsigned int) (( &(((type *)NULL)->field))  ))
#endif

#define timeStamp	getTimeOfDay()

#define copyID(from, to, len)\
	bcopy((caddr_t)(from), (caddr_t)(to), len)

#define equalID(a, b, len)\
	(!bcmp((caddr_t)a, (caddr_t)b, len))

#define compareID(a, b, len)\
	arrayCmp((u_char *) a, (u_char *) b, len)

#define LSPIDcmp(a,b) /* replace int LSPIDcmp(LSPID *a,LSPID *b) */ \
	arrayCmp((u_char *) a, (u_char *) b, sizeof(LSPID))

#define BroadcastLSPThrottle\
	min(10, (1000/minBroadcastLSPXmitInterval))

typedef struct _globalCounters {
        Counter         pduFormatErrors;
        Counter         corruptLSPDetected;
        Counter         l1LSPOverload;
        Counter         l2LSPOverload;
        Counter         manualAreaDropped;
        Counter         exceedSeqNum;
        Counter         seqNumSkipped;
        Counter         purgeOwnLSP;
        long    	option;         /* blocks allocated */
        long    	optiondata;
        long    	prefIP;
        long    	prefISO;
        long    	lspattr;
        long    	tsi_info;
        long    	spfNode;        
        long    	intnode;        
        long    	ipleaf;        
        long    	isoleaf;        
	long		spfAA;
	long		lspdescs;
	long		lsentries;
	long		sumnodes;
	long		lseChangeList;
	long		isis_announced;
	long		adjEntries;	/* other allocated */
	long		adjNeighborInfo;
	long		agelists;
	long		circuitEntries;
	long		lspbufs;
	long		lspbytes;
	long		ipext;		/* option type breakdown */
	long		ipint;
	long		isopref;
	long		leaves;	
	long		idrpi;
	long		aa;
	long		isn;
	long		esn;
	long		ipintf;
	long		protosup;
	long		ipsum;
	long		pdl2is;
	long		ipauth;
	long		auth;
} GlobalCounters;

extern GlobalCounters   isisCounters;

/*
 * Definitions for exported update types.  It is either an initial update,
 * a flash update or a newpolicy update.
 */
#define ISIS_NEWPOLICY	(0)
#define ISIS_INITIAL	(1)
#define ISIS_FLASH	(2)

#endif	/* _base_h */
