#include <stdio.h>
#include <sys/types.h>
#include <sgtty.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <netdb.h>
#include <fcntl.h>

struct	ifreq ifr;

int wantbaud = 9600;	/* default speed */
int speed;
int slipdisc = SLIPDISC;

/* other tty line parameters for serial net */
#define	SLERASE	'\0'			/* erase character (doesn't matter) */
#define	SLKILL	'\0'			/* kill character (doesn't matter) */
#define	SLFLAGS	(RAW|EVENP|ODDP)	/* line flags (matches sl driver) */

char devname[32];
char hostname[256];	/* Maximum length for host name */

main(argc,argv)
char *argv[];
{
	register int fd;
	struct sgttyb sgtty;
	register char *dev = argv[1];
	int n;

	if (argc < 2 || argc > 4){
		fprintf(stderr,"usage: slattach ttyname sitename [baudrate]\n");
		exit(1);
	}

	if (argc == 4)
		wantbaud = atoi(argv[3]);

	speed = findspeed(wantbaud);
	if ( speed == 0){
		fprintf(stderr,"%s: Unknown speed\n",argv[3]);
		exit(1);
	}
	if (strncmp("/dev/",dev,5)) {
		sprintf(devname,"/dev/%s",dev);
		dev = devname;
	}
	if ( (fd=open(dev,O_RDWR|O_NDELAY)) < 0 ){
		perror(dev);
		exit(1);
	}

	/* set up line parameters needed by serial net */
	sgtty.sg_ispeed  = sgtty.sg_ospeed = speed;
	sgtty.sg_erase = SLERASE;
	sgtty.sg_kill = SLKILL;
	sgtty.sg_flags = SLFLAGS;
	if (ioctl(fd,TIOCSETP,&sgtty) < 0){
		perror(dev);
		exit(1);
	}

	if (ioctl(fd,TIOCSETD,&slipdisc)<0){
		perror("cant set line discipline");
		exit(1);
	}

	if (ioctl(fd,TIOCGETD,&n)<0){
		perror("cant get line discipline");
		exit(1);
	}

	close(fd);

	fd = socket(AF_INET, SOCK_DGRAM, 0);
	if (fd < 0) {
		perror("ifattach: socket");
		exit(1);
	}
	sprintf(ifr.ifr_name,"sl%d",n);

	getaddr(argv[2], (struct sockaddr_in *)&ifr.ifr_dstaddr);
	if (ioctl(fd, SIOCSIFDSTADDR, (caddr_t)&ifr) < 0) {
		perror("ioctl (SIOCSIFDSTADDR)");
		exit(1);
	}
	(void)gethostname(hostname,sizeof(hostname));
	getaddr(hostname,(struct sockaddr_in *)&ifr.ifr_addr);
	if (ioctl(fd, SIOCSIFADDR, (caddr_t)&ifr) < 0) {
		perror("ioctl (SIOCSIFADDR)");
		exit(1);
	}

}

struct sg_spds {int sp_val, sp_name;} spds[] = {
#ifdef B50
	{  50,	 B50},
#endif
#ifdef B75
	{  75,	 B75},
#endif
#ifdef B110
	{ 110,	B110},
#endif
#ifdef B150
	{ 150,	B150},
#endif
#ifdef B200
	{ 200,	B200},
#endif
#ifdef B300
	{ 300,  B300},
#endif
#ifdef B600
	{600,	B600},
#endif
#ifdef B1200
	{1200, B1200},
#endif
#ifdef B1800
	{1800, B1800},
#endif
#ifdef B2000
	{2000, B2000},
#endif
#ifdef B2400
	{2400, B2400},
#endif
#ifdef B3600
	{3600, B3600},
#endif
#ifdef B4800
	{4800, B4800},
#endif
#ifdef B7200
	{7200, B7200},
#endif
#ifdef B9600
	{9600, B9600},
#endif
#ifdef EXTA
	{19200,EXTA},
#endif
	{0, 0}
};

findspeed(wantbaud)
register int wantbaud;
{
	register struct sg_spds *sp;

	sp = spds;

	while ( sp->sp_val && sp->sp_val != wantbaud)
		sp++;

	return sp->sp_name;
}

struct	in_addr inet_makeaddr();

getaddr(s, sin)
	char *s;
	struct sockaddr_in *sin;
{
	struct hostent *hp;
	struct netent *np;
	int val;

	hp = gethostbyname(s);
	if (hp) {
		sin->sin_family = hp->h_addrtype;
		bcopy(hp->h_addr, (char *)&sin->sin_addr, hp->h_length);
		return;
	}
	np = getnetbyname(s);
	if (np) {
		sin->sin_family = np->n_addrtype;
		sin->sin_addr = inet_makeaddr(np->n_net, INADDR_ANY);
		return;
	}
	sin->sin_family = AF_INET;
	val = inet_addr(s);
	if (val != -1) {
		sin->sin_addr.s_addr = val;
		return;
	}
	val = inet_network(s);
	if (val != -1) {
		sin->sin_addr = inet_makeaddr(val, INADDR_ANY);
		return;
	}
	fprintf(stderr, "%s: bad value\n", s);
	exit(1);
}

