/*
 * Query/Set/Clear if_flags in struct ifnet for an interface.
 * Really should modify ifconfig to do this all.
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/sockio.h>
#include <net/if.h>

main (argc, argv)
int argc;
char **argv;
{
	int sd;
	struct ifreq ifreq;

	if (argc < 2) {
		printf("Usage:   pppconfig interface [+flags] [-flags]\n");
		printf("Example: pppconfig ppp0       +0x4000\n");
		return;
	}
	--argc; ++argv;
	strncpy(ifreq.ifr_name, *argv, IFNAMSIZ);
	sd = socket(PF_INET, SOCK_DGRAM, 0);
	if (ioctl(sd, SIOCGIFFLAGS, &ifreq) == -1) {
		perror("ioctl");
		return;
	}
	printf("%s if_flags = %04x", ifreq.ifr_name, (u_short)ifreq.ifr_flags);
	--argc; ++argv;
	if (argc) {
		for (; argc; --argc, ++argv) {
			switch (**argv) {
			    case '+':
				ifreq.ifr_flags |= strtol(*argv + 1, (char **)0, 16);
				break;
			    case '-':
				ifreq.ifr_flags &= ~strtol(*argv + 1, (char **)0, 16);
				break;
			}
		}
		printf("     new if_flags = %04x", (u_short)ifreq.ifr_flags);
		if (ioctl(sd, SIOCSIFFLAGS, &ifreq) == -1) {
			printf("\n");
			perror("ioctl");
			return;
		}
	}
	printf("\n");
}
