/* -*- c -*-
 *
 * Author:      James A. Brister <brister@vix.com> -- berkeley-unix --
 * Start Date:  Sun, 28 Jan 1996 18:37:49 +1100
 * Project:     INN -- innfeed
 * File:        msgs.h
 * RCSId:       $Id: msgs.h,v 1.13 1996/05/23 21:28:52 brister Exp $
 *
 * Copyright:   Copyright (c) 1996 by Internet Software Consortium
 *
 *              Permission to use, copy, modify, and distribute this
 *              software for any purpose with or without fee is hereby
 *              granted, provided that the above copyright notice and this
 *              permission notice appear in all copies.
 *
 *              THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE
 *              CONSORTIUM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *              SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *              MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL INTERNET
 *              SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
 *              INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *              WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 *              WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 *              TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
 *              USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Description: 
 * 
 */

#if ! defined ( msgs_h__ )
#define msgs_h__

/* Messages used in connection.c */

#define DELETE_LOCKED_CXN       "%s:%d trying to delete locked connection"
#define ARTICLE_FILE_INVALID    "%s:%d article (%s) file no longer valid: %s"
#define ARTICLE_TIMEOUT_MSG     "%s:%d tearing down idle connection"
#define ARTICLE_TIMEOUT_W_Q_MSG "%s:%d idle connection that still has articles"

#define BAD_MODE_RESPONSE       "%s:%d malformed response to MODE STREAM: %s"
#define BANNER_READ_FAILED      "%s:%d banner read failed from remote: %m"
#define COMMAND_WRITE_FAILED    "%s:%d failed to write command to remote: %m"
#define CONNECT_ERROR           "%s:%d connect: %m"
#define CONNECTED               "%s:%d connected"
#define CXN_CLOSE_CTING		"%s:%d closing connection that's connecting."
#define LISTENER_BUFFER_EXPAND_ERROR "inn-listener error expanding input buffer"
#define CXN_BUFFER_EXPAND_ERROR "%s:%d error expanding input buffer"
#define CXN_PERIODIC_CLOSE      "%s:%d periodic close"
#define CXN_REOPEN_FAILED	"%s:%d flush re-connect failed"
#define CXN_DROPPING            "%s:%d remote returned unexpected response 205"
#define CXN_CLOSED              "%s:%d closed"
#define FCNTL_ERROR             "%s:%d can't set socket non-blocking: %m"
#define FILE_MISSING            "%s:%d file for %s (%s) no longer exists"
#define HOST_RESOLV_ERROR       "%s:%d can't resolve hostname: %s: %s"
#define IHAVE_WRITE_FAILED      "%s:%d failed to write IHAVE article body to remote: %m"
#define INVALID_MSGID           "%s:%d received an invalid message-id (%s) in reponse code %d"
#define INVALID_RESP_FORMAT     "%s:%d badly formatted reponse: %s"
#define MAX_ARTTOUT_BIG         "%s:%d max article timeout value too big: %d"
#define MAX_CHECK_BIG           "%s:%d max check value too big: %d"
#define MAX_RESPTOUT_BIG        "%s:%d response timeout value to big: %d"
#define MISSING_ART_IHAVE_BODY	"%s:%d missing article for IHAVE-body"
#define MODE_STREAM_FAILED	"%s:%d couldn't write MODE STREAM command: %m"
#define NOCR_MSG                "%s:%d remote not giving out CR characters"
#define NOMSGID                 "%s:%d no message id in reponse code %d: %s"
#define PREPARE_READ_FAILED     "%s:%d prepare read failed"
#define LISTENER_PREPARE_READ_FAILED     "inn-listener prepare read failed"
#define PREPARE_WRITE_FAILED    "%s:%d prepare write failed"
#define QUIT_WHILE_WRITING      "%s:%d trying to QUIT while write pending"
#define QUIT_WRITE_FAILED       "%s:%d failed to write QUIT command: %m"
#define RESPONSE_BAD_FORMAT     "%s:%d badly formatted response: %s"
#define RESPONSE_READ_FAILED    "%s:%d failed to read response from remote: %m"
#define RESPONSE_TIMEOUT        "%s:%d tearing down non-responsive connection"
#define SOCKET_CREATE_ERROR     "%s:%d can't get a socket: %m"
#define UNKNOWN_MODE_RESPONSE   "%s:%d unknown response to MODE STREAM: %s"
#define UNKNOWN_RESPONSE        "%s:%d unknown response code: %d: %s"
#define CXN_BLOCKED             "%s:%d remote cannot accept articles: %s"
#define CXN_REF_ARTICLE         "%s:%d new connection refused article"
#define STATS_MSG               "%s:%d %s seconds %ld offered %d accepted %d refused %d rejected %d"
#define GETSOCKOPT_FAILED       "%s:%d getsockopt: %m"
#define CONNECTION_FAILURE      "%s:%d connect: %m"
#define IO_FAILED               "%s:%d i/o failed: %m"
#define UNKNOWN_BANNER          "%s:%d %d: %s"



  /* messages used in hosts.c */

#define NO_STATUS		"ME cannot open status file: %s: %m"
#define CONNECTION_DISAPPEARING	"%s connection number %d is vanishing on me"
#define STREAMING_MODE_SWITCH   "%s switching to no-CHECK mode"
#define STREAMING_MODE_UNDO     "%s dropping out of no-CHECK mode"
#define ARTICLE_MISSING         "%s article (%s) file no longer valid: %s"
#define REALLY_FINAL_STATS	"%s global seconds %ld offered %d accepted %d refused %d rejected %d missing %d"
#define HOST_STATS_MSG          "%s %s seconds %ld offered %d accepted %d refused %d rejected %d missing %d spooled %d"
#define HOST_SPOOL_STATS        "%s %s seconds %ld spooled %d"
#define REMOTE_BLOCKED          "%s remote cannot accept articles: %s"
#define CHANGED_REMOTE_BLOCKED  "%s now says it can't accept articles: %s"
#define SPOOLING                "%s no active connections. Spooling."
#define BACKED_UP               "%s getting backed up (%d connections)"
#define UNBACKED_UP             "%s backlog decreasing"
#define REMOTE_DOES_STREAMING   "%s remote supports MODE STREAM"
#define REMOTE_NO_STREAMING     "%s remote does not support MODE STREAM"
#define BACKLOG_TO_TAPE         "%s spooling some backlog."
#define SPOOL_DEFERRED          "%s spooling deferred articles"
#define TOSSING_ARTICLES        "%s discarding articles"
#define STREAMING_CHANGE        "%s running in STREAMING and non-STREAMING mode both at once."
#define NO_POST_PERMISSION      "%s says no permission to send articles (201)."
#define CHANGED_POST_PERMISSION "%s now says we can't post (201)."


/* messages used in innlistener.c */

#define INN_GONE                "ME article input source (innd) is gone. Exiting"
#define INN_IO_ERROR            "ME error on read from input source: %m"
#define INN_BAD_CMD             "ME malformed inn input command: %s"
#define TOO_MANY_HOSTS          "ME too may hosts. (max is %d)"
#define DYNAMIC_PEER            "ME adding peer dynamically (%s)"


/* messages used in commander.c */
#define CMDR_PREP_RD_FAILED     "ME commander connection listen failed"
#define NO_CONNECT              "ME Commander connections from other hosts disallowed"
#define COMMANDER_CONNECT       "ME commander connection from %s"


/* endpoint.c */
#define BAD_SELECT              "ME select failed: %d %m"
#define GETSOCKOPT_FAILURE      "ME exception: getsockopt (%d): %m"
#define EXCEPTION_NOTICE        "ME exception: file descriptor %d: %m"
#define UNKNOWN_EXCEPTION       "ME exception: file descriptor %d. Unknown error."


#define CXN_RESTABISH           "ME %s connection restablished"


#define BAD_ART_READ            "ME Error reading article from file %s: %m"
#define BAD_ART_READ_SIZE       "ME Error reading article from file %s: (%d/%d)"


#define TAPE_OPEN_FAILED        "ME failed to open tape file (%s) %s: %m"
#define STARTING_PROGRAM        "ME starting %s at %s"
#define STOPPING_PROGRAM        "ME finishing at %s"

#define UNKNOWN_PEER            "ME unknown peer name: %s"

#define NO_DEFAULT              "ME no default entry in config file."


/* article.c */
#define NO_ARTICLE              "ME Article file no longer exists: %s: %s"
#define OPEN_FAILURE            "ME open (%s): %m"
#define FSTAT_FAILURE           "ME fstat (%s): %m"
#define REGFILE_FAILURE         "ME file %s not a regular file"
#define PREPARED_NEWLINES       "ME newline to file size ratio: %0.2f (%d/%d)"
#define PREPARE_FAILED          "ME failed to prepare buffer for NNTP"
#define ACTIVE_ARTICLES         "ME articles active %d bytes %d"
#define ARTICLE_ALLOCS          "ME articles total %d bytes %d"
#define MAX_BYTES_LIMIT         "ME exceeding maximum article byte limit: %d (max), %d (cur)"

/* main.c */
#define NO_HOST			"ME Cannot setup host peer %s"
#define NOSUCH_CONFIG           "ME No such config file: %s"
#define NOT_A_DIR               "ME Not a directory: %s"
#define NO_X_AND_S              "ME Can't have '-s' and '-x' together"
#define PIPE_FAILURE            "ME fatal: pipe: %m"
#define FORK_FAILURE            "ME fatal: fork: %m"
#define FOPEN_FAILURE           "ME fopen (%s): %m"
#define PARSE_FAILURE           "ME Error parsing config file"
#define NO_SNAPSHOT		"ME can't open snapshot file: %s: %m"
#define CD_FAILED               "ME fatal: chdir (%s): %m"

/* misc.c */
#define NO_OPEN_LOCK            "ME Can't open lock file: %s: %m"
#define NO_UNLINK_LOCK          "ME Can't unlink lock file: %s: %m"
#define NO_LINK_LOCK            "ME Can't link lock file: %s: %m"
#define BAD_PID                 "ME Bad pid info in lock file %s: %s"
#define NO_WRITE_LOCK_PID       "ME Can't write pid to lock file: %m"
#define LOCK_EXISTS		"ME lock file in use already: %s"

/* tape.c */
#define FILE_SHORT              "ME tell pos is past end of file: %s %ld %ld"
#define NO_LOCK_TAPE            "ME can't lock the host: %s"
#define TAPE_INPUT_ERROR        "ME input error on tape file: %s:  %m"
#define FILE_VANISHED           "ME backlog file has disappeared(?): %s: %m"
#define FCLOSE_FAILED           "ME fclose (%s): %m"
#define UNLINK_FAILED           "ME unlink (%s): %m"
#define RENAME_FAILED           "ME rename (%s,%s): %m"
#define FTELL_FAILED            "ME ftell (%s): %m"
#define FGETS_FAILED            "ME fgets (%s): %m"
#define FSEEK_FAILED            "ME fseek (%s,%ld,SEEK_SET): %m"
#define CHECKPOINT_OPEN         "ME failed to open checkpoint file: %s %m"
#define BAD_CHECKPOINT          "ME checkpoint file had bad value: %s"

#endif /* msgs_h__ */

