/*  $Id: trash.c,v 1.5 1998/03/27 04:08:32 scrappy Exp $
**
**  trashing articles method
*/

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/types.h>
#include <clibrary.h>
#include <macros.h>
#include <configdata.h>
#include <libinn.h>
#include <methods.h>
#include "paths.h"

BOOL trash_init(BOOL *selfexpire) {
    *selfexpire = TRUE;
    return TRUE;
}

TOKEN trash_store(const ARTHANDLE article, STORAGECLASS class) {
    TOKEN               token;

    if (article.token == (TOKEN *)NULL)
	memset(&token, '\0', sizeof(token));
    else {
	memcpy(&token, article.token, sizeof(token));
	memset(&token.token, '\0', STORAGE_TOKEN_LENGTH);
    }
    token.type = TOKEN_TRASH;
    token.class = class;
    return token;
}

ARTHANDLE *trash_retrieve(const TOKEN token, RETRTYPE amount) {
    if (token.type != TOKEN_TRASH) {
	SMseterror(SMERR_INTERNAL, NULL);
	return (ARTHANDLE *)NULL;
    }
    SMseterror(SMERR_NOENT, NULL);
    return (ARTHANDLE *)NULL;
}

void trash_freearticle(ARTHANDLE *article) {
}

BOOL trash_cancel(TOKEN token) {
    SMseterror(SMERR_NOENT, NULL);
    return FALSE;
}

ARTHANDLE *trash_next(const ARTHANDLE *article, RETRTYPE amount) {
    return (ARTHANDLE *)NULL;
}

void trash_shutdown(void) {
}
