#!/bin/sh
# @(#)secs	7.1 26 Apr 1995 14:55:02
#
# secs - compute 'seconds since the epoch' by P1003.1 Posix ISO standard method
#
# Copyright (c) Landon Curt Noll, 1993.
# All rights reserved.
#
# Permission to use and modify is hereby granted so long as this 
# notice remains.  Use at your own risk.  No warranty is implied.
#
# This date system fails on Jan 19, 2038 if expr is limited to 31
# bit signed values, otherwise it failes on Jan 1, 2070.

# the date format to use
#
EP_FMT='X%S + \( X%M \* 60 \) + \( X%H \* 3600 \) + \( X%j \* 86400 \) + \( \( X%y - 70 \) \* 31536000 \) + \( \( \( X%y - 73 \) / 4 \) \* 86400 \)'

# print the seconds since the epoch
eval expr `TZ=UTC date "+$EP_FMT" | sed -e 's/X00* /0 /' -e 's/X0*/0/g'`
