/*  $Revision: 1.2 $
**
**  Parse input to add to news overview database.
*/
#include "configdata.h"
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/uio.h>
#include <fcntl.h>
#include "libinn.h"
#include "clibrary.h"
#include "macros.h"
#include "paths.h"
#include "qio.h"


/*
**  Get the lock for the group, then open the data file and append the
**  new data.  Return FALSE on error.
*/
STATIC BOOL
WriteData(Dir, Art, Rest)
    char		*Dir;
    char		*Art;
    char		*Rest;
{
    static char		TAB[] = "\t";
    static char		NL[] = "\n";
    struct iovec	iov[4];
    char		file[SPOOLNAMEBUFF];
    char		lockfile[SPOOLNAMEBUFF];
    register int	fd;
    register int	lockfd;
    register int	i;
    register BOOL	ok;

    /* Build the I/O vector. */
    i = 0;
    iov[i].iov_base = Art;
    iov[i++].iov_len = strlen(Art);
    iov[i].iov_base = TAB;
    iov[i++].iov_len = 1;
    iov[i].iov_base = Rest;
    iov[i++].iov_len = strlen(Rest);
    iov[i].iov_base = NL;
    iov[i++].iov_len = 1;

    /* Get the lock. */
    (void)sprintf(lockfile, "%s/.LCK%s", Dir, _PATH_OVERVIEW);
    if ((lockfd = open(lockfile, O_WRONLY | O_CREAT, ARTFILE_MODE)) < 0)
	return FALSE;
    (void)LockFile(lockfd, TRUE);

    /* Open data file, write data. */
    (void)sprintf(file, "%s/%s", Dir, _PATH_OVERVIEW);
    if ((fd = open(file, O_WRONLY | O_CREAT | O_APPEND, ARTFILE_MODE)) < 0) {
	i = errno;
	if (unlink(lockfile) < 0)
	    (void)fprintf(stderr, "overchan cant unlink %s %s\n",
		    lockfile, strerror(errno));
	(void)close(lockfd);
	errno = i;
	return FALSE;
    }
    ok = TRUE;
    if (xwritev(fd, iov, i) < 0) {
	(void)fprintf(stderr, "overchan cant write %s %s\n",
		file, strerror(errno));
	ok = FALSE;
    }

    /* Close up and return. */
    if (close(fd) < 0) {
	(void)fprintf(stderr, "overchan cant close %s %s\n",
		file, strerror(errno));
	ok = FALSE;
    }
    if (unlink(lockfile) < 0) {
	(void)fprintf(stderr, "overchan cant unlink %s %s\n",
		lockfile, strerror(errno));
	ok = FALSE;
    }
    (void)close(lockfd);
    return ok;
}


/*
**  Process the input.  Data can come from innd:
**	news/group/name/<number> [space news/group/<number>]... \t data
**  or from mkov:
**	news/group/name \t number \t data
*/
STATIC void
ProcessIncoming(INNinput, qp)
    BOOL		INNinput;
    QIOSTATE		*qp;
{
    register char	*Dir;
    register char	*Art;
    register char	*Rest;
    register char	*p;

    for ( ; ; ) {
	/* Read the first line of data. */
	if ((p = QIOread(qp)) == NULL) {
	    if (QIOtoolong(qp)) {
		(void)fprintf(stderr, "overchan line too long\n");
		continue;
	    }
	    break;
	}

	/* If doing mkov output, process that line and continue. */
	if (!INNinput) {
	    /* Split up the fields. */
	    Dir = p;
	    if ((p = strchr(p, '\t')) == NULL || p[1] == '\0') {
		(void)fprintf(stderr, "overchan missing field 1: %s\n", Dir);
		return;
	    }
	    *p++ = '\0';
	    Art = p;
	    if ((p = strchr(p, '\t')) == NULL || p[1] == '\0') {
		(void)fprintf(stderr, "overchan missing field 2: %s\n", Dir);
		return;
	    }
	    *p++ = '\0';

	    /* Write data. */
	    if (!WriteData(Dir, Art, p))
		(void)fprintf(stderr, "overchan cant update %s %s\n",
			Dir, strerror(errno));
	    continue;
	}

	/* Nip off the first part. */
	Dir = p;
	if ((Rest = strchr(p, '\t')) == NULL) {
	    (void)fprintf(stderr, "overchan bad input\n");
	    continue;
	}
	*Rest++ = '\0';

	/* Process all fields in the first part. */
	for ( ; *Dir; Dir = p) {

	    /* Split up this field, then split it up. */
	    for (p = Dir; *p; p++)
		if (ISWHITE(*p)) {
		    *p++ = '\0';
		    break;
		}

	    if ((Art = strrchr(Dir, '/')) == NULL || Art[1] == '\0') {
		(void)fprintf(stderr, "overchan bad entry %s\n", Dir);
		continue;
	    }
	    *Art++ = '\0';

	    /* Write data. */
	    if (!WriteData(Dir, Art, Rest))
		(void)fprintf(stderr, "overchan cant update %s %s\n",
			Dir, strerror(errno));
	}
    }

    if (QIOerror(qp))
	(void)fprintf(stderr, "overchan cant read %s\n", strerror(errno));
    QIOclose(qp);
}


STATIC NORETURN
Usage()
{
    (void)fprintf(stderr, "usage:  overchan [-c] [-D dir] [files...]\n");
    exit(1);
}


int
main(ac, av)
    int ac;
    char *av[];
{
    register int	i;
    QIOSTATE		*qp;
    char		*Dir;
    BOOL		INNinput;

    /* Parse JCL. */
    (void)umask(0);
    Dir = _PATH_OVERVIEWDIR;
    INNinput = TRUE;
    while ((i = getopt(ac, av, "cD:")) != EOF)
	switch (i) {
	default:
	    Usage();
	    /* NOTREACHED */
	case 'c':
	    INNinput = FALSE;
	    break;
	case 'D':
	    Dir = optarg;
	    break;
	}
    ac -= optind;
    av += optind;

    if (chdir(Dir) < 0) {
	(void)fprintf(stderr, "overchan cant chdir %s %s\n",
		Dir, strerror(errno));
	exit(1);
    }

    if (ac == 0)
	ProcessIncoming(INNinput, QIOfdopen(STDIN, QIO_BUFFER));
    else {
	for ( ; *av; av++)
	    if (EQ(*av, "-"))
		ProcessIncoming(INNinput, QIOfdopen(STDIN, QIO_BUFFER));
	    else if ((qp = QIOopen(*av, QIO_BUFFER)) == NULL)
		(void)fprintf(stderr, "overchan cant open %s %s\n",
			*av, strerror(errno));
	    else
		ProcessIncoming(INNinput, qp);
    }

    exit(0);
    /* NOTREACHED */
}
