#ifndef _SUPCONF_H
#define _SUPCONF_H

#if HAVE_CONFIG_H
#include "config.h"
#endif

#define USAGESTR " RIPE Whois Server Version 3 "

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#if TM_IN_SYS_TIME
#include <sys/time.h>
#else
#include <time.h>
#endif
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/wait.h>
#include <sys/signal.h>
#include <signal.h>
#include <regex.h>

#include <cgi-util.h>
#include <glib.h>

#include "log.h"

struct _queueDefinition {
  gulong queueNumber;
  gchar *ruleName;
  gboolean isRegex;
  gchar *opLhs;
  regex_t opLhsRegex;
  gchar op;
  glong opRhs;
  glong matchCount;
  gboolean matches;
};

typedef struct _queueDefinition queueDefinition;

extern char **environ;

gboolean TEST;

GSList *queueDefinitions;
int QUEUECOUNT;
int FIRSTPORT;
long MAXDATALEN;
gchar *SERVERADDR;
gchar *DBUPDATE;
gchar *LOGFILE;
gchar *PIDFILE;
gchar *ACLFILE;

#define isWhiteSpace(x) ((x==0)||(((x)==' ')||((x)=='\t')))

#define isValidOp(x) (((x)=='=')||((x)=='>')||((x)=='<')||((x)=='!'))

#define splitConfStr(buf,key,val) \
{ \
    key = buf; \
    while (isWhiteSpace(key[0])) \
      key++; \
    val = key; \
    if (val[0]=='~')\
    {\
      val++;\
      while (val[0]!='~') \
        val++;\
    }\
    val++;\
    while (!isWhiteSpace(val[0])) \
      val++; \
    val[0] = 0; \
    val++; \
    while (isWhiteSpace(val[0])) \
      val++; \
    g_strchug(key); \
    g_strchug(val); \
    g_strchomp(key); \
    g_strchomp(val); \
    if (val[0] == '"') { \
      val++; \
      val[strlen(val) - 1] = 0; \
    } \
}

void readConfFile(char *fileName,char *appLogDomain);

#endif
