/******************
  Copyright (c) 2002                                        RIPE NCC

  All Rights Reserved

  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.

  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#ifndef ER_PATHS_H
#define ER_PATHS_H

#include <sys/param.h>
#include <glib.h>

er_ret_t er_attach_filter_chain( char *key, GList *filterlist );
er_ret_t er_register_path(er_path_t *path, char *key );
void er_upd_asparray(void);
er_ret_t er_add_filter( er_path_t *pathptr, er_filter_t *filter );
er_ret_t er_modify_path(  er_path_t *newpath, char *key );
er_ret_t er_delete_filter( char *key,  unsigned filterid );
er_ret_t er_delete_path(char *key );
void er_print_paths(char **retbuf);
void er_add_exec_arg(er_path_t *pathptr, char *arg);

#endif /* ER_PATHS_H */
