/******************
  Copyright (c) 2002                                        RIPE NCC

  All Rights Reserved

  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.

  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#ifndef UPDATE_UPPER_H
#define UPDATE_UPPER_H


#include <stdio.h>
#include <stdlib.h> 
#include <string.h> 
#include <stubs.h>
/*#include <string>*/
#include <glib.h>
/*#include <iostream.h>
#include <fstream>*/

#include <netdb.h> 
#include <sys/types.h> 
#include <netinet/in.h> 
#include <sys/socket.h> 
#include <errno.h> 
#include <unistd.h>

#include "rip.h"
#undef close

#include <config.h>
/* #include <istream.h>
#include "rpsl/object.hh"
#include "util/rusage.hh"
#include "util/debug.hh"
#include "util/trace.hh"
#include "util/Argv.hh"
#include "util/version.hh"
#ifdef IRR_NEEDED
#include "irr/irr.hh"
#include "irr/rawhoisc.hh"
#endif */ /* IRR_NEEDED */
/* #include "rpsl/schema.hh"
*/
#include "erroutines.h"
#include "AU_util.h"
#include "ack.h"
#define private private_xx
#include "mm.h"
#include "mysql_driver.h"
/*#include "mail_parser.h"*/
#undef private


#define MAXDATASIZE 100 /* max number of bytes we can get at once */

#define OVR_OK 0 /* override succeded */


#define ACK_FILE_PREFIX "ack"

extern char *sources[];

typedef enum {
  UP_AUTH_OK=0, /* Auth succeded */
  UP_MOR, /* got more than one object from the db, where extected only one */
  UP_NSO, /* no such object */
  UP_AUF, /* auth failed */
  UP_NIY, /* not implemented yet */
  UP_ABN, /* as-block does not exist */
  UP_HOF, /* hierarchical auth failed */
  UP_OVF, /* override failed */
  UP_OVS, /* override syntax error */
  UP_NOM, /* no match. the old & nw versions of the object are not the same */
  UP_ANE, /* AUTO NIC hdl error */
  UP_FWD, /* mntner or as-block creation will be forwarded to <HUMAILBOX> */
  UP_SYN, /* syntax error in the object */
  UP_NAM, /* name of a person/role object cannot be changed */
  UP_INT  /* internal error */

} return_codes;

typedef struct _up_ripupd_result_struct {
  int result;
  char * error_str;
} up_ripupd_result_struct;



up_ripupd_result_struct * send_object_db(rpsl_object_t * object, char * assigned_NIC, char * operation);

/* char * get_class_type(Object *arg); */

char * get_search_key(rpsl_object_t *object, const char * type);

/* GSList *get_attributes(Object * o, const char * attrib, const char * text); */

char * send_and_get(char * host, int port, char * arg);

int count_objects(char * arg);

char * take_object(char * arg);

char * get_as_block(rpsl_object_t *autnum_object);

char * get_less_specific_domain(rpsl_object_t *domain_object);

char * get_less_specific_set(rpsl_object_t *set_object, const char *type);

char * get_less_specific(rpsl_object_t *inetnum_object, const char *type);

GList *get_mntners(rpsl_object_t * object);

GList *get_auths(char * object_str);

GList *get_attr_list(rpsl_object_t * object, const char * attr_type);

GList *get_mnt_lowers(rpsl_object_t * object);

char *get_override(rpsl_object_t * object);

int check_override(char * string);

GSList * add_to_auth_vector(GSList * list_of_auth_struct, GList * auths, char * mntner_name);

GSList * get_auth_vector(GList * mntners);

GList * get_mntnfy_vector(GList * mntners);

int check_auth(rpsl_object_t *new_object, rpsl_object_t *old_object, const char *type, credentials_struct credentials);

char * get_old_version(rpsl_object_t * object, char * arg);

/* int process_object(char * arg, credentials_struct credentials, GHashTable * NIC_hdl_hash, char * ack_file_name); */

void process_mail_header(credentials_struct * credentials_ptr ,char * header);

int has_ref_to_AUTO_nic_hdl(rpsl_object_t * object);

char * find_email_address(const char * from_line);

char * replace_refs_to_AUTO_NIC_hdl(rpsl_object_t * object, GHashTable * auto_nic_hash , char *arg);

int identical(const char * old_version, rpsl_object_t * object);

int has_AUTO_NIC_hdl(const rpsl_object_t * object);

rpsl_object_t * replace_AUTO_NIC_hdl(rpsl_object_t * object, char * auto_nic_hdl);

/* char * get_class_type_char(char * object); */

void up_string_pack(char *dest, const char *source);

void UP_add_to_upd_log(const char * filename); 

void UP_log_networkupdate(const char * object_str, const char * host);


#endif
