#!/bin/sh
#
#  resync-gnupg-ring-from-sql.sh
#
#  grab the GPG keys from the key-cert objects in the sql database and feed them to
#  GPG to re-create the local key ring
#
#  DA 20001214
#  EG 20010415
#
# This momentarily only with GPG 1.0.4b
# (still in devel), the first version that has --ignore-crc-error
# implemented. The option is needed because some keys couldn't be imported
# for CRC errors, but actually they aren't wrong, it's only the fault
# of bad mailers.

PREFIX="/export/db/utils"
GNUPGHOME="/tmp/.gnupg"; export GNUPGHOME

# gpg binary. Must be a versin that supports --ignore-crc-error option.
GPG=/opt/gnupg-1.0.4d/bin/gpg
TMPFILE="/tmp/gpgtmp.$$"

# DB variables. Change according to your system. 
SQLHOST=localhost
SQLPORT=3306
SQLUSER=dbuser
SQLPASS=dbpassword
SQLDB=DBNAME


mkdir -p $GNUPGHOME

rm -f $GNUPGHOME/pubring.gpg

$PREFIX/extract-keycerts-sql.pl $SQLHOST $SQLPORT $SQLUSER $SQLPASS $SQLDB > $TMPFILE
$GPG --import --batch --ignore-crc-error $TMPFILE

#rm -f $TMPFILE

# eof

