#!/usr/local/bin/perl --    # -*-Perl-*-
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: ripe181stats.pl,v 2.1 1997/10/02 15:26:05 chris Exp $
#

# this little program will do some stats on AS numbers and on route objects
# very rudimentary

$ANFILE="/ncc/dbase/data/ripe/ripe.db.an";
$RTFILE="/ncc/dbase/data/ripe/ripe.db.rt";

if ($ARGV[0]) {
    $ANFILE=$ARGV[0];
    $RTFILE=$ARGV[0];
}

@INC = ("/ncc/dbase/lib", @INC);

require "defines.pl";
require "syntax.pl";
require "enparse.pl";
require "rconf.pl";
require "enwrite.pl";

&rconf("/ncc/dbase/conf");

if (open(FILE, $ANFILE)) {
    while (($tmp, %en) = &enparse(FILE)) {
	last if $tmp == $EOF;
	next if !$en{"an"};
	$ancount++;
	if ($en{"ai"}) {
	    $asin++;
	    $doneasin=1;
	}
	if ($en{"ao"}) {
	    $asout++;
	    $doneasout=1;
	}
	if ($en{"df"}) {
	    $default++;
	    $donedefault=1;
	}
	if ($en{"ue"} =~ m/mnt\-by/) {
	    $notmaintained++;
	}
	$en{"ue"} =~ s/(\n?)the \"aut\-num\" object cannot be updated automatically without a \"mnt\-by\" attribute\n?/\1/;
	if ($en{"uw"}) {
	    print "$en{\"an\"} - $en{\"uw\"}\n";
	    $warnings++;
	}
	if ($en{"ue"}) {
	    print "$en{\"an\"} - $en{\"ue\"}\n";
	    $errors++;
	}
	local(@changed) = split(/\n/, $en{"ch"});
	$changed = 0;
	foreach (@changed) {
	    local($email, $ch) = split(/\s+/, $_);
	    $changed = $ch if $ch > $changed;
	}
	
	if ($changed > 941000) {
	    $latechange++;
	}
	if ($doneasin || $doneasout || $donedefault) {
	    $withpolicy++;
	}
	$doneasin=0;
	$doneasout=0;
	$donedefault=0;

    }
    print "\n\n";
    print "RIPE-181 Autonomous System Statistics\n";
    print "=====================================\n";
    printf "Found %3d       AS objects\n", $ancount;
    printf "      %3d (%2d%%) contain policy info\n",
    $withpolicy, ($withpolicy/$ancount)*100;
    printf "      %3d (%2d%%) have errors\n",
    $errors, ($errors/$ancount)*100;
    printf "      %3d (%2d%%) have warnings\n",
    $warnings, ($warnings/$ancount)*100;
    printf "      %3d (%2d%%) not yet maintained\n",
    $notmaintained, ($notmaintained/$ancount)*100;
    printf "      %3d (%2d%%) changed since 941001\n",
    $latechange, ($latechange/$ancount)*100;

    close(FILE)
} else {
    warn "cannot open $ANFILE: $!";
}

if (open(FILE, $RTFILE)) {
    $latechange = 0;
    while (($tmp, %en) = &enparse(FILE)) {
	last if $tmp == $EOF;
	print STDERR ".";
	next if !$en{"rt"};
	$rtcount++;

	if (!$done{$en{"or"}}) {
	    $done{$en{"or"}} = 1;
	    $orcount++;
	}

        local(@changed) = split(/\n/, $en{"ch"});
        $changed = 0;
        foreach (@changed) {
            local($email, $ch) = split(/\s+/, $_);
            $changed = $ch if $ch > $changed;
        }

        if ($changed > 941200) {
            $latechange++;
        }

    }
    print "\n\n";
    print "RIPE-181 Route Statistics\n";
    print "=====================================\n";
    printf "Found %3d       route objects\n", $rtcount;
    printf "      %3d       different origins\n", $orcount;
    printf "      %3d (%2d%%) changed since 941201\n",
    $latechange, ($latechange/$rtcount)*100;
}
	
