#!PERL
#	$RCSfile: cleanhandledb.pl,v $
#	$Revision: 1.1 $
#	$Author: marten $
#	$Date: 1993/12/06 14:35:48 $

# This program is similar to cleandb.pl, but reindexes only the handle
# databases. It will lock and read from the existing database, and 
# generate new dbm files for all nic handles found for all objects. These
# are determined by the config file. One only needs to run this once a week
# so, since it does not grow that fast.
# !!! Only run this if you have nic handle generation support in your config
# and software !!!

@INC = ("LIBDIR", @INC);

require "rconf.pl";
require "dblock.pl";
require "dbopen.pl";
require "dbclose.pl";
require "enread.pl";
require "handle.pl";

$conffile=$ENV{"RIPEDBCNF"};
$conffile= "DEFCONFIG" unless $conffile;
&rconf($conffile);

# Since we are indexing the live database, let's make sure it is locked
# during the whole period, because we do not want people to add while we
# are working on it.

local(*i) = 'curdb';
&dbopen(i, $ARGV[0]) || die "Cannot open $ARGV[0]: $!";
&dblock(*i);

while (%en = &enread(i)) {
    &AddHandle(*en);
}

&dbunlock(*i);
&dbclose(*i);
