/***************************************

  Protocol mirror module (pw).  Whois protocol.

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Filename            : protocol_mirror.c
  Author              : andrei
  OSs Tested          : Solaris
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include <stdio.h>
#include <glib.h>

#include "protocol_mirror.h"
#include "mysql_driver.h"
#include "constants.h"

//#include "access_control.h"
#include "socket.h"
#include "stubs.h"
#include "ud.h"
#include "ta.h"

#include "ca_configFns.h"
#include "ca_dictSyms.h"
#include "ca_macros.h"
#include "ca_srcAttribs.h"



#define MIN_ARG_LENGTH  6
#define NRTM_DELIM "-:"
/*
* parses input and fills nrtm_q_t structure
*
* Returns:
*  -1 in case of garbage
*  0  in case of valid -g
*  1  in case of -q sources
*
*/
static int parse_request(char *input, nrtm_q_t *nrtm_q)
{
 char *ptr=input;
 char *token;
 char **tokens;
 char **tokens2;
 int res=0;
 
// return(-1);
 
 if(strlen(input)<MIN_ARG_LENGTH) return(-1);
 g_strchug(input);
 res=strncmp(input, "-g", 2);
 if(res!=0) {
	 /* may be this is -q source query */
	 res=strncmp(input, "-q", 2);
	 if(res!=0)return(-1);
	 ptr+=2;
	 g_strchug(ptr);
	 res=strncmp(ptr, "sources", 7);
	 if(res!=0)return(-1);
	 ptr+=7;
	 g_strchug(ptr);
	 token=ptr;
	 if ((*token=='\0') || (*token=='\n'))nrtm_q->source=NULL;
	 else {
	   ptr=index(token, ' ');
	   if (ptr) nrtm_q->source=g_strndup(token, (ptr-token));
	   else nrtm_q->source=g_strdup(token);
	 }
	 return(1);
 }

 /* this is -q query */
 ptr+=2;
 
 
 g_strchug(ptr);
 g_strdelimit(ptr, NRTM_DELIM, ':');
 tokens=g_strsplit(ptr, ":", 4);
 if(tokens==NULL) return(-1);
 
 if(tokens[0]) {
    /* first token is source name */	 
    nrtm_q->source=g_strdup(tokens[0]);
    if(tokens[1]) {
      /* second token is version number */
      nrtm_q->version=atoi(tokens[1]);
      if(tokens[2]) {
	/* this is first serial */      
        nrtm_q->first=atol(tokens[2]);
          if(tokens[3]) {
            /* this is last serial */
              nrtm_q->last=atol(tokens[3]);
          } else res=-1;  
      } else res=-1; 
    } else res=-1;  
 } else res=-1;   
 g_strfreev(tokens);
 
return(res);
}


/* PM_interact() */
/*++++++++++++++++++++++++++++++++++++++
  Interact with the client.

  int sock Socket that client is connected to.

  More:
  +html+ <PRE>
  Authors:
        ottrey
        andrei

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
void PM_interact(int sock) {
  char input[MAX_INPUT_SIZE];
  ca_dbSource_t *source_hdl;
  int read_result;
  int parse_result;
  ip_addr_t address;

  

  char *hostaddress=NULL;
//  acl_st acl_rip,   acl_eip;
  
  sk_conn_st condat;
  nrtm_q_t nrtm_q;
  long current_serial;
  long oldest_serial;
  
  char *object;
  int operation;
  char buff[STR_S];
  
  const char *db_host;
  int  db_port;
  const char *db_name;
  const char *db_user;
  const char *db_pswd;

  GString *gbuff;
  
  SQ_connection_t *sql_connection;     

  /* make a record for thread accounting */
  TA_add(sock, "nrtm_srv");

  
  /* Get the IP of the client */
  hostaddress = SK_getpeername(sock);
  printf("SK address: %s\n", hostaddress);
  
  /* initialise the connection structure */
  memset( &condat, 0, sizeof(sk_conn_st));
  /* set the connection data: both rIP and eIP to real IP */
  condat.sock = sock;
  condat.ip = hostaddress;
  SK_getpeerip(sock, &(condat.rIP));
  memcpy( &(condat.eIP), &(condat.rIP), sizeof(ip_addr_t));


  /* Read input */
  read_result = SK_cd_gets(&(condat), input, MAX_INPUT_SIZE);
    
  /* read_result < 0 is an error and connection should be closed */
  if (read_result < 0 ) {
      /* log the fact, rtc was set */
//not yet, SK_... returns arb number      return; 
  }
    
  parse_result = parse_request(input, &nrtm_q);
  if (parse_result < 0 ) {
      fprintf(stderr, "Garbage received: %s\n", input);
      /* log the fact and exit */
      /* Free the hostaddress */
      SK_cd_close(&(condat));
      free(hostaddress);
      free(nrtm_q.source);
      return;
  }
  if (parse_result == 1 ) {
	  
     fprintf(stderr, "-q sources\n"); 
     gbuff=PM_get_nrtm_sources(&(condat.rIP), nrtm_q.source);
     SK_cd_puts(&condat, gbuff->str);
     /* Free allocated memory  */
     g_string_free(gbuff, TRUE);
     free(hostaddress);
     free(nrtm_q.source);
     SK_cd_close(&(condat));
     return;
  }
     
  source_hdl = ca_get_SourceHandleByName(nrtm_q.source); 
  if (source_hdl == NULL){
     sprintf(buff, "\n%%ERROR 6: Unknown source\n\n");
     SK_cd_puts(&condat, buff);
     free(hostaddress);
     free(nrtm_q.source);
     SK_cd_close(&(condat));
     return;
  }
	 
  /* check if the client is authorized to mirror */
  SK_getpeerip(sock, &address);
  if(!AA_can_mirror(&address, nrtm_q.source)){
     sprintf(buff, "\n%%ERROR 5: You are not authorized to mirror the database\n\n");
     SK_cd_puts(&condat, buff);
     free(hostaddress);
     free(nrtm_q.source);
     SK_cd_close(&(condat));
     return;
  }

      
    
  /* get database */
/*  db_name=CO_get_database(); */
  db_name = ca_get_srcdbname(source_hdl);
      
  /* get database host*/
/*  db_host=CO_get_host();*/
  db_host = ca_get_srcdbmachine(source_hdl);      
  /* get database port*/
/*  db_port=CO_get_database_port();*/
  db_port = ca_get_srcdbport(source_hdl);        
  /* get database user*/
/*  db_user=CO_get_user(); */
  db_user = ca_get_srcdbuser(source_hdl);          
  /* get database password*/
/*  db_pswd=CO_get_password(); */
  db_pswd = ca_get_srcdbpassword(source_hdl);
  
  fprintf(stderr, "D: Making SQL connection to %s@%s ...", db_name, db_host);
  sql_connection = SQ_get_connection(db_host, db_port,db_name, db_user, db_pswd);
  if(!sql_connection) {
      fprintf(stderr, "E: ERROR: no SQL connection\n");
      return;
  }
  fprintf(stderr, "OK\n");

  /* free copies of the variables */
  free(db_host);
  free(db_name);
  free(db_user);
  free(db_pswd);
                                                        
  current_serial=PM_get_current_serial(sql_connection);
  oldest_serial=PM_get_oldest_serial(sql_connection);
    
  if((current_serial==-1) || (oldest_serial==-1)) {
      fprintf(stderr, "E: ERROR: cannot get serial #\n");
      /* Free the hostaddress */
      SK_cd_close(&(condat));
      free(hostaddress);
      free(nrtm_q.source);
      return;
  }
  
  /* zero indicates that LAST keyword has been used */    
  if(nrtm_q.last==0)nrtm_q.last=current_serial;
  
    
  if((nrtm_q.first>nrtm_q.last) || (nrtm_q.first<oldest_serial) || (nrtm_q.last>current_serial)) {
      if(nrtm_q.first<oldest_serial) nrtm_q.last=oldest_serial-1;
      if(nrtm_q.last>current_serial) nrtm_q.first=current_serial+1;
      fprintf(stderr, "E: ERROR: invalid range\n");
      /* write error message back to the client */
/*      sprintf(buff, "%%ERROR:4: Invalid range: serial(s) %ld-%ld don't exist\n", nrtm_q.first, nrtm_q.last); */
      sprintf(buff, "\n%%ERROR:4: Invalid range: Not within %ld-%ld\n\n", oldest_serial, current_serial);
      SK_cd_puts(&condat, buff);
      SK_cd_close(&(condat));

      /* Free the hostaddress */
      free(hostaddress);
      free(nrtm_q.source);
      return;
  }
  
  current_serial=nrtm_q.first;
  /* print banner */
  
  sprintf(buff, "%%START Version:%d %s %ld-%ld\n", nrtm_q.version, nrtm_q.source, nrtm_q.first, nrtm_q.last);
  SK_cd_puts(&condat, buff);

  /* make a record for thread accounting */
  TA_setactivity(buff);
  
/* now start feeding client with data */    
  do {    

    object=PM_get_serial_object(sql_connection, current_serial, &operation);
    if (operation == OP_ADD) SK_cd_puts(&condat, "\nADD\n\n");
    else SK_cd_puts(&condat, "\nDEL\n\n");
    
    SK_cd_puts(&condat, object);
      
    free(object);
    current_serial++;


  } /* do */
   while((current_serial<=nrtm_q.last) && (condat.rtc == 0));

  
  sprintf(buff, "\n%%END %s\n\n", nrtm_q.source);
  SK_cd_puts(&condat, buff);

  /* make a record for thread accounting */
  TA_delete();
  
  SK_cd_close(&(condat));
  /* Free the hostaddress */
  free(hostaddress);
  free(nrtm_q.source);

  
  
} /* PM_interact() */
