#ifndef PM_H
#define PM_H

#include "mysql_driver.h"

/***************************************
  $Revision: 1.2 $

  Protocol whois module (pw).  Whois protocol.

  Status: NOT REVUED, NOT TESTED

  +html+ <DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL>
  +html+ </DL>
  +html+ <PRE>
  Author:
      ottrey
      marek
      andrei
  +html+ </PRE>
 
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
/*+ String sizes +*/
#define STR_S   63
#define STR_M   255
#define STR_L   1023
#define STR_XL  4095
#define STR_XXL 16383

/*+ Maximum size of input that can be recieved from the client. +*/
#define MAX_INPUT_SIZE  1024

typedef struct _nrtm_q_t {
 int source;
 int version;
 long first;
 long last;
} nrtm_q_t;
    
#define PM_get_current_serial(connection) PM_get_minmax_serial(connection, 1)
#define PM_get_oldest_serial(connection) PM_get_minmax_serial(connection, 0)


long PM_get_minmax_serial(SQ_connection_t *sql_connection, int max);
char *PM_get_serial_object(SQ_connection_t *sql_connection, long serial_number, int *operation);


void PM_interact(int sock);

#endif /* PM_H */
