/***************************************

  Functions for handling serials  

  Status: NOT REVUED, NOT TESTED

 Author(s):       Andrei Robachevsky

  ******************/ /******************
  Modification History:
        andrei (08/02/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/
#include "ud.h"
#include "ud_int.h"

/************************************************************
* create_serial()                                           *     
*                                                           *
* Creates a serial record for given transaction             *
* For updates creates 2 serial records (DEL+ADD)            *
*                                                           *
* Important fields of transaction are:                      *
* tr->action        TR_CREATE/TR_UPDATE/TR_DELETE           *
* tr->object_id     should be filled in                     *
* tr->sequence_id   should be set to current                *
*                                                           *
* Returns:                                                  *
*  currnt serial number.                                    *
*  -1 in case of an error                                   *
*                                                           *
*************************************************************/

long create_serial(Transaction_t *tr)
{
static char query[STR_M];
long current_serial=0;
int sql_err;

/* fprintf(stderr, "creating serial\n"); */

  if(!ACT_CREATE(tr->action)) { 
    /* set the atlast field of the latest record for this object to 0 */
    /* because it is moved to history */
    sprintf(query, "UPDATE serials SET atlast=0 "
                   "WHERE object_id=%ld "
                   "AND sequence_id=%ld ", tr->object_id, tr->sequence_id-1);
    
    sql_err = SQ_execute_query(tr->sql_connection, query, (SQ_result_set_t **)NULL);
    if (sql_err) { // we can have empty updates, but not errors
        fprintf(stderr, "E: <create_serial>: cannot update %s\n", query);
        current_serial=-1;
    }
    
    
    /* generate DEL serial */
    sprintf(query, "INSERT serials SET "
                   "object_id=%ld, "
                   "sequence_id=%ld, "
                   "atlast=0, "
                   "operation=%d ", tr->object_id, tr->sequence_id-1, OP_DEL);
    
    sql_err = SQ_execute_query(tr->sql_connection, query, (SQ_result_set_t **)NULL);
    if (sql_err) {
        fprintf(stderr, "E: <create_serial>: cannot insert %s\n",query);
        current_serial=-1;
    }    
    
    if(current_serial!=-1)current_serial=mysql_insert_id(tr->sql_connection);
    
    /* there is nothing more to do when OP_DEL */
    if(ACT_DELETE(tr->action)) return(current_serial);
  }

  /* now insert creation serial */
  sprintf(query, "INSERT serials SET "
                 "object_id=%ld, "
                 "sequence_id=%ld, "
                 "atlast=1, "
                 "operation=%d ", tr->object_id, tr->sequence_id, OP_ADD);
    
  sql_err = SQ_execute_query(tr->sql_connection, query, (SQ_result_set_t **)NULL);
  if (sql_err) {
        fprintf(stderr, "E: <create_serial>: cannot insert %s\n",query);
        current_serial=-1;
  }    
    
  if(current_serial!=-1)current_serial=mysql_insert_id(tr->sql_connection);
        
return(current_serial);
}

