      PROGRAM invgamma_node
      implicit none
      include 'fpvm3.h'
      real*8 x, y, eps
      integer nterms
      complex*16 z, invgamma, res
      integer HOST, rc, msglabel
      
      CALL attach_host(HOST)
 100  continue      
      
      msglabel = 1000
      CALL PVMFrecv(HOST,msglabel,rc)
      CALL PVMFunpack(REAL8,eps,1,1,rc)
      CALL PVMFunpack(REAL8,x,1,1,rc)
      CALL PVMFunpack(REAL8,y,1,1,rc)
      
      z = cmplx(x,y)
      res = invgamma(z,eps,nterms)
      
      msglabel = 2000
      CALL PVMFinitsend(PvmDataDefault,rc)
      CALL PVMFpack(INTEGER4,nterms,1,1,rc)
      CALL PVMFpack(COMPLEX16,z,1,1,rc)
      CALL PVMFpack(COMPLEX16,res,1,1,rc)
      CALL PVMFsend(HOST,msglabel,rc)
      
      goto 100
      END

      FUNCTION invgamma(zinput,eps,nterms)
      implicit none
      complex*16 zinput, z, invgamma, zn, fun, term
      real*8 g, eps, smalleps, magn, oldmagn
      parameter (g=0.5772156649)
      parameter (smalleps = 1E-12)
      integer n, ninf, iz, nterms
      parameter (ninf = 1 000 000 000)
      z = zinput
      iz = z
      if (z .eq. iz) z = z + smalleps
      term = log(z) + g*z
      fun = exp(term)
      magn = abs(fun)
      do n=1,ninf
         oldmagn = magn
         zn = z/n
         term = term + log(1 + zn) - zn
         fun = exp(term)
         magn = abs(fun)
         if (abs(magn - oldmagn) .le. eps) then
            nterms = n
            invgamma = fun
            return
         endif
      enddo
      END 
      
      SUBROUTINE attach_host(HOST)
      implicit none
      include 'fpvm3.h'
      integer HOST, mytid
      CALL PVMFmytid(mytid)
      CALL PVMFparent(HOST)
      end      
