/* gprod.h - macro */

#if defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK)

#undef  DIRECT_METHOD
#ifndef MULTIP
#define MULTIP
#define DIRECT_METHOD
#endif

static int FUNC(data, ndata, result)
     TYPE *data;
     int ndata;
     TYPE *result;
{
  if (ME > 0) { /* Nodes with # > 0  */
    pvm_initsend(INITHOW_node);
    PACK(data, ndata, 1);          /* Send my contribution */
    pvm_send(NODEID[0], MSG_PROD);
    
#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(4,0,MSG_PROD,MULTIP sizeof(*data) * ndata);
      TRACEF(7,MSG_PROD);
    }
#endif

    pvm_recv(NODEID[0], MSG_PROD);
    UNPACK(result, ndata, 1);

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(8,0,MSG_PROD,MULTIP sizeof(*data) * ndata);
    }
#endif
  }
  else { /* Node == 0 */
    int i, j;
    TYPE *tmp = (TYPE *)malloc( MULTIP ndata * sizeof(*tmp) );

    if (result != data) {
      for (i=0; i<MULTIP ndata; i++) {
	result[i] = data[i];
      }
    }

    for (j=1; j<NUMNODES; j++) {

#ifdef PICL
      if (logfp) {
        TRACETIME();
        TRACEF(7,MSG_PROD);
      }
#endif

      pvm_recv(ANYBODY, MSG_PROD);
      UNPACK(tmp, ndata, 1);       /* Recv somebody's contribution */

#ifdef PICL
      if (logfp) {
        int source;
        recvinfo(NOCARE, &source, NULL, NULL);
        TRACETIME();
        TRACEF(8,source,MSG_PROD,MULTIP sizeof(*data) * ndata);
      }
#endif

#ifdef DIRECT_METHOD
      for (i=0; i<MULTIP ndata; i++) {
	result[i] *= tmp[i];
      }
#else /* COMPLEX-pair */
      for (i=0; i<2*ndata; i += 2) {
	TYPE real_part = result[i]*tmp[i] - result[i+1]*tmp[i+1];
	TYPE imag_part = result[i]*tmp[i+1] + result[i+1]*tmp[i];
	result[i]   = real_part;
	result[i+1] = imag_part;
      }
#endif
    }

    free(tmp);
      
    pvm_initsend(INITHOW_node);
    PACK(result, ndata, 1);
    pvm_mcast(&NODEID[1], NUMNODES-1, MSG_PROD);

#ifdef PICL
    if (logfp) {
      TRACETIME();
      for (i=1; i<NUMNODES; i++)
	TRACEF(4,i,MSG_PROD,MULTIP sizeof(*data) * ndata);
    }
#endif
  }

  return 0;
}


#undef DIRECT_METHOD
#undef MULTIP
#undef FUNC
#undef TYPE
#undef PACK
#undef UNPACK

#endif  /* defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK) */
