/* gdot.h - macro */

#if defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK)

#undef  DIRECT_METHOD
#ifndef MULTIP
#define MULTIP
#define DIRECT_METHOD
#endif

static int FUNC(data1, data2, ndata, result)
     TYPE *data1;
     TYPE *data2;
     int ndata;
     TYPE *result;
{
  TYPE dotproduct[2];
  int i;

  dotproduct[0] = 0; /* Real part */
  dotproduct[1] = 0; /* Imag part */

#ifdef DIRECT_METHOD
  for (i=0; i<ndata; i++) {
    dotproduct[0] += data1[i] * data2[i];
  }
#else /* COMPLEX-pair */
  for (i=0; i<2*ndata; i += 2) {
    dotproduct[0] += data1[i]*data2[i] - data1[i+1]*data2[i+1];
    dotproduct[1] += data1[i]*data2[i+1] + data1[i+1]*data2[i];
  }
#endif

  return gsum(dotproduct,1,result);
}


#undef DIRECT_METHOD
#undef MULTIP
#undef FUNC
#undef TYPE
#undef PACK
#undef UNPACK

#endif  /* defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK) */
