#include "easy.h"

int 
FUNCTION(multicast) 
ARGS(`set_of_dest, numdest, msgtag, data, ndata')
int *set_of_dest;
int *numdest;
int *msgtag;
void *data;
int *ndata;
{
  int retcode;
  int olddatatype = FUNCALL(getdatatype)();
  int oldstride;

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(BYTE1);
    oldstride = FUNCALL(setstride)(1);
  }

  retcode = FUNCALL(multicast)(set_of_dest, *numdest, *msgtag, data, *ndata);

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(STRING);
    FUNCALL(setstride)(oldstride);
  }

  return retcode;
}


int 
FUNCTION(multicast2d) 
ARGS(`set_of_dest, numdest, msgtag, data, nrows, ncols, offset')
int *set_of_dest;
int *numdest;
int *msgtag;
void *data;
int *nrows;
int *ncols;
int *offset;
{
  int retcode;
  int olddatatype = FUNCALL(getdatatype)();
  int oldstride;

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(BYTE1);
    oldstride = FUNCALL(setstride)(1);
  }

  retcode = FUNCALL(multicast2d)(set_of_dest, *numdest, *msgtag, 
			data, *nrows, *ncols, *offset);

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(STRING);
    FUNCALL(setstride)(oldstride);
  }

  return retcode;
}

