#!/bin/csh -f
#
# Generates records for "easy.h" to prevent name clash.
# Adds prefix "easy_" to every function name.
# Include/substitute the output generated by this routine in "easy.h".
#

echo "#ifndef DO_NOT_PREVENT_NAME_CLASH"
echo "/* Generated at `date` */"
(echo "MPP_Info procinfo"; egrep '^int|^double|^void' easy.h) |\
  awk '{printf("#define %-15s easy_%s\n",$2,$2);}' | sort
echo "#endif   /* not DO_NOT_PREVENT_NAME_CLASH */"

exit 0
