      subroutine transp(a,r,atrans)
c
c..   Transpose of a matrix in a distributed memory
c
      implicit none

      include 'fpvm3.h'
      include 'feasy.h'

      integer r, blksize
      double precision a(r,r,*), atrans(r,r,*)
      integer nnodes, me, oldtype
      integer ncount
      integer i,j,k
      double precision swap

      nnodes = numnodes()
      me = mynode()

c..   Playing with REAL*8's
      oldtype = setdatatype(REAL8)

c..   Do complete exchange 
      blksize = r*r
      call gcxch(a,blksize,atrans)
      
c..   Transpose matrix
      do k=1,nnodes
         do j=1,r
            do i=j+1,r
               swap = atrans(i,j,k)
               atrans(i,j,k) = atrans(j,i,k)
               atrans(j,i,k) = swap
            enddo
         enddo
      enddo

c..   Restore the old data type
      oldtype = setdatatype(oldtype)

      end

      subroutine init(a,atrans,r)
c
c..   Initialize matrices
c
      implicit none

      include 'fpvm3.h'
      include 'feasy.h'

      integer r
      double precision a(r,r,*), atrans(r,r,*)
      integer nnodes, me
      integer i,j,k,kount
      
      nnodes = numnodes()
      me = mynode()

      kount = 0
      do k=1,nnodes
         do j=1,r
            do i=1,r
               a(i,j,k) = k*10.0 + kount + me/10.0
               atrans(i,j,k) = -1.0
               kount = kount + 1
            enddo
         enddo
      enddo
      
      end
