
#include "rtep.h"

/***************************************************************************/
/* FUNCTION: int prog_opts()
/*
/* DESCRIPTION:
/*    Print program options information to standard out.
/*
/* USAGE:
/*    error_ret = prog_opts(num_opts,opt_array,opt_desc);
/*
/* ARGUMENTS:
/*    int   num_opts     (in) : number of options
/*    char  *opt_array[] (in) : array of command line option strings
/*    char  *opt_desc[]  (in) : array of option descriptor strings
/*
/* RETURNS: (int)
/*    0 : function call completed successfully
/*    1 : opt_array[] or opt_desc[] contains a NULL entry
/*
/* COMMENTS:
/*    opt_array[0] should be set equal to opt_desc[0] to avoid
/*    errors and compatibility problems on some systems.
/*
/* EXAMPLE:
/*    char *opt_array[2],*opt_desc[2];
/*    opt_desc[0] = "test [-options] <infile> <outfile>";
/*    opt_array[0] = opt_desc[0];
/*    opt_array[1] = "-asc"; opt_desc[1] = "(ascii file)";
/*    err_ret = prog_opts(2,opt_array,opt_desc);
/*
/*    The above code would print the following:
/*    
/* Usage   : test [-options] <infile> <outfile>
/*           -asc (ascii  file)
/*
/* SEE ALSO:
/*    prog_title(), opt_index().
/*
/* INFO:
/*    Author : Ray Idaszak
/*    Date   : November 14, 1988
/*    email  : rayi@ncsa.uiuc.edu
/***************************************************************************/

int prog_opts(num_opts,opt_array,opt_desc)
int num_opts;
char *opt_array[],*opt_desc[];
{
	int i,err_ret;
	int ml = 1;

	err_ret = 0;

	for(i=0; i<num_opts; i++){
		if ((!opt_desc[i]) || (!opt_array[i])){
			err_ret = 1;
			goto error;
		}
		if ((strlen(opt_desc[i]) < ml) || (strlen(opt_array[i]) < ml)){
			err_ret = 1;
			goto error;
		}
	}

	printf("Usage   : %s\n",opt_desc[0]);
	for(i=1; i<num_opts; i++){
		printf("           %s %s\n",opt_array[i],opt_desc[i]);
		}
	printf("\n");

error:
#if RTE_PRERR
	err_msg("prog_opts",err_ret);
#endif
	return(err_ret);

}

