/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: fileIO.c,v 1.9 1993/11/05 21:56:22 gbourhis Exp $";
#endif

/* $Log: fileIO.c,v $
 * Revision 1.9  1993/11/05  21:56:22  gbourhis
 * Fix a bug in ReadHDFRasterGroup(): the palette don't need to have the
 * same ref #.
 *
 */

#include <X11/Xlib.h>
#include <stdio.h>

#include <hdf/hdf.h>

#include "collageP.h"
#include "netdata.h"
#include "support.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif


#ifndef MALLOC
#define MALLOC	malloc
#define FREE	free
#endif

extern unsigned char *ReadGifBitmap();

int IsItHDF(fileName)
char *fileName;
{
    int32 fid;
    
    fid = SDstart(fileName, DFACC_RDONLY);

    if (fid == FAIL)
        return(FALSE);

    SDend(fid);
    return(TRUE);

}

int ReadNumberOfRasterImages(fileName)
char *fileName;
{
int num;

	num = DFR8nimages(fileName);

	if (num < 1)
		return(0);
	else
		return(num);
}


int ReadDimsOfRasterImage(fileName,xdim,ydim,hasPalette)
char *fileName;
int *xdim;
int *ydim;
int *hasPalette;
{
int ret;
        ret = DFR8getdims(fileName,(int32 *)xdim,(int32 *)ydim,hasPalette);
	if (ret == -1)
		return(0);
	else
		return(1);
}



int ReadRasterImage(fileName,image,pal,hasPalette)
char *fileName;
Data *image;
Data *pal;
int *hasPalette;
{
int32   xdim,ydim;
unsigned char *palette;
unsigned char *raster;

	if ( -1 == DFR8getdims(fileName,&xdim,&ydim,hasPalette)) {
                ErrMesg("Error reading raster image\n");
                return(0);
                }
	if (!(raster = (unsigned char *) MALLOC(xdim*ydim))) {
		ErrMesg("Out of memory reading image\n");
		return(0);
		}
	if (*hasPalette) {
		if (!(palette = (unsigned char *) MALLOC(768))) {
			ErrMesg("Out of memory reading palette\n");
			return(0);
			}
		if (!(pal->label =(char *)MALLOC(strlen(fileName)+1))){
                                ErrMesg("Out of Memory loading image\n");
                                return(0);
                                }
		strcpy(pal->label,fileName);

		pal->entity = ENT_Internal;
		pal->dot = DOT_Palette8;
		pal->dost = DOST_Char;
		pal->rank = 2;
		pal->dim[0]=3;
		pal->dim[1]=256;
		pal->data = (GenericPtr) palette;
		}

	if (!(image->label =(char *)MALLOC(strlen(fileName)+1))){
		ErrMesg("Out of Memory loading image");
		return(0);
		}
	strcpy(image->label,fileName);
        image->entity = ENT_Internal;
        image->dot = DOT_Array;
        image->dost = DOST_Char;
        image->rank = 2;
	image->dim[0] = xdim;
	image->dim[1] = ydim;
	image->data = (GenericPtr) raster;

        if (-1 == DFR8getimage(fileName,raster,xdim,ydim,pal->data)) {
                ErrMesg("Error reading animation image");
                return(0);
                }
	return(1);


}



int ReadRIS8FromAnimation(file,raster,xdim,ydim,frameNum)
char *file;
unsigned char *raster;
int xdim,ydim;
int	frameNum; 
{
/* int x; */
int	ispalette;
/* int	n; */
int32   fxdim,fydim;

	DFR8restart();

	if ( 1 < (/* n = */ DFR8nimages(file))) {
		if ( -1 == DFR8readref(file,frameNum)){
			ErrMesg("Error reading animation image");
			return(0);
			}
		}
	else {
		DFR8restart();
		}

	if ( -1 == DFR8getdims(file,&fxdim,&fydim,&ispalette)) {
		ErrMesg("Error reading animation image");
		return(0);
		}

	if ((fxdim != xdim) || (fydim != ydim)) {
		ErrMesg("Not all animation images are of same size");
		return(0);
		}

	if (-1 == DFR8getimage(file,raster,xdim,ydim,NULL)) {
		ErrMesg("Error reading animation image");
		return(0);
		}

	return(xdim*ydim);

} /* ReadHDFAnimationImage() */



Data *ReadHDFPalette8Data(fileName,tag,ref,isanim)
char *fileName;
int tag;
int ref;
int isanim;
{
char buff[256];
Data *pal;
int length;
  
	DFPrestart();
	if (0 > DFPreadref(fileName,ref)) {
		sprintf(buff,"Can't set palette ref to %d in %s \n",
				ref,fileName);
		ErrMesg(buff);
		return(0);
		}
	if (!(pal = DataNew()))
		return(0);

	pal->entity = ENT_Internal;
	pal->dot = DOT_Palette8;
	pal->dost = DOST_Char;
	pal->rank = 2;
	pal->dim[0]=3;
	pal->dim[1]=256;
  
	if (!(pal->data = (GenericPtr) MALLOC(769))) {
		ErrMesg("Can't allocate memory for palette\n");
		DataDestroy(pal);
		return(0);
		}
  
	if (DFPgetpal(fileName,pal->data)) {
		sprintf(buff,"Can't get palette from file %s\n",fileName);
		ErrMesg(buff);
		DataDestroy(pal);
		return(0);
		}

	length = DFANgetlablen(fileName,tag,ref);
	if (length > 0) {
		if (!(pal->label = (char *) MALLOC(length+1))){
			ErrMesg("Out of Memory reading palette\n");
			pal->label = "Out of Memory";
			return(pal);
			}
		DFANgetlabel(fileName,tag,ref,pal->label,length+1);
		}
	else {
		if (isanim) {
			if (pal->label = (char *) MALLOC(strlen(fileName)+1)){
				strcpy(pal->label,fileName);
				}
			else {
				pal->label = "Out of Memory";
				}
			}
		else {
			if (pal->label = (char *) MALLOC(strlen(fileName)+20)){
	  			sprintf(pal->label,"%s_%d:%d",fileName,tag,ref);
				}
			else {
				pal->label = "Out of Memory";
				}
			}
		}
	return(pal);
}

#define CONVFROM(TYPE, TOTYPE, MEMBER)				          	\
  do {									        \
  TYPE minr, maxr;						         	\
      if (SDgetrange(sdsid, (GenericPtr)&maxr, (GenericPtr)&minr) != FAIL)	\
           d->max.MEMBER = (TOTYPE)maxr, d->min.MEMBER = (TOTYPE)minr;	        \
      else d->max.MEMBER = d->min.MEMBER = (TOTYPE)0;			        \
      } while(0)

Data *ReadHDFSDSData(fileName, tag, ref, isanim)
     char *fileName;
     int tag;
     int ref;
     int isanim;
{
    register int i;
    int size;
    Data *d;
    char buff[256];
    int length;
    int tmp;
    int32 numberType;
    GenericPtr tBuf;
    int32 fid, sdsid;
    int32 nt, nattr, dims[100], rank;
    char   name[512];
    int32  start[32], end[32];
    
#ifdef DEBUG
    printf("ReadHDFSDS() I've been called\n");
#endif
    
    fid = SDstart(fileName, DFACC_RDONLY);
    if(fid == FAIL) return NULL;
    
    sdsid = SDselect(fid, ref);
    if(sdsid == FAIL) return NULL;
    
    if ((d = DataNew()) == NULL) 
        return NULL;
    d->entity = ENT_Internal;
    d->dot = DOT_Array;
    d->dost = DOST_Float;
    
    if(SDgetinfo(sdsid, name, &(d->rank), d->dim, &numberType, &nattr) == FAIL) {
        ErrMesg("Couldn't get basic information about dataset\n");
        return NULL;
    }

    for(i = 0, size = 1; i < d->rank; i++) {
        start[i] = 0;
        end[i]   = d->dim[i];
        size    *= d->dim[i];
    }

    /*
     * With HDF 3.2 SDGs (aka NDGs) can now store many different
     *   types of numbers, as opposed to previous versions which
     *   were only able to store 32-bit floating point numbers.
     * For now, read the numbers in and just cast them over to 
     *   floats.  Something more elegant can be coded later...
     */
    
    /* allocate storage to store the raw numbers */
    if (!(tBuf = (GenericPtr) MALLOC(size * DFKNTsize(numberType)))) {
        ErrMesg("Couldn't allocate temporary space for SDS");
        return(0);
    }
    
    /* Read it all into the temporary storage */
    if (SDreaddata(sdsid, start, NULL, end, tBuf)) {
        ErrMesg("Couldn't read in SDS data\nSDreaddata() failed");
        return(0);
    }

    /* OK, now allocate the correct location for the data */
    if ((numberType == DFNT_FLOAT32)||(numberType == DFNT_FLOAT64))
    {
	if (!(d->data = (GenericPtr) MALLOC(size * sizeof(float)))) {
		ErrMesg("Couldn't allocate space for SDS");
		return(0);
	}
    }
    else
    {
	if (!(d->data = (GenericPtr) MALLOC(size * sizeof(int32)))) {
		ErrMesg("Couldn't allocate space for SDS");
		return(0);
	}
    }

    /* cast the numbers over to floats or int32 */
    switch (numberType) {
    
    case DFNT_CHAR8:
	{
	    int32 *dest  = (int32 *) d->data;
	    char8   *idata  = (char8 *) tBuf;
	    for(i = 0; i < size; i++)
	       dest[i] = (int32) idata[i];
	    d->dost = DOST_Int32;
	}
	CONVFROM(char8, int32, i);
	break;

    case DFNT_INT8:
	{
	    int32 *dest  = (int32 *) d->data;
	    int8   *idata  = (int8 *) tBuf;
	    for(i = 0; i < size; i++)
	       dest[i] = (int32) idata[i];
	    d->dost = DOST_Int32;
	}
	CONVFROM(int8, int32, i);
	break;

    case DFNT_UINT8:
        {
            int32 *dest  = (int32 *) d->data;
            uint8   *idata = (uint8 *) tBuf;
            for(i = 0; i < size; i++) 
                dest[i] = (int32) idata[i];
	    d->dost = DOST_Int32;
        }
	CONVFROM(uint8, int32, i);
        break;

    case DFNT_INT16:
        {
            int32 *dest  = (int32 *) d->data;
            int16   *idata = (int16 *) tBuf;
            for(i = 0; i < size; i++) 
                dest[i] = (int32) idata[i];
	    d->dost = DOST_Int32;
        }
	CONVFROM(int16, int32, i);
        break;   

    case DFNT_UINT16:
        {
            int32 *dest  = (int32 *) d->data;
            uint16  *idata = (uint16 *) tBuf;
            for(i = 0; i < size; i++) 
                dest[i] = (int32) idata[i];
	    d->dost = DOST_Int32;
        }
	CONVFROM(uint16, int32, i);
        break;
        
    case DFNT_INT32:
#ifdef OLD_WAY
        HDmemcopy(tBuf, d->data, size * sizeof(int32));
#else
	memcpy(d->data, tBuf, size * sizeof(int32));
#endif
	d->dost = DOST_Int32;
	if (SDgetrange(sdsid, (GenericPtr)&d->max, (GenericPtr)&d->min) == -1)
	  d->max.i = d->min.i = 0;

        break;   
    
    case DFNT_UINT32:
        {
            int32 *dest  = (int32 *) d->data;
            uint32  *idata = (uint32 *) tBuf;
            for(i = 0; i < size; i++) 
                dest[i] = (int32) idata[i];
	    d->dost = DOST_Int32;
        }
	CONVFROM(uint32, int32, i);
        break;

    case DFNT_FLOAT32:
#ifdef OLD_WAY
        HDmemcopy(tBuf, d->data, size * sizeof(float));
#else
	memcpy(d->data, tBuf, size * sizeof(float));
#endif
	d->dost = DOST_Float;
	if (SDgetrange(sdsid, (GenericPtr)&d->max, (GenericPtr)&d->min) == -1)
	  d->max.f = d->min.f = 0.;
        break;
 
    case DFNT_FLOAT64:
        {
            float32 *dest  = (float32 *) d->data;
            float64 *fdata = (float64 *) tBuf;
            for(i = 0; i < size; i++) 
                dest[i] = (float32) fdata[i];
	    d->dost = DOST_Float;
        }
	CONVFROM(float64, float32, f);
        break;

    default:
        ErrMesg("Unknown SDS data type");
        return(0); 
    }

    HDfreespace(tBuf);



    if ((d->label = (char *) HDgetspace(HDstrlen(name))) == NULL) {
        ErrMesg("Out of Memory reading HDF SDS\n");
        d->label = "Out of Memory";
        return(d);
    }
    
    HDstrcpy(d->label, name);

    SDendaccess(sdsid);
    SDend(fid);
    
     /* swap numbers because HDF puts dims in reverse order that
        this program want it in.  HDF returns them in slowest 
        order first. */
    for(i = 0; i < ( d->rank / 2 ); i++) {
        tmp = d->dim[i];
        d->dim[i] = d->dim[d->rank - i - 1];
        d->dim[d->rank - i - 1] = tmp;
    }
    
    return(d);
    
}

Data *ReadHDFRasterGroupData(fileName,tag,ref,isanim)
char *fileName;
uint16 tag;
uint16 ref;
int isanim;
{
char buff[256];
int 	hasPalette;
Data	*d;
Data	*pal;
int length;
	
	

	DFR8restart();
	DFPrestart();
	if (0 > DFR8readref(fileName,ref)) {
		sprintf(buff,"Can't set raster ref to %d in %s \n",
				ref,fileName);
		ErrMesg(buff);
		return(0);
		}
	if (0 > DFPreadref(fileName,ref)) {
		/*
		**** May not have a palette *****
		sprintf(buff,"Can't set palette ref in %s \n",fileName);
		ErrMesg(buff);
		return(0);
		*/
		}

	if (!(d = DataNew())) 
		return(0);
	d->entity = ENT_Internal;
	d->dot = DOT_Array;
	d->dost = DOST_Char;
	d->rank = 2;
	
        length = DFANgetlablen(fileName,tag,ref);
        if (length > 0) {
                if (!(d->label = (char *) MALLOC(length+1))){
                        ErrMesg("Out of Memory reading HDF RIS8\n");
                        d->label = "Out of Memory";
                        return(0);
                        }
                DFANgetlabel(fileName,tag,ref,d->label,length+1);
		}
	else if (isanim) {
		if (!(d->label = (char *) MALLOC(strlen(fileName)+1))){
			ErrMesg("Out of memory reading HDF RIG\n");
			return 0;
			}
		strcpy(d->label,fileName);
		}
	else	{
		if (!(d->label = (char *) MALLOC(strlen(fileName)+20))){
			ErrMesg("Out of memory reading HDF RIG\n");
			return 0;
			}
		sprintf(d->label,"%s_%d:%d",fileName,tag,ref);
		}

	
	if (0 > DFR8getdims(fileName,(int32 *)d->dim,(int32 *)&(d->dim[1]),&hasPalette)) {
		sprintf(buff,"Can't get raster dimensions from %s \n",fileName);
		ErrMesg(buff);
		return(0);
		}
	
	if (!(d->data = (GenericPtr) MALLOC(d->dim[0] * d->dim[1]))) {
		ErrMesg("Can't allocate memory for image\n");
		return(0);
		}
	
	if (hasPalette) {
#ifdef DEBUG
		printf("ReadHDFRasterGroup(): has palette.... attaching\n");
#endif

		if (!(pal = d->group = DataNew())) 
			return(0);
		pal->entity = ENT_Internal;
		pal->dot = DOT_Palette8;
		pal->dost = DOST_Char;
		pal->rank = 2;
		pal->dim[0]=3;
		pal->dim[1]=256;
		if (!(pal->data = (char *) MALLOC(768))) {
			ErrMesg("Can't allocate memory for image\n");
			DataDestroy(pal);
			DataDestroy(d);
			return(0);
			}
		if (!(pal->label = (char *) MALLOC(strlen(d->label)+1))){
			ErrMesg("Out of memory reading HDF RIG\n");
			return 0;
			}
		strcpy(pal->label,d->label);

		if (0 > DFR8getimage(fileName,d->data,d->dim[0],d->dim[1],
				pal->data)) {
			sprintf(buff,"Can't read raster #%d from %s \n",
				ref,fileName);
			ErrMesg(buff);
			DataDestroy(pal);
			DataDestroy(d);
			return(0);
			}
		
#ifdef DEBUG
		{ int x;
		for (x = 0; x < 768; x+=100) {
			printf("pal[%d]='%c' (%d)\n",x,
				pal->data[x],(int) pal->data[x]);
			}
		}
		
#endif
		}
	else {
#ifdef DEBUG
		printf("ReadHDFRasterGroup(): doesn't have a palette\n");
#endif

		if (0 > DFR8getimage(fileName,(uint8 *)d->data,(int32)d->dim[0],(int32)d->dim[1],(uint8 *)NULL)){
			sprintf(buff,"Can't read raster #%d from %s \n",
				ref,fileName);
			ErrMesg(buff);
			DataDestroy(d);
			return(0);
			}
		}
	
	
	
	return(d);
	
} /* ReadHDFRasterGroup() */


int ReadHDFHasPalette(name)
char *name;
/* returns number of pals hdf file has */
/* returns -1 on error */
{
        return(DFPnpals(name));
}

int ReadHDFPalette(name,ccells)
/* return 1 if ok */
/* return 0 on failure */
char    *name;
XColor  ccells[256];
{

unsigned char pal[256*3];
/* int     x;
char    buff[512]; */


        DFPrestart();
        if (DFPgetpal(name,(VOIDP)pal) == -1) {
                return(0);
                }

        ConvertToXColors(pal,ccells);

#ifdef DEBUG
        printf("Just read in HDF palette %s\n",name);
#endif
        return(1);
} /* ReadHDFPalette() */



int ReadSEQPalette(name,ccells)
/* Return NULL if could not read SEQ colormap */
char *name;
XColor ccells[256];
{
char    rbuff[256];
char    gbuff[256];
char    bbuff[256];
int     fd;             /* file descriptor */
int     x;
char    errbuff[1024];

        if ((fd = open(name,O_RDONLY,NULL)) < 0) {
                (void) sprintf(errbuff,"Can't open colormap file %s\n",name);
                ErrMesg(errbuff);
                return(NULL);
                }

        if (read(fd,rbuff,256) != 256) {
                sprintf(errbuff,"%s is not a seq colormap\n",name);
                ErrMesg(errbuff);
                return(NULL);
                }
        if (read(fd,gbuff,256) != 256) {
                sprintf(errbuff,"%s is not a seq colormap\n",name);
                ErrMesg(errbuff);
                return(NULL);
                }
        if (read(fd,bbuff,256) != 256) {
                sprintf(errbuff,"%s is not a seq colormap\n",name);
                ErrMesg(errbuff);
                return(NULL);
                }

        for (x = 0; x < 256; x++) {
                ccells[x].pixel = x;
                ccells[x].red   = (unsigned short) rbuff[x] << 8;
                ccells[x].green = (unsigned short) gbuff[x] << 8;
                ccells[x].blue  = (unsigned short) bbuff[x] << 8;
                ccells[x].flags = DoRed|DoGreen|DoBlue;
                }
#ifdef DEBUG
        printf("Just read in SEQ palette %s\n",name);
#endif

        (void) close(fd);

        return(1);

} /* ReadSEQColormap() */


WriteHDFPalette8(name,rgb)
char *name;
unsigned char *rgb;
{
char buff[1100];

	if (!DFPaddpal(name,(VOIDP)rgb))
		return(1); /* success */
	else {
		sprintf(buff,"Couldn't write hdf Palette to file %s\n",name);
		ErrMesg(buff);
		return(0);
		}
}

int LoadXWD(fileName)
char *fileName;
{
unsigned char hdfPal[768];
unsigned char *image;
int palSize;
int cols,rows;
char errBuff[1024];
Data *d;
unsigned char min,max;

	image = (unsigned char *) readxwd(fileName, hdfPal,&palSize, 
			&cols,&rows);
	if (!image) {
		sprintf(errBuff,"Couldn't extract image from xwd file %s\n",
			fileName);
		ErrMesg(errBuff);
		return(0);
		}
#ifdef DEBUG
	printf("LoadXWD(): Loaded xwd file size %d, %d\n",cols,rows);
#endif
	d = DataNew();
	if (!(d->label = (char *) MALLOC(strlen(fileName)+1))) {
		ErrMesg("Can't allocate memory for xwd image label");
		return(0);
		}
	strcpy(d->label, fileName);
	d->entity = ENT_Internal;
	d->dot = DOT_Array;
	d->dost = DOST_Char;
	d->dim[0] = cols;
	d->dim[1] = rows;
	d->rank = 2;
	d->data = image;
	SetCharMinMax(d->data,d->dim[0],d->dim[1],&min,&max);
	d->min.i = (int) min;
	d->max.i = (int) max;

	NetRISDistribute(&d,(char *) 0);
	NetPALDistribute(d->label,hdfPal,d->label,(char *) 0);
	return(1);
}

int LoadGIF(fileName)
char *fileName;
{
FILE *fp;
unsigned char *image;
int width,height;
XColor xcolors[256];
unsigned char *rgb;
Data *d;
unsigned char min,max;

	if (!(fp = fopen(fileName,"r"))) {
		}
	if (!(image = ReadGifBitmap(fp,&width,&height,xcolors))) {
		return(0);
		}
	fclose(fp);

	if (!(rgb = (unsigned char *) MALLOC(768))) {
		ErrMesg("Can't allocate memory for palette in GIF");
		return(0);
		}

	ConvertXColorsToRGB(xcolors,rgb);
	SetCharMinMax(image,width,height,&min,&max);
	if ((max - min + 1) > NCOLORS) {
#ifdef DEBUG
		printf("LoadGIF(): min,max = %d,%d. squeezing image to %d,%d\n",
			min,max,BASE_PIX,res_gotten.last_pixel);
#endif
			
		SqueezeImage(image,image,width,height,max,
				BASE_PIX,res_gotten.last_pixel,
				rgb,rgb);
		}
	else {
#ifdef DEBUG
		printf("LoadGIF(): min,max = %d,%d. shifting image to %d\n",
			min,max,BASE_PIX);
#endif
			
		ShiftImage(image,image,width,height,BASE_PIX,rgb,rgb);
		}

	d = DataNew();
	if (!(d->label = (char *) MALLOC(strlen(fileName)+1))) {
		ErrMesg("Can't allocate memory for GIF label");
		return(0);
		}
	strcpy(d->label, fileName);
	d->entity = ENT_Internal;
	d->dot = DOT_Array;
	d->dost = DOST_Char;
	d->dim[0] = width;
	d->dim[1] = height;
	d->rank = 2;
	d->data = image;
	SetCharMinMax(d->data,d->dim[0],d->dim[1],&min,&max);
	d->min.i = (int) min;
	d->max.i = (int) max;

	NetRISDistribute(&d,(char *) 0);
	NetPALDistribute(d->label,rgb,d->label,(char *) 0);
	
	return(1);

}
