/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>
#include <Xm/BulletinB.h>
#include <X11/Shell.h>
#include "view.h"
#include "viewer.h"

#define	CBAR_XDIM	50
#define CBAR_YDIM	255

#define CB_HORIZ	0
#define CB_VERT		1

static XImage *colorImage;
static unsigned char *colorBar;
static int cbxdim,cbydim;
static Widget rootColorWidget,colorBarWidget;
static GC colorBarGC;
static char colorBarShowing = FALSE;
static Visual *myVis;
static char colorBarCreated = FALSE;

extern Display *myDpy;
extern Visual *GetVisual();



/*
 * Fill a vertical colorbar with values from 0 to 255, scaled to height
 */
static void
FillVertColorBar(buff, xdim, ydim)
	unsigned char *buff;
	int xdim, ydim;
{
	register int x;
	int y;
	unsigned char yval;
	register unsigned char *p;

	if (!ydim)
	{
		return;
	}
	
	p = buff;
	for (y = 0;  y < ydim ; y++)
	{
		yval = (unsigned char)(y * 256 / ydim);
		for (x = 0 ; x < xdim ; x++)
		{
			*p++ = yval;
		}
	}
}


/*
 * Fill a horizontal colorbar with values from 0 to 255, scaled to width
 */
static void
FillHorizColorBar(buff, xdim, ydim)
	unsigned char *buff;
	int xdim, ydim;
{
	register int x;
	int y;
	unsigned char val;
	register unsigned char *p;

	if (!xdim)
	{
		return;
	}
	
	p = buff;
	for (y = 0;  y < ydim ; y++)
	{
		for (x = 0 ; x < xdim ; x++)
		{
			val = (unsigned char)(x * 256 / xdim);
			*p++ = val;
		}
	}
}


static void
CBColorBarExpose(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	XEvent event;

        while (XCheckWindowEvent(myDpy, XtWindow(colorBarWidget),
					ExposureMask, &event));
	XPutImage(myDpy, XtWindow(colorBarWidget), colorBarGC, colorImage,
			0, 0, 0, 0, cbxdim, cbydim);
}


static void
CBColorBarResize(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	XWindowAttributes winAttrib;


	XGetWindowAttributes(myDpy, XtWindow(colorBarWidget), &winAttrib);

	if ((cbxdim == winAttrib.width) && (cbydim == winAttrib.height))
	{
		return;
	}

	cbxdim = winAttrib.width;
	cbydim = winAttrib.height;

	XDestroyImage(colorImage);

	FREE(colorBar);
	if (!(colorBar = (unsigned char *) MALLOC (cbxdim*cbydim)))
	{
		ErrMesg("Out of Memory\n");
		XtDestroyWidget(rootColorWidget);
		colorBarCreated = FALSE;
		return; /* not sufficient should destroy*/
	}

	if (client_data == CB_HORIZ)
	{
		FillHorizColorBar(colorBar, cbxdim, cbydim);
	}
	else
	{
		FillVertColorBar(colorBar, cbxdim, cbydim);
	}

	colorImage =  XCreateImage(myDpy, myVis, 8, ZPixmap, 0, (char *)colorBar,
                                cbxdim, cbydim, 8, cbxdim);
	CBColorBarExpose(0, client_data, 0);
}


static Widget
MakeVertColorBar(w)
	Widget w;
{
	Cardinal i;
	Arg argList[10];
	register int y;
	XGCValues gcvalues;


	if (!(colorBar = (unsigned char *) MALLOC(CBAR_YDIM * CBAR_XDIM)))
	{
		ErrMesg("Can't allocate memory for color bar\n");
		return((Widget)0);
	}

	FillVertColorBar(colorBar, CBAR_XDIM, CBAR_YDIM);


	colorImage = XCreateImage(myDpy, myVis, 8, ZPixmap, 0, (char *)colorBar,
                                CBAR_XDIM, CBAR_YDIM, 8, CBAR_XDIM);

	i = 0;
	XtSetArg(argList[i], XmNwidth, CBAR_XDIM); i++;
	XtSetArg(argList[i], XmNheight, CBAR_YDIM); i++;
	XtSetArg(argList[i], XmNallowShellResize, True); i++;
	rootColorWidget = XtCreatePopupShell("colorbar",
				transientShellWidgetClass, w, argList, i);

	colorBarWidget = rootColorWidget;
	XtAddEventHandler(rootColorWidget, ExposureMask, 0,
				CBColorBarExpose, (caddr_t)CB_VERT);
	XtAddEventHandler(rootColorWidget, SubstructureNotifyMask, 0,
				CBColorBarResize, (caddr_t)CB_VERT);

	cbxdim = CBAR_XDIM;
	cbydim = CBAR_YDIM;

	colorBarGC = XtGetGC(colorBarWidget, 0, &gcvalues);
	colorBarCreated = TRUE;
	return(rootColorWidget);
}


static Widget
MakeHorizColorBar(w, width, height)
	Widget w;
	unsigned int width, height;
{
	Cardinal i;
	Arg argList[10];
	register int y;
	XGCValues gcvalues;


	if (!(colorBar = (unsigned char *) MALLOC(width * height)))
	{
		ErrMesg("Can't allocate memory for color bar\n");
		return((Widget)0);
	}

	FillHorizColorBar(colorBar, width, height);


	colorImage = XCreateImage(myDpy, myVis, 8, ZPixmap, 0, (char *)colorBar,
                                width, height, 8, width);

	i = 0;
	XtSetArg(argList[i], XmNwidth, width); i++;
	XtSetArg(argList[i], XmNheight, height); i++;
	rootColorWidget = XmCreateDrawingArea(w, "colorbar", argList, i);

	colorBarWidget = rootColorWidget;
	XtAddEventHandler(rootColorWidget, ExposureMask, 0,
				CBColorBarExpose, (caddr_t)CB_HORIZ);
	XtAddEventHandler(XtParent(rootColorWidget), SubstructureNotifyMask, 0,
				CBColorBarResize, (caddr_t)CB_HORIZ);

	cbxdim = width;
	cbydim = height;

	colorBarGC = XtGetGC(colorBarWidget, 0, &gcvalues);
	colorBarCreated = TRUE;
	return(rootColorWidget);
}


Widget
InitColorBar(parent, w, h)
	Widget parent;
	unsigned int w, h;
{
	Widget cb;

	myVis = GetVisual(myDpy);

	cb = MakeHorizColorBar(parent, w, h);

	return(cb);
}

