/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: animUI.c,v 1.12 1993/09/08 19:44:26 gbourhis Exp $";
#endif

/* $Log: animUI.c,v $
 * Revision 1.12  1993/09/08  19:44:26  gbourhis
 * X Error handler return type is int (for AnimateError()).
 * An error handler must not generate protocol request (=> remove ErrMesg()).
 *
 * Revision 1.11  1993/09/03  19:43:45  davet
 * Added checking for X server memory filling up on server memory
 * animations.  Hard to test this code since mose X servers die before
 * they can report the bad allocation error to the client.
 *
 * Revision 1.10  1993/09/02  22:14:16  davet
 * Through the HDF browser allows selection of multiple tags
 * that refer to the same raster.  The animation code would
 * load up the same raster multiple times.  This is fixed.
 * Code for sync up with collaborators when done loading was
 * commented out.  uncommented this code.
 *
 * Revision 1.9  1993/08/04  19:46:29  gbourhis
 * Directly destroy the shell widget.
 *
 * Revision 1.8  1993/07/30  15:09:07  gbourhis
 * Add DOST_Int16 support. Create a submenu for the Play Mode.
 *
 * Revision 1.7  1993/06/24  20:53:40  gbourhis
 * include "collageP.h"
 *
 * Revision 1.6  1993/06/17  21:09:09  davet
 * When animation was running, if user clicked close on the window,
 * collage would free the pixmaps but the animation would continue running.
 * Now CBAnimationDone() stops the animation before freeing.
 *
 * Revision 1.5  1993/05/12  15:47:55  gbourhis
 * Use object-oriented paradigm to implement animation from memory and
 * from disk.
 *
 * Revision 1.4  1993/05/05  20:37:36  gbourhis
 * Several mods: use XCopyArea instead of XSetWindowBackgroundPixmap,
 * integer data supported in AnimMakePixmapListFrom{2,3}D.
 * Dialog added to prompt for magnification.
 * Slider to control speed of animation added.
 * redesign internal of module.
 *
 *
 * mods:
 * 2/22/93 ddt added show frame number 
 * 2/22/93 ddt AnimLoadNewAnimation(): would generate an animation window
 *		if user selected on an unanimatable data (palette)... fixed.
*/

#include <stdio.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/BulletinB.h>
#include <Xm/DrawingA.h>
#include <Xm/ScrollBar.h>
#include <Xm/Scale.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleB.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/FileSB.h>
#include <Xm/Separator.h>
#include <Xm/SelectioB.h>


#ifdef HDF32
#include <hdf/hdf.h>
#else
#include "hdf/df.h"
#endif

#include "hb/hbox.h"

#include "collageP.h"
#include "list.h"
#include "net.h"
#include "animUI.h"
#include "support.h"

#include "fstep.h"
#include "fwd.h"
#include "pause.h"
#include "rstep.h"
#include "rev.h"

#define cpccell(a,b)    {\
                        a.red = b.red; \
                        a.green = b.green; \
                        a.blue = b.blue; \
                        a.flags = b.flags; \
                        }

typedef struct {
	char *title;
	XmString motifName;
	XColor ccells[256];
	} AnimPal;

typedef struct {
	Animation *anim;
	AnimPal *pal;
	} AnimPalGroup;


#ifndef MALLOC
#define MALLOC	malloc
#define FREE	free
#endif

extern	Visual *GetVisual();
extern	Data *ReadHDFObject();

static	Display	*myDpy;
static	Visual	*myVis;
static	Screen 	*myScreen;
static	Widget 	rootWidget;
static	List	animList;
static	List	palList;
static	Pixmap  fwdPixmap;
static	Pixmap  revPixmap;
static	Pixmap  pausePixmap;
static	Pixmap  fstepPixmap;
static	Pixmap  rstepPixmap;
static	char	pixmapCreated=FALSE;
static	int	saveEntries[256];
static	int	numToSave;
static  XColor	defaultCCells[256];
/* static	AnimPal defaultPal; */
static	XtAppContext myAppContext;
static	Boolean	animLock=FALSE;
static  Animation *currentAnimation= (Animation *) 0;/*loading into memory now*/

static void CBAnimationExpose();

#define SliderSize(anim) ((anim->width >= anim->numFrames) ? \
			  anim->width/anim->numFrames : 1)

static int AnimateError(dpy,myErr)
Display *dpy;
XErrorEvent *myErr;
{
char buff[1024];
Pixmap p;

#ifdef DEBUG
        fprintf(stderr,"XErrorHandler:\n");
        XGetErrorText(dpy,myErr->error_code,buff,1024);
        fprintf(stderr,"\n******X server out of memory:%s\n",buff);
        fprintf(stderr,"resource id: %d\n",myErr->resourceid);
#endif
	if (!currentAnimation) {
		return;
		}
	if (currentAnimation) {
        	currentAnimation->badAllocError=True;
		p = (Pixmap)ListTail(currentAnimation->pixmapList);
		XFreePixmap(myDpy,p);
		currentAnimation->numFrames--;
		}

	fprintf(stderr,"The X Server is out of memory for Animation\n");
}


AnimLock(lock)
Boolean lock;
{
Animation *anim;
int x;

	animLock = lock;
	anim = (Animation *) ListHead(animList);
	while (anim) {
		for (x=0; x < 5; x++ ) {
			XtSetSensitive(anim->button[x],!lock);
			}
		XtSetSensitive(anim->slider,!lock);
		anim = (Animation *) ListNext(animList);
		}
}


static void
FreePixmap(anim)
Animation *anim;
{
Pixmap pix;
#ifdef DEBUG
	printf("Freeing Pixmaps...\n");
#endif
	for(pix = (Pixmap) ListHead(anim->pixmapList);
	    pix;
	    pix = (Pixmap) ListNext(anim->pixmapList))
		XFreePixmap(myDpy,pix);
}

static void
FreeImagesData(anim)	
Animation *anim;
{
char *image;
	for (image = ListHead(anim->dataList);
	     image;
	     image = ListNext(anim->dataList))
		FREE(image);
}

static void
FreeDiskData(anim)	
Animation *anim;
{
	fclose(anim->file_pointer);
	FREE(anim->image_buff);
}

static void
CBAnimationDone(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Animation *anim;

	anim = (Animation *) client_data;
	XtPopdown(anim->top);
	anim->runStatus = A_PAUSE;
	anim->methods->destroy_frames(anim);
	XtDestroyWidget(anim->top);
	ListDeleteEntry(animList,anim);
}


static int
GetForeground(w)
Widget w;
{
static Arg argList[] = {
  { XmNforeground, (XtArgVal)0 },
};
Pixel val;
        argList[0].value = (XtArgVal)&val;
        XtGetValues(w, argList, (Cardinal)1);
        return(val);
}

static int
GetBackground(w)
Widget w;
{
static Arg argList[] = {
  { XmNbackground, (XtArgVal)0 },
};
Pixel val;
        argList[0].value =  (XtArgVal)&val;
        XtGetValues(w, argList, (Cardinal)1);
        return(val);
}


static int
AnimGetFrameNumFromSliderPos(anim,sliderPos)
Animation *anim;
int sliderPos;
{
int frameNumber;
Arg argList[10];

        XtSetArg(argList[0], XmNwidth, &(anim->width)); 
        XtGetValues(anim->slider, argList, 1);

	if (sliderPos)
		frameNumber=(int)((((float)sliderPos)*((float)anim->numFrames)) 
				/ ((float)anim->width));
	else
		frameNumber = 1;
#ifdef DEBUG
	printf("sliderPos = %d, numFrames = %d, width = %d, frameNumber = %d\n",
		sliderPos,anim->numFrames,anim->width,frameNumber);
#endif

	return(frameNumber);
}

static int
AnimSetSliderPosFromFrameNum(anim,frameNumber)
Animation *anim;
int frameNumber;
{
int sliderPos;

	if (!frameNumber)
		return(0);
	sliderPos = (int) ((((float)anim->width) * ((float)frameNumber)) 
			/ ((float)anim->numFrames));
#ifdef DEBUG
	printf("sliderPos = %d, numFrames = %d, width = %d, frameNum = %d\n",
		sliderPos,anim->numFrames,anim->width,frameNumber);
#endif
	return(sliderPos);
}

static void
AnimStoreColors(useAllEntries,ccells,cmap)
Boolean useAllEntries;
XColor *ccells;
Colormap cmap;
{
register int x;
static XColor sccells[256];


        if (!cmap)
                return;
        if (!useAllEntries) {
                for(x=0;x < 256; x++) {
                        sccells[x].pixel = x;
                        cpccell(sccells[x],ccells[x]);
                        }
                /* retstore Motif colors */
                for (x =0; x< numToSave; x++) {
                        cpccell(sccells[saveEntries[x]],
                                defaultCCells[saveEntries[x]]);
                        }
                XStoreColors(myDpy,cmap,sccells,256);
                }
        else
                XStoreColors(myDpy,cmap,ccells,256);
        return;
}

static void
CBAnimShowFrameNumber(w,client_data,call_data)
Widget w;
caddr_t client_data;
XmToggleButtonCallbackStruct *call_data;
{
Animation *anim = (Animation *) client_data;

        anim->showFrameNumber = call_data->set;
	CBAnimationExpose(w,client_data,0);
}


static void
CBAnimUseEntirePalette(w,client_data,call_data)
Widget w;
caddr_t client_data;
XmToggleButtonCallbackStruct *call_data;
{
Animation *anim = (Animation *) client_data;

        anim->useAllEntries = call_data->set;
        AnimStoreColors(anim->useAllEntries,anim->ccells,anim->cmap);
}

static void
CBAnimDisplayNewPalette(w,client_data,call_data)
Widget w;
caddr_t client_data;
XmToggleButtonCallbackStruct *call_data;
{
Animation *anim = (Animation *) client_data;

        anim->displayNewPalette = call_data->set;
}




static void
CBAnimSingleRun(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Animation *anim = (Animation *) client_data;

#ifdef DEBUG
	printf("CBAnimSingleRun(): I've been called\n");
#endif
	anim->runType = ART_SINGLE;
}

static void
CBAnimContWrap(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Animation *anim = (Animation *) client_data;

#ifdef DEBUG
	printf("CBAnimContWrap(): I've been called\n");
#endif
	anim->runType = ART_CONT;
}


static void
CBAnimContBounce(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Animation *anim = (Animation *) client_data;

#ifdef DEBUG
	printf("CBAnimContBounce(): I've been called\n");
#endif
	anim->runType = ART_BOUNCE;
}



static Pixmap
AnimGetPixmapByFrameNumber(list,n)
List list;
int n;
{
Pixmap pix;
int count;

	pix = (Pixmap) ListHead(list);
	for (count = 0; pix && (count != n); count++)
		pix = (Pixmap) ListNext(list);

	return(pix);
	
}


static void
DisplayFrameNumber(anim)
Animation *anim;
{
	if (anim->showFrameNumber) {
		char frameNumber[20];
		sprintf(frameNumber,"%d",anim->curFrame);
		XSetFunction(myDpy,anim->animWindowGC,GXxor);
		XSetForeground(myDpy,anim->animWindowGC,255);
		XDrawString(myDpy,XtWindow(anim->animWindow),
				anim->animWindowGC,
				5,anim->frame_dimY-5,
				frameNumber,strlen(frameNumber));
		XSetFunction(myDpy,anim->animWindowGC,GXcopy);
		}
}

static void
DisplayImageFromMemory(anim)
Animation *anim;
{
char *image;
int i;

	image = ListHead(anim->dataList);
	for (i=0; image && i != anim->curFrame; i++)
		image = ListNext(anim->dataList);
	if (image) {
		anim->ximage->data = (char *) image;
		XPutImage(myDpy, XtWindow(anim->animWindow),anim->animWindowGC,
			  anim->ximage,	0,0,0,0,anim->frame_dimX,
			  anim->frame_dimY);
		}
	DisplayFrameNumber(anim);
}
static void
DisplayFrameFromDisk(anim)
Animation *anim;
{
	if (!fseek(anim->file_pointer,
		   (long)(anim->frame_dimX*anim->frame_dimY*anim->curFrame),
		   SEEK_SET) &&
	    fread(anim->image_buff, anim->frame_dimX, anim->frame_dimY,
		  anim->file_pointer) == anim->frame_dimY)
		XPutImage(myDpy, XtWindow(anim->animWindow),anim->animWindowGC,
			  anim->ximage,	0,0,0,0,anim->frame_dimX,
			  anim->frame_dimY);
	DisplayFrameNumber(anim);
}

static void
DisplayPixmap(anim)
Animation *anim;
{
Pixmap pix;
char frameNumber[20];

	pix = AnimGetPixmapByFrameNumber(anim->pixmapList, anim->curFrame);
	if (pix)
		XCopyArea(myDpy,pix,XtWindow(anim->animWindow),
			  anim->animWindowGC,0,0,anim->frame_dimX,
			  anim->frame_dimY,0,0);

	DisplayFrameNumber(anim);
}

static void
CBAnimForwardStep(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Animation *anim = (Animation *) client_data;

#ifdef DEBUG
	printf("CBAnimForwardStep(): I've been called\n");
#endif
	anim->curFrame++;
	if (anim->curFrame >= anim->numFrames) {
		if (anim->runStatus == A_PAUSE) {
			anim->curFrame = 0;
			}
		else {
			switch(anim->runType) {
		    	    case ART_BOUNCE: 
#ifdef DEBUG
				printf("CBAnimForwardStep, ART_BOUNCE0\n");
#endif

				if (anim->runStatus != A_PAUSE)
					anim->runStatus = A_REVERSE;
				anim->curFrame--;
				break;
		    	    case ART_CONT:
#ifdef DEBUG
				printf("CBAnimForwardStep, ART_CONT\n");
#endif
				anim->curFrame = 0;
				break;
		    	    case ART_SINGLE:
#ifdef DEBUG
				printf("CBAnimForwardStep, ART_SINGLE\n");
#endif
				anim->runStatus = A_PAUSE;
				anim->curFrame--;
				break;
		    	    };
			}
		}

	if (anim->curFrame < anim->numFrames)
		anim->methods->display_frame(anim);

#ifdef DEBUG
        printf("XmScrollBarSetValues(%x, %d,%d,%d,%d,%d);\n",
                anim->slider,
                AnimSetSliderPosFromFrameNum(anim,anim->curFrame),
                (anim->width/anim->numFrames), 1, 0,False);
#endif
        XmScrollBarSetValues(anim->slider,
                AnimSetSliderPosFromFrameNum(anim,anim->curFrame),
                SliderSize(anim), 1, 0,False);

	if (anim->runStatus == A_PAUSE && w == anim->button[3]) {
		NetSendAnimationCommand(0,anim->title,AF_STOP,ART_NONE,
					anim->curFrame);
		}

} /* CBAnimForwardStep() */


static void
CBAnimReverseStep(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Animation *anim = (Animation *) client_data;

#ifdef DEBUG
	printf("CBAnimReverseStep(): I've been called\n");
#endif 
	anim->curFrame--;
	if (anim->curFrame < 0) {
		if (anim->runStatus == A_PAUSE) {
			anim->curFrame = anim->numFrames-1;
			}
		else {
			switch(anim->runType) {
			    case ART_BOUNCE: 
				if (anim->runStatus != A_PAUSE)
					anim->runStatus = A_FORWARD;
				anim->curFrame = 0;
				break;
			    case ART_CONT:
				anim->curFrame = anim->numFrames-1;
				break;
			    case ART_SINGLE:
				anim->runStatus = A_PAUSE;
				anim->curFrame = 0;
				break;
		    	    };
			}
		}
	if (anim->curFrame < 0)
		anim->curFrame = 0;
	if (anim->curFrame < anim->numFrames)
		anim->methods->display_frame(anim);

#ifdef DEBUG
        printf("XmScrollBarSetValues(%x, %d,%d,%d,%d,%d);\n",
                anim->slider,
                AnimSetSliderPosFromFrameNum(anim,anim->curFrame),
                (anim->width/anim->numFrames), 1, 0,False);
#endif
        XmScrollBarSetValues(anim->slider,
                AnimSetSliderPosFromFrameNum(anim,anim->curFrame),
                SliderSize(anim), 1, 0,False);

	if (anim->runStatus == A_PAUSE && w == anim->button[1]) {
		NetSendAnimationCommand(0,anim->title,AF_STOP, ART_NONE,
					anim->curFrame);
		}

} /* CBAnimReverseStep() */


static void
CBAnimPause(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Animation *anim = (Animation *) client_data;

#ifdef DEBUG
	printf("CBAnimPause(): I've been called\n");
#endif 

	if (anim->interv_id)
	  {
		XtRemoveTimeOut(anim->interv_id);
		anim->interv_id = (XtIntervalId)0;
	  }
	anim->runStatus = A_PAUSE;

	NetSendAnimationCommand(0,anim->title,AF_STOP, ART_NONE,
					anim->curFrame);
}


static void
CBNextFrame(client_data,id)
caddr_t client_data;
XtIntervalId *id;
{
Animation *anim;
int anim_speed;


	anim = (Animation *) client_data;
	if (id == (XtIntervalId *)0 && anim->interv_id)
		XtRemoveTimeOut(anim->interv_id);
	anim->interv_id = (XtIntervalId)0;
	if (anim->runStatus == A_PAUSE) {
#ifdef DEBUG
	printf("CBNextFrame():  paused... returning\n");
#endif
		return;
		}
	else if (id)		/* called after a time out */
		XSync(myDpy,False);

	if (anim->runStatus == A_FORWARD) {
		CBAnimForwardStep(anim->button[4],anim,0);
		}
	else {
		CBAnimReverseStep(anim->button[0],anim,0);
		}
	if (anim->runStatus != A_PAUSE) {
		XmScaleGetValue(anim->button[5], &anim_speed);
		anim->interv_id =
		  XtAppAddTimeOut(myAppContext,(unsigned long)anim_speed,
				  CBNextFrame,client_data);
		}
#ifdef DEBUG
	else
		printf("CBNextFrame(): I'm paused \n");
#endif

} /* CBNextFrame() */


static void
CBsliderSetValue(w,client_data,sb)
Widget w;
caddr_t client_data;
XmScrollBarCallbackStruct *sb;
{
Animation *anim = (Animation *) client_data;

	if ((sb->value < 0) || (sb->value > anim->width))
		return;
	anim->curFrame = AnimGetFrameNumFromSliderPos(anim,sb->value);
	anim->methods->display_frame(anim);
	NetSendAnimationCommand(0,anim->title,AF_STOP, ART_NONE,
				anim->curFrame);
        anim->runStatus = A_PAUSE;

}


static void
CBAnimForward(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Animation *anim = (Animation *) client_data;

#ifdef DEBUG
	printf("CBAnimForward(): I've been called\n");
#endif 
	anim->runStatus = A_FORWARD;
	NetSendAnimationCommand(0,anim->title,AF_FPLAY,anim->runType,
				anim->curFrame);
	CBNextFrame(anim,(XtIntervalId *)0);
}

static void
CBAnimReverse(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Animation *anim = (Animation *) client_data;

#ifdef DEBUG
	printf("CBAnimReverse(): I've been called\n");
#endif 
	anim->runStatus = A_REVERSE;
	NetSendAnimationCommand(0,anim->title,AF_RPLAY,anim->runType,
				anim->curFrame);
	CBNextFrame(anim,(XtIntervalId *)0);
}

static void
CBAnimationExpose(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Animation *anim = (Animation *) client_data;
Arg	argList[4];

        XtSetArg(argList[0], XmNwidth, &(anim->width));
        XtGetValues(anim->slider, argList, 1);
	XtSetArg(argList[0],XmNmaximum, anim->width );
	XtSetValues(anim->slider, argList, (Cardinal)1);

	anim->methods->display_frame(anim);

        XmScrollBarSetValues(anim->slider,
                AnimSetSliderPosFromFrameNum(anim,anim->curFrame),
                SliderSize(anim), 1, 0,False);
#ifdef DEBUG
	printf("slider width is %d\n",anim->width);
#endif
}

static void
MakeInMemory(anim,xdim,ydim,image,expandX,expandY)
Animation *anim;
int xdim;
int ydim;
unsigned char *image;
float expandX,expandY;
{
int width,height;
unsigned char *newImage;

	width = xdim;
	height = ydim;
	if ((expandX != 1.0) || (expandY != 1.0)) {
		width = (int) (((float) xdim) * expandX);
		height = (int) (((float) ydim) * expandY);
		if (!(newImage = (unsigned char *) MALLOC(width*height))) {
			ErrMesg("Out of Memory on Animation expansion");
			return;
			}
		magnify(image,newImage,0,0,xdim-1,ydim-1,xdim,ydim,
				width,height);
		}
	else	{
		if (!(newImage = (unsigned char *) MALLOC(width*height))) {
			ErrMesg("Out of Memory on Animation expansion");
			return;
			}
		memcpy(newImage, image, width*height);
		}
	ListAddEntry(anim->dataList, newImage);
	anim->ximage->data = (char *) newImage;
	XPutImage(myDpy, XtWindow(anim->animWindow),anim->animWindowGC,
		  anim->ximage,	0,0,0,0,width,height);
	anim->curFrame = anim->numFrames;
	anim->numFrames++;

	anim->frame_dimX = width;
	anim->frame_dimY = height;
}
		
static FILE *
OpenTmp()
{
	static char filename[512];
	FILE *fpo;
	strcpy(filename, res_gotten.tmp_dir);
	if (filename[strlen(filename)-1] != '/')
		strcat(filename, "/");
	strcat(filename, cuserid(NULL));
#ifdef DEBUG
	fprintf(stderr, "filename = \"%s\"\n", filename);
#endif
	fpo = fopen(filename, "w+");
	unlink(filename);
	return fpo;
}

static void
MakeInDisk(anim,xdim,ydim,image,expandX,expandY)
Animation *anim;
int xdim;
int ydim;
unsigned char *image;
float expandX,expandY;
{
	if (!anim->numFrames) {	/* first frame */
		anim->file_pointer = OpenTmp();	/* with unlink */
		anim->frame_dimX = xdim*(int)expandX;
		anim->frame_dimY = xdim*(int)expandY;
		anim->image_buff = (unsigned char *)
			MALLOC(anim->frame_dimX*anim->frame_dimY);
		if (anim->image_buff == NULL) {
			fprintf(stderr, "Out of Memory\n");
			return;
			}
		}
	else
		fseek(anim->file_pointer, (long)
		      (anim->frame_dimX*anim->frame_dimY*anim->numFrames),
		      SEEK_SET);
	anim->curFrame = anim->numFrames;
	anim->numFrames++;
	if ((expandX != 1.0) || (expandY != 1.0)) {
		int width,height;
		unsigned char *newImage;
		width = (int) (((float) xdim) * expandX);
		height = (int) (((float) ydim) * expandY);
		if (!(newImage = (unsigned char *) MALLOC(width*height))) {
			ErrMesg("Out of Memory on Animation expansion");
			return;
			}
		magnify(image,newImage,0,0,xdim-1,ydim-1,xdim,ydim,
				width,height);
		anim->ximage->data = (char *)newImage;
		XPutImage(myDpy, XtWindow(anim->animWindow),anim->animWindowGC,
			  anim->ximage,	0,0,0,0,width,height);
		FREE(newImage);
		fwrite(newImage, width, height, anim->file_pointer);
		}
	else {
		anim->ximage->data = (char *)image;
		XPutImage(myDpy, XtWindow(anim->animWindow),anim->animWindowGC,
			  anim->ximage,	0,0,0,0,xdim,ydim);
		fwrite(image, xdim, ydim, anim->file_pointer);
		}
	anim->ximage->data = (char *)anim->image_buff;
	return;
}

static void
AnimMakePixmap(anim,xdim,ydim,image,expandX,expandY)
Animation *anim;
int xdim;
int ydim;
unsigned char *image;
float expandX,expandY;
{
Pixmap pix;
Window win;
int width,height;
unsigned char *newImage;
int	freeNewImage;

#ifdef DEBUG
	printf("AnimMakePixmap(%x,%d,%d,%x) \n",anim,xdim,ydim,image);
#endif

	if (anim->badAllocError) {
#ifdef DEBUG
		printf("Out of memory server memory for animation\n");
#endif
		return;
		}
	currentAnimation = anim;
        XSynchronize(myDpy,True);
	win = XtWindow(anim->animWindow);
	freeNewImage = FALSE;
	newImage = image;
	width = xdim;
	height = ydim;
	if ((expandX != 1.0) || (expandY != 1.0)) {
		width = (int) (((float) xdim) * expandX);
		height = (int) (((float) ydim) * expandY);
		if (!(newImage = (unsigned char *) MALLOC(width*height))) {
			ErrMesg("Out of Memory on Animation expansion");
        		XSynchronize(myDpy,False);
			return;
			}
		freeNewImage = TRUE;
#ifdef DEBUG
		printf("xdim=%d,ydim=%d,width = %d, height = %d\n",
		       xdim,ydim,width,height);
#endif
		magnify(image,newImage,0,0,xdim-1,ydim-1,xdim,ydim,
				width,height);
		}
	if (anim->badAllocError) {
        	XSynchronize(myDpy,False);
		return;
		}

/*
	pix=XCreatePixmap(myDpy,win, xdim,ydim, DisplayPlanes(myDpy,myScreen));
*/
	pix = XCreatePixmap(myDpy,win, width,height, 8);
	anim->ximage->width = width;
	anim->ximage->bytes_per_line = width;
	anim->ximage->height = height;
	anim->ximage->data = (char *) newImage;
	if (anim->badAllocError) {
        	XSynchronize(myDpy,False);
		return;
		}
	XPutImage(myDpy,pix,anim->animWindowGC,anim->ximage,
				0,0,0,0,width,height);
	if (anim->badAllocError) {
        	XSynchronize(myDpy,False);
		return;
		}
	ListAddEntry(anim->pixmapList,pix);
	anim->curFrame = anim->numFrames;
	anim->numFrames++;

	anim->frame_dimX = width;
	anim->frame_dimY = height;
	XCopyArea(myDpy,pix,win,anim->animWindowGC,0,0,anim->frame_dimX,
		  anim->frame_dimY,0,0);

	if (freeNewImage) {
		FREE(newImage);
		}
#ifdef DEBUG
	printf("Just Created a Pixmap\n");
#endif
       	XSynchronize(myDpy,False);
}

static int
AnimMakeFrameListFrom2D(anim,data)
Animation *anim;
Data *data;
{
float min,max;
int inmin, inmax;
unsigned char *p;
int frameSize;
#ifdef DEBUG
	printf("AnimMakeFrameListFrom2D():I've been called\n");
#endif
	frameSize = data->dim[0] * data->dim[1];
	if (data->dost == DOST_Float||data->dost == DOST_Int32 ||
	    data->dost == DOST_Int16) {
		if (!(p = (unsigned char *) MALLOC(frameSize))) {
			ErrMesg("Out of Memory loading animation\n");
			return(0);
			}
		/**** What to do?... min max may change between each frame*/
		if (data->dost == DOST_Float) {
		  if (data->min.f == data->max.f)
			SetMinMax(data->data,data->dim[0],data->dim[1],&min,
				  &max);
		  else		/* no more change ? */
			min = data->min.f, max = data->max.f;
		  CreateRasterFromFloat(data->data,&p,data->dim[0],
					data->dim[1],min,max,FALSE);
		  }
		else {		/* DOST_(Int32||Int16) */
		  if (data->min.i == data->max.i)
			if (data->dost == DOST_Int32)
				SetIntMinMax(data->data, data->dim[0],
					     data->dim[1], &inmin, &inmax);
			else	/* DOST_Int16 */
				SetShortMinMax((short *)data->data,
					       data->dim[0], data->dim[1],
					       &inmin, &inmax);
		  else
			inmin = data->min.i, inmax = data->max.i;
		  if (data->dost == DOST_Int32)
			CreateRasterFromInt(data->data,&p,data->dim[0],
					    data->dim[1],inmin,inmax,FALSE);
		  else		/* DOST_Int16 */
			CreateRasterFromShort((short *)data->data,&p,
					      data->dim[0],data->dim[1],
					      inmin,inmax,FALSE);
		  }
		anim->methods->make_frame(anim,data->dim[0],data->dim[1], p,
					  data->expandX,data->expandY);
#ifdef DEBUG
			printf("Just finished making %d frame\n",
					anim->numFrames);
#endif
		FREE(p);
		}
	else if (data->dost == DOST_Char) {
		anim->methods->make_frame(anim,data->dim[0],data->dim[1],
					  data->data,
					  data->expandX,data->expandY);
		}
	else
		return 0;

	return 1;

}



static int
AnimMakeFrameListFrom3D(anim,data)
Animation *anim;
Data *data;
{
int t;
int frameSize;
float *fp;
unsigned char *p;
IntOrFloat min,max;
Arg argList[10];


#ifdef DEBUG
	printf("AnimMakeFrameListFrom3D():I've been called\n");
#endif
	frameSize = data->dim[0] * data->dim[1];
	if (data->dost == DOST_Float || data->dost == DOST_Int32 ||
	    data->dost == DOST_Int16) {
		if (!(p = (unsigned char *) MALLOC(frameSize))) {
			ErrMesg("Out of Memory loading animation\n");
			return(0);
			}

		fp = (float *) data->data;
		if (data->dost == DOST_Float)
			if (data->min.f == data->max.f)
				SetMinMax(fp,frameSize,
					  data->dim[2],&min.f,&max.f);
			else	/* use min & max from HDF file */
				min = data->min, max = data->max;
		else if (data->dost == DOST_Int32)
			if (data->min.i == data->max.i)
				SetIntMinMax(fp,frameSize,
					  data->dim[2],&min.i,&max.i);
			else	/* use min & max from HDF file */
				min = data->min, max = data->max;
		else		/* DOST_Int16 */
			if (data->min.i == data->max.i)
				SetShortMinMax((short *)fp,frameSize,
					       data->dim[2],&min.i,&max.i);
			else	/* use min & max from HDF file */
				min = data->min, max = data->max;

		for (t = 0; t < data->dim[2]; t++)  {
			if (data->dost == DOST_Float)
				CreateRasterFromFloat
					(fp+t*frameSize, &p, data->dim[0],
					 data->dim[1], min.f,max.f,FALSE);
			else if (data->dost == DOST_Int32)
				CreateRasterFromInt
					(((int *)fp)+t*frameSize, &p,
					 data->dim[0], data->dim[1],
					 min.i,max.i,FALSE);
			else
				CreateRasterFromShort
					(((short *)fp)+t*frameSize, &p,
					 data->dim[0], data->dim[1],
					 min.i,max.i,FALSE);
			anim->methods->make_frame
				(anim,data->dim[0],data->dim[1], p,
				 data->expandX,data->expandY);
#ifdef DEBUG
			printf("Just finished making %d frame\n",
					anim->numFrames);
#endif
			}
		FREE(p);
		}
	else if (data->dost == DOST_Char) {
		p = (unsigned char *) data->data;
		for (t = 0; t < data->dim[2]; t++) {
			anim->methods->make_frame
				(anim,data->dim[0],data->dim[1], p,
				 data->expandX,data->expandY);
#ifdef DEBUG
			printf("Just finished making %d frame\n",
					anim->numFrames);
#endif
			p += frameSize;
			}
		}
	else {
		ErrMesg("Can only handle 3d data of type float, int32 & char\n");
		return(0);
		}

        XtSetArg(argList[0], XmNwidth, &(anim->width)); 
        XtGetValues(anim->slider, argList, 1);

#ifdef DEBUG
	printf("XmScrollBarSetValues(%x, %d,%d,%d,%d,%d);\n",
		anim->slider,
		AnimSetSliderPosFromFrameNum(anim,anim->curFrame),
		(anim->width/anim->numFrames), 1, 0,False);
#endif
/*	XmScrollBarSetValues(anim->slider,
		AnimSetSliderPosFromFrameNum(anim,anim->curFrame),
		SliderSize(anim), 1, 0,False);*/


	return(1);

} /* AnimMakeFrameListFrom3D() */

/*
static int AnimLoadAllFromSingleFile(fileName,anim)
char *fileName;
Animation *anim;
{
int num;
unsigned char *raster;
char buff[1024];
Data data;
int xdim,ydim;
int hasPalette;
int x;

	num = ReadNumberOfRasterImages(fileName);
	if (num < 1) {
		sprintf(buff,"File %s doesn't contain any animation images\n",
			fileName);
		ErrMesg(buff);
		return(0);
		}
	if (!ReadDimsOfRasterImage(fileName,&xdim,&ydim,&hasPalette)) {
		sprintf(buff,"Couldn't get dimensions of image in file %s\n",
			fileName);
		ErrMesg(buff);
		return(0);
		}
	data.label = fileName;
	data.entity = ENT_File;
	data.dot = DOT_Array;
	data.dost = DOST_Char;
	data.dim[0] = xdim;
	data.dim[1] = ydim;
	data.rank = 2;
	if (!(data.data = (char *) MALLOC(xdim * ydim))) {
		sprintf(buff,"Out of Memory reading image from file %s\n",
			fileName);
		ErrMesg(buff);
		return(0);
		}
	for (x = 0; x < num; x++) {
		if (ReadRIS8FromAnimation(fileName,data.data,xdim,ydim,x)) {
			AnimMakeFrameListFrom2D(anim,data);
			}
		}
	FREE(data.data);
	return(1);
}
*/

static void
CBAnimSetPal(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
AnimPalGroup *apg;
register int x;

	apg = (AnimPalGroup *) client_data;
	for (x = 0 ;x < 256; x++) {
		apg->anim->ccells[x].pixel = x;
		cpccell(apg->anim->ccells[x],apg->pal->ccells[x]);
		}
	AnimStoreColors(apg->anim->useAllEntries,apg->anim->ccells,
			apg->anim->cmap);

} /* CBAnimSetPal() */

static void
AnimRegisterPalsInPulldown(anim)
Animation *anim;
/* Stick all the loaded palettes in the animation View->Palette pulldown */
{
AnimPal *pal;
AnimPalGroup *apg;
Widget b;
Arg argList[10];

	pal = (AnimPal *) ListHead(palList);
	while (pal) {
		if (!(apg = (AnimPalGroup *) MALLOC(sizeof(AnimPalGroup)))) {
		  ErrMesg("Out of Memory receiving new animation palette\n");
		  return;
		}

		apg->anim = anim;
		apg->pal = pal;
        	XtSetArg(argList[0],XmNlabelString,pal->motifName);
		b = XmCreatePushButtonGadget(anim->pulldown[2],
					"menuButton",argList,1);
		XtAddCallback(b,XmNactivateCallback,CBAnimSetPal,(caddr_t)apg);
		XtManageChild(b);

		pal = (AnimPal *) ListNext(palList);
		}
} /* AnimRegisterPalsInPulldown() */

static Boolean AnimIsRasterTag(tag)
int tag;
{
	if ((tag == DFTAG_ID8) 
		||( tag == DFTAG_RI8)
                || (tag == DFTAG_II8)
                || (tag == DFTAG_ID)
                || (tag == DFTAG_RI)
                || (tag == DFTAG_CI)
                || (tag == DFTAG_RIG)
                || (tag == DFTAG_MD)
                || (tag == DFTAG_MA)
                || (tag == DFTAG_CCN)
                || (tag == DFTAG_CFM)
                || (tag == DFTAG_AR)) {
		return(True);
		}
	else {
		return(False);
		}
}

static void
FinishReading(anim)
     Animation *anim;
{
	Data *d;
	int x;
	int lastTag = 0;
	int lastRef = 0;

	if (anim->delayedRead) {
		for (x = 0 ; x < anim->numTagRefs; x++ ) {
		    if (!((lastRef == anim->tagRefs[x].ref) &&
				AnimIsRasterTag(lastTag) &&
				AnimIsRasterTag(anim->tagRefs[x].tag))) {
			d = ReadHDFObject(anim->fileName,
					  anim->tagRefs[x].tag,
					  anim->tagRefs[x].ref, True);
			if (d && (d->dot == DOT_Array)) {
				d->expandX = anim->expandX;
				d->expandY = anim->expandY;
				if (d->rank == 2 || d->rank == 3) {
					NetSendAnimation
					  (0,d,
					   TRUE/*shouldCopy*/,
					   TRUE/*distributeInternally*/,0);
					}
				else    {
					ErrMesg(
						"Can't animate data object\n");
					}
				}
			else if (d && (d->dot == DOT_Palette8)) {
				NetSendPalette8(0,d->label,d->data,
						(char *)NULL, TRUE,0);
				}
		
			lastTag = anim->tagRefs[x].tag;
			lastRef = anim->tagRefs[x].ref;
			} /* if */
		    }/*for*/
		/* sync other collaborators to the same frame */
		NetSendAnimationCommand(0,anim->title,
					AF_STOP,ART_NONE,
					anim->curFrame);
		FREE(anim->tagRefs);
		FREE(anim->fileName);
		anim->delayedRead = False;
		}

	return;
} /* FinishReading() */

static void
CBContAnimationCreate(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Animation *anim;
Arg	argList[10];
Cardinal	i;

	anim = (Animation *) client_data;

        XtRemoveCallback(w,XmNexposeCallback,CBContAnimationCreate,
			 (caddr_t)anim);

	FinishReading(anim);

	anim->creationComplete = TRUE;


        XtSetArg(argList[0], XmNwidth, &(anim->width));
        XtGetValues(anim->slider, argList, 1);
#ifdef DEBUG
	printf("####################### anim->width is %d\n",anim->width);
#endif
	XtSetArg(argList[0],XmNmaximum, anim->width);
	XtSetArg(argList[1],XmNminimum,0);
	XtSetArg(argList[2],XmNsliderSize,SliderSize(anim));
	XtSetValues(anim->slider,argList,3);

	/* wrap to beginning */
	anim->curFrame = 0;
	XmScrollBarSetValues(anim->slider,0,
			     SliderSize(anim), 1, 0,False);

	CBAnimationExpose(0,anim,0);

	AnimLock(animLock);

} /* CBContAnimationCreate() */



static Animation *
CreateAnimation(rootWidget,data, useAnim)
Widget rootWidget;
Data *data;
Animation *useAnim;
{
Cardinal i;
Arg argList[15];
Animation *anim;
Widget b;
int boxWidth,boxHeight;
int width,height;
int expandWidth,expandHeight;
XGCValues gcval;
XmString label;
Pixel background,foreground;
register int x;
AnimPal *pal;


	if (useAnim == (Animation *)NULL) {
	  if (!(anim = (Animation *) MALLOC(sizeof(Animation)))) {
                ErrMesg("Out of Memory: Can't load new animation\n");
                return(0);
	  	}
	  }
	else		/* we are  indirectly called by CBMagnify */
		anim = useAnim;

	if (!(anim->title = (char *) MALLOC(strlen(data->label)+1))) {
		ErrMesg("Out of Memory: Can't load new animation\n");
		return(0);
		}
	strcpy(anim->title,data->label);

	boxWidth = fwd_width + rev_width + fstep_width + rstep_width 
			  + pause_width + 18;
	boxHeight = fwd_height + 20;

	expandWidth = (int) (((float) data->dim[0]) * data->expandX);
	width = (boxWidth+20 > expandWidth) ? boxWidth+20: expandWidth;
	expandHeight = (int) (((float) data->dim[1]) * data->expandY);
	height = boxHeight + expandHeight + 30;

	anim->cmap = XCreateColormap(myDpy,XtWindow(rootWidget),myVis,
				     AllocAll);
        i = 0;
        XtSetArg(argList[i], XtNcolormap, anim->cmap); i++;
        XtSetArg(argList[i], XmNbackground, 0); i++;
        XtSetArg(argList[i], XmNallowShellResize, True); i++;
        XtSetArg(argList[i], XtNtitle, data->label); i++;
        XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        anim->top = XtCreatePopupShell("animShell", topLevelShellWidgetClass,
                                        rootWidget, argList, i);

	i=0;
        XtSetArg(argList[i], XtNcolormap,
		 DefaultColormapOfScreen(myScreen)); i++;
        XtSetArg(argList[i],XmNwidth,width); i++;
        XtSetArg(argList[i],XmNheight,height); i++;
        anim->mainWindow = XmCreateForm(anim->top,"animation",argList,i);
        XtManageChild(anim->mainWindow);

        i=0;
        XtSetArg(argList[i],XmNwidth,width); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        anim->menuBar= XmCreateMenuBar(anim->mainWindow,0,argList,i);
        XtManageChild(anim->menuBar);

	i=0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
        anim->pulldown[0] = XmCreatePulldownMenu(anim->menuBar,"pulldown0",
						 argList,i);

        i=0;
        label = XmStringCreateLtoR("File",XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNsubMenuId,anim->pulldown[0]); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNmnemonic,'F'); i++;
        b = XmCreateCascadeButton(anim->menuBar,0,argList,i);
        XtManageChild(b);

	i=0;
        b = XmCreateSeparator(anim->pulldown[0],0, argList,i);
        XtManageChild(b);

        i=0;
        label = XmStringCreateLtoR("Close",XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNmnemonic,'C'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        b = XmCreatePushButtonGadget(anim->pulldown[0],"menuButton",
                                argList,i);
        XtAddCallback(b,XmNactivateCallback,CBAnimationDone,(caddr_t)anim);
        XtManageChild(b);

	i=0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
        anim->pulldown[1] = XmCreatePulldownMenu(anim->menuBar,"pulldown1",
						 argList,i);
        i=0;
        label = XmStringCreateLtoR("View",XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNsubMenuId,anim->pulldown[1]); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNmnemonic,'V'); i++;
        b = XmCreateCascadeButton(anim->menuBar,0,argList,i);
        XtManageChild(b);

	i=0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
        anim->pulldown[2] = XmCreatePulldownMenu(anim->pulldown[1],"pulldown2",
						 argList,i);
        i=0;
        label = XmStringCreateLtoR("Palette",XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNsubMenuId,anim->pulldown[2]); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNmnemonic,'P'); i++;
        b = XmCreateCascadeButton(anim->pulldown[1],0,argList,i);
        XtManageChild(b);

	AnimRegisterPalsInPulldown(anim);

	i=0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
        anim->pulldown[3] = XmCreatePulldownMenu(anim->menuBar,"pulldown3",
                                                        argList,i);
        i=0;
        label = XmStringCreateLtoR("Options",XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNsubMenuId,anim->pulldown[3]); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNmnemonic,'O'); i++;
        b = XmCreateCascadeButton(anim->menuBar,0,argList,i);
        XtManageChild(b);

	anim->showFrameNumber = FALSE;
        i=0;
        label = XmStringCreateLtoR("Show Frame Number",
				   XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNmnemonic,'F'); i++;
        XtSetArg(argList[i],XmNset,anim->showFrameNumber); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        b = XmCreateToggleButton(anim->pulldown[3],0,argList,i);
        XtAddCallback(b,XmNvalueChangedCallback,CBAnimShowFrameNumber,
			(caddr_t)anim);
        XtManageChild(b);

	anim->useAllEntries = FALSE;
        i=0;
        label = XmStringCreateLtoR("Use Entire Palette",
				   XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNmnemonic,'U'); i++;
        XtSetArg(argList[i],XmNset,anim->useAllEntries); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        b = XmCreateToggleButton(anim->pulldown[3],0,argList,i);
        XtAddCallback(b,XmNvalueChangedCallback,CBAnimUseEntirePalette,(caddr_t)anim);
        XtManageChild(b);

	anim->displayNewPalette = TRUE;
        i=0;
        label = XmStringCreateLtoR("Display New Palette",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNmnemonic,'D'); i++;
        XtSetArg(argList[i],XmNset,anim->displayNewPalette); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        b = XmCreateToggleButton(anim->pulldown[3],0,argList,i);
        XtAddCallback(b,XmNvalueChangedCallback,CBAnimDisplayNewPalette,
		      (caddr_t)anim);
        XtManageChild(b);

	i=0;
	XtSetArg(argList[i],XmNradioBehavior,True); i++;
	anim->pulldown[4] = XmCreatePulldownMenu(anim->pulldown[3],"pulldown4",
						 argList,i);
	XtManageChild(anim->pulldown[4]);

	i=0;
	label = XmStringCreateLtoR("Play Mode",XmSTRING_DEFAULT_CHARSET);
	XtSetArg(argList[i],XmNsubMenuId,anim->pulldown[4]); i++;
	XtSetArg(argList[i],XmNlabelString,label); i++;
	XtSetArg(argList[i],XmNmnemonic,'M'); i++;
	b = XmCreateCascadeButton(anim->pulldown[3],0,argList,i);
	XtManageChild(b);

        i=0;
        label = XmStringCreateLtoR("Single Run", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNmnemonic,'S'); i++;
        XtSetArg(argList[i],XmNindicatorType,XmONE_OF_MANY); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNset,True); i++;
        anim->button[6] = XmCreateToggleButton(anim->pulldown[4],0,argList,i);
        XtAddCallback(anim->button[6],XmNvalueChangedCallback,
				CBAnimSingleRun,(caddr_t)anim);
	XtManageChild(anim->button[6]);
        i=0;
        label = XmStringCreateLtoR("Continuous Wrap", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNmnemonic,'W'); i++;
        XtSetArg(argList[i],XmNindicatorType,XmONE_OF_MANY); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        anim->button[7] = XmCreateToggleButton(anim->pulldown[4],0,argList,i);
        XtAddCallback(anim->button[7],XmNvalueChangedCallback,
				CBAnimContWrap,(caddr_t)anim);
	XtManageChild(anim->button[7]);
        i=0;
        label = XmStringCreateLtoR("Continuous Bounce", 
					XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNmnemonic,'B'); i++;
        XtSetArg(argList[i],XmNindicatorType,XmONE_OF_MANY); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        anim->button[8] = XmCreateToggleButton(anim->pulldown[4],0,argList,i);
        XtAddCallback(anim->button[8],XmNvalueChangedCallback,
			CBAnimContBounce,(caddr_t)anim);
	XtManageChild(anim->button[8]);

/*
	i=0;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNtopWidget,anim->menuBar); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNwidth,expandWidth); i++;
        XtSetArg(argList[i],XmNheight,expandHeight); i++;
	b = XmCreateFrame(anim->mainWindow,0,argList,i); i++;
	XtManageChild(b);
*/

        i=0;
/*****/
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNtopWidget,anim->menuBar); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
/*****/
        XtSetArg(argList[i],XmNwidth,expandWidth); i++;
        XtSetArg(argList[i],XmNheight,expandHeight); i++;
	anim->animWindow = XmCreateDrawingArea(anim->mainWindow,0,argList,i);
	XtManageChild(anim->animWindow);
	anim->animWindowGC = XtGetGC(anim->animWindow,0,&gcval);

	i=0;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNtopWidget,anim->animWindow); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
	b = XmCreateFrame(anim->mainWindow,0,argList,i); i++;
	XtManageChild(b);

	i=0;
	XtSetArg(argList[i],XmNwidth,boxWidth+15); i++;
	XtSetArg(argList[i],XmNheight,boxHeight); i++;
	anim->buttonBox = XmCreateForm(b,0,argList,i);
	XtManageChild(anim->buttonBox);

	if (!pixmapCreated) {
		foreground = GetForeground(anim->mainWindow);
		background = GetBackground(anim->mainWindow);
	
		fwdPixmap = XCreatePixmapFromBitmapData(myDpy,
				RootWindow(myDpy,DefaultScreen(myDpy)),
				fwd_bits,fwd_width,fwd_height,
				foreground, background,8);
		revPixmap = XCreatePixmapFromBitmapData(myDpy,
				RootWindow(myDpy,DefaultScreen(myDpy)),
				rev_bits,rev_width,rev_height,
				foreground, background,8);
		fstepPixmap = XCreatePixmapFromBitmapData(myDpy,
				RootWindow(myDpy,DefaultScreen(myDpy)),
				fstep_bits,fstep_width,fstep_height, 
				foreground, background,8); 
		rstepPixmap = XCreatePixmapFromBitmapData(myDpy, 
				RootWindow(myDpy,DefaultScreen(myDpy)), 
				rstep_bits,rstep_width,rstep_height, 
				foreground, background,8); 
		pausePixmap = XCreatePixmapFromBitmapData(myDpy, 
				RootWindow(myDpy,DefaultScreen(myDpy)), 
				pause_bits,pause_width,pause_height, 
				foreground, background,8); 
	
		pixmapCreated = TRUE;
		}

	i=0; 
	XtSetArg(argList[i],XmNx,0); i++;
        XtSetArg(argList[i],XmNy,0); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNwidth,rev_width); i++;
        XtSetArg(argList[i],XmNheight,rev_height); i++;
        XtSetArg(argList[i],XmNlabelType,XmPIXMAP); i++;
        XtSetArg(argList[i],XmNlabelPixmap,revPixmap); i++;
        anim->button[0] = XmCreatePushButton(anim->buttonBox,0,argList,i);
        XtAddCallback(anim->button[0],XmNactivateCallback,CBAnimReverse,(caddr_t)anim);
        i=0;
        XtSetArg(argList[i],XmNx,rev_width+3); i++;
        XtSetArg(argList[i],XmNy,0); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNwidth,rstep_width); i++;
        XtSetArg(argList[i],XmNheight,rstep_height); i++;
        XtSetArg(argList[i],XmNlabelType,XmPIXMAP); i++;
        XtSetArg(argList[i],XmNlabelPixmap,rstepPixmap); i++;
        anim->button[1] = XmCreatePushButton(anim->buttonBox,0,argList,i);
        XtAddCallback(anim->button[1],XmNactivateCallback,CBAnimReverseStep,
									(caddr_t)anim);
        i=0;
        XtSetArg(argList[i],XmNx,rev_width+rstep_width +6); i++;
        XtSetArg(argList[i],XmNy,0); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNwidth,pause_width); i++;
        XtSetArg(argList[i],XmNheight,pause_height); i++;
        XtSetArg(argList[i],XmNlabelType,XmPIXMAP); i++;
        XtSetArg(argList[i],XmNlabelPixmap,pausePixmap); i++;
        anim->button[2] = XmCreatePushButton(anim->buttonBox,0,argList,i);
        XtAddCallback(anim->button[2],XmNactivateCallback,CBAnimPause,(caddr_t)anim);
        i=0;
        XtSetArg(argList[i],XmNx,rev_width+rstep_width + pause_width +9); i++;
        XtSetArg(argList[i],XmNy,0); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNwidth,fstep_width); i++;
        XtSetArg(argList[i],XmNheight,fstep_height); i++;
        XtSetArg(argList[i],XmNlabelType,XmPIXMAP); i++;
        XtSetArg(argList[i],XmNlabelPixmap,fstepPixmap); i++;
        anim->button[3] = XmCreatePushButton(anim->buttonBox,0,argList,i);
        XtAddCallback(anim->button[3],XmNactivateCallback,CBAnimForwardStep,
									(caddr_t)anim);
        i=0;
        XtSetArg(argList[i],XmNx,rev_width + rstep_width + pause_width 
					   + fstep_width + 12); i++;
        XtSetArg(argList[i],XmNy,0); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNwidth,fwd_width); i++;
        XtSetArg(argList[i],XmNheight,fwd_height); i++;
        XtSetArg(argList[i],XmNlabelType,XmPIXMAP); i++;
        XtSetArg(argList[i],XmNlabelPixmap,fwdPixmap); i++;
        anim->button[4] = XmCreatePushButton(anim->buttonBox,0,argList,i);
        XtAddCallback(anim->button[4],XmNactivateCallback,CBAnimForward,(caddr_t)anim);

	XtManageChildren(anim->button,5);

        i=0;
        XtSetArg(argList[i],XmNx,0); i++;
        XtSetArg(argList[i],XmNy,fwd_height+5); i++;
        XtSetArg(argList[i],XmNwidth,boxWidth-3); i++;
        XtSetArg(argList[i],XmNorientation,XmHORIZONTAL); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
/*        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++; */
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNshowArrows,False); i++;
	anim->slider = XmCreateScrollBar(anim->buttonBox,0,argList,i);
        XtAddCallback(anim->slider,XmNdragCallback, CBsliderSetValue,(caddr_t)anim);
        XtAddCallback(anim->slider,XmNpageDecrementCallback, 
						CBsliderSetValue,(caddr_t)anim);
        XtAddCallback(anim->slider,XmNpageIncrementCallback, 
						CBsliderSetValue,(caddr_t)anim);
	XtManageChild(anim->slider);

	i = 0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
	anim->button[5] = XmCreateScale(anim->buttonBox, "scale", argList, i);
	XtManageChild(anim->button[5]);

	anim->pixmapList = ListCreate();

	anim->data = data;

	anim->badAllocError = False;

	anim->interv_id = (XtIntervalId)0;
	anim->runStatus = A_PAUSE;
	anim->runType = ART_SINGLE;
	anim->curFrame = -1;
	anim->numFrames = 0;
	anim->displayNewPalette = TRUE;
	if (!strcmp(res_gotten.anim_source, "memory"))
		anim->methods = &inMemoryMethods;
	else if (!strcmp(res_gotten.anim_source, "disk"))
		anim->methods = &inDiskMethods;
	else {
		XSetErrorHandler(AnimateError);
		anim->methods = &pixmapMethods;
		}
	pal = (AnimPal *) ListTail(palList);
#ifdef DEBUG
	printf("Associating %s palette with %s animation",
			pal->title,anim->title);
#endif
	for (x=0; x< 256; x++) {
		anim->ccells[x].pixel = x;
		cpccell(anim->ccells[x],pal->ccells[x]);
		}

        XtAddCallback(anim->animWindow,XmNexposeCallback,
			CBContAnimationCreate,(caddr_t)anim);
        XtAddCallback(anim->animWindow,XmNexposeCallback,
			CBAnimationExpose,(caddr_t)anim);


#ifdef DEBUG
	printf("End of CreateAnimation() data=%x,xdim=%d,y=%d,z=%d\n",
			anim->data,data->dim[0],data->dim[1],data->dim[2]);
#endif
	if (useAnim == (Animation *)NULL) {
		/* SetDelayedRead has not been called */
		anim->delayedRead = FALSE;
		anim->tagRefs = (JS_annoy_me *)0;
		anim->numTagRefs = 0;
		/* we are not indirectly called by CBMagnify */
		anim->expandX = data->expandX;
		anim->expandY = data->expandY;
	}

	anim->dataList = ListCreate();

	anim->creationComplete = FALSE;

	XtPopup(anim->top,XtGrabNone);
	XFlush(myDpy);

        i = 0;
        XtSetArg(argList[i], XmNtroughColor, &(saveEntries[0])); i++;
        XtSetArg(argList[i], XmNbottomShadowColor, &(saveEntries[1])); i++;
        XtSetArg(argList[i], XmNtopShadowColor, &(saveEntries[2])); i++;
        XtSetArg(argList[i], XmNhighlightColor, &(saveEntries[3])); i++;
        XtSetArg(argList[i], XmNforeground, &(saveEntries[4])); i++;
        XtSetArg(argList[i], XmNbackground, &(saveEntries[5])); i++;
        XtSetArg(argList[i], XmNborderColor, &(saveEntries[6])); i++;
        XtGetValues(anim->slider, argList, i);
        saveEntries[i++] = BlackPixel(myDpy, DefaultScreen(myDpy));
        saveEntries[i++] = WhitePixel(myDpy, DefaultScreen(myDpy));
	numToSave = i;

	width = (int) (((float) anim->data->dim[0]) * anim->data->expandX);
	height = (int) (((float) anim->data->dim[1]) * anim->data->expandY);


	anim->ximage = XCreateImage(myDpy,myVis,8,ZPixmap,0,
					0,
					width,height,
					8,0);
	AnimStoreColors(anim->useAllEntries,anim->ccells,anim->cmap);
	XSetWindowColormap(myDpy,XtWindow(anim->top),anim->cmap);
	XSetWindowColormap(myDpy,XtWindow(anim->mainWindow),anim->cmap);
	XSetWindowColormap(myDpy,XtWindow(anim->menuBar),anim->cmap);
	XSetWindowColormap(myDpy,XtWindow(anim->animWindow),anim->cmap);

	if (anim->data->rank == 3)
		x = AnimMakeFrameListFrom3D(anim,anim->data);
	else if (anim->data->rank == 2)
		x = AnimMakeFrameListFrom2D(anim,anim->data);
	else
#ifdef DEBUG
		x = 0,
		printf("anim->data->rank = %d not making pix\n", 
		       anim->data->rank);
#else
		x = 0;
#endif
	if (!x) {
		XtDestroyWidget(anim->top);
		FREE(anim);
		return NULL;
	      }

	ListAddEntry(animList,anim);

	return(anim);

} /* CreateAnimation() */


AnimationInit(top,appContext)
Widget top;
XtAppContext appContext;
{
	register int x;

	myAppContext = appContext;
	myDpy = XtDisplay(top);
	myVis = GetVisual(myDpy);
	myScreen = XtScreen(top);
	rootWidget = top;
	animList = ListCreate();
	palList = ListCreate();

	for(x=0;x < 256; x++)
		defaultCCells[x].pixel = x;
	XQueryColors(myDpy,DefaultColormapOfScreen(myScreen),
			defaultCCells,256);

	pixmapMethods.make_frame = AnimMakePixmap;
	pixmapMethods.display_frame = DisplayPixmap;
	pixmapMethods.destroy_frames = FreePixmap;

	inMemoryMethods.make_frame = MakeInMemory;
	inMemoryMethods.display_frame = DisplayImageFromMemory;
	inMemoryMethods.destroy_frames = FreeImagesData;

	inDiskMethods.make_frame = MakeInDisk;
	inDiskMethods.display_frame = DisplayFrameFromDisk;
	inDiskMethods.destroy_frames = FreeDiskData;

/*
	defaultPal.title = "default";
	defaultPal.motifName = XmStringCreateLtoR(defaultPal.title,
						XmSTRING_DEFAULT_CHARSET);
	for (x= 0; x< 256; x++)  {
		defaultPal.ccells[x].pixel = x;
		cpccell(defaultPal.ccells[x],defaultCCells[x]);
		}
	ListAddEntry(palList,&defaultPal);*/

} /* AnimationInit() */


static void
AnimateCommand(aMesg)
AnimMesg *aMesg;
{
Animation *anim;
int found;
	
#ifdef DEBUG
	printf("AnimateCommand(): I've been called\n");
#endif
	found = FALSE;
	anim = (Animation *) ListHead(animList);
	while (anim && (!found)) {
		if (!strcmp(anim->title,aMesg->title)) {
			found = TRUE;
			}
		else
			anim = (Animation *) ListNext(animList);
		}
	if (!found)
		return;

	if (aMesg->runType != ART_NONE)
	  anim->runType = aMesg->runType;
	switch (aMesg->runType) {
	    case ART_SINGLE:
			XmToggleButtonSetState(anim->button[6],True,True);
			break;
	    case ART_CONT:
			XmToggleButtonSetState(anim->button[7],True,True);
			break;
	    case ART_BOUNCE:
			XmToggleButtonSetState(anim->button[8],True,True);
			break;
	    case ART_NONE:
			break;
		
		};

	switch (aMesg->func) {
	    case AF_FPLAY:
			if (anim->runStatus == A_FORWARD)
				break;
			anim->runStatus = A_FORWARD;
			anim->curFrame = aMesg->frameNumber;
			CBAnimationExpose((Widget) 0,(caddr_t) anim,(caddr_t)0);
			CBNextFrame(anim,(XtIntervalId *)0);
			break;
	    case AF_RPLAY:
			if (anim->runStatus == A_REVERSE)
				break;
			anim->runStatus = A_REVERSE;
			anim->curFrame = aMesg->frameNumber;
			CBAnimationExpose((Widget)0,(caddr_t)anim,(caddr_t)0);
			CBNextFrame(anim,(XtIntervalId *)0);
			break;
	    case AF_STOP:
#ifdef DEBUG
			printf("AnimateCommand(): Stop on frame %d currentFrame is %d\n",			
				aMesg->frameNumber,
				 anim->curFrame);
#endif
			anim->runStatus = A_PAUSE;
			anim->curFrame = aMesg->frameNumber;
			CBAnimationExpose((Widget) 0,(caddr_t)anim,(caddr_t)0);
			break;
	    case AF_NO_FUNC:
			anim->curFrame = aMesg->frameNumber;
			CBAnimationExpose((Widget) 0,(caddr_t)anim,(caddr_t)0);
			break;
	    };

} /* AnimateCommand() */

static	Animation *currentAnim;
static	Boolean useCurrent = False;

void NewAnimation(aMesg,garbage)
AnimMesg *aMesg;
caddr_t garbage;
{
Data *data;
Animation *anim;

#ifdef  DEBUG
	printf("NewAnimation(): new animation\n");
#endif
	
	data = aMesg->data;
	if (!data) {
		AnimateCommand(aMesg);
		return;
		}
	for (anim = (Animation *) ListHead(animList);
	     anim && strcmp(anim->title,data->label);
	     anim = (Animation *) ListNext(animList))
	  ;
	if (anim) {
		if (data->rank == 3) {
			AnimMakeFrameListFrom3D(anim,data);
			}
		else if (data->rank == 2) {
			AnimMakeFrameListFrom2D(anim,data);
			}
		else {
			printf("NewAnimation(): rejecting.. wrong dim\n");
			}
		currentAnim = anim;
		}
	else			/* it's new */
	  if (useCurrent)
	/* indirectly called by CBMagnify */
		currentAnim = CreateAnimation(rootWidget,data, currentAnim);
	  else
		currentAnim = CreateAnimation(rootWidget,data,
					      (Animation *)NULL);
	return;
} /* NewAnimation() */

static void
SetDelayedRead(anim, fileName, tagRefs, numItems)
     Animation *anim;
     char *fileName;
     tag_ref_ptr tagRefs;
     int numItems;
{
	tagRefs++;
	if (--numItems) {
		int x;

		anim->delayedRead = TRUE;
		if (!(anim->tagRefs =
		      (JS_annoy_me *)MALLOC(sizeof(JS_annoy_me)*numItems))) {
			ErrMesg("Out of Memory loading animation\n");
			return;
			}
		for (x = 0; x < numItems; x++) {
			anim->tagRefs[x].tag = tagRefs[x].tag;
			anim->tagRefs[x].ref = tagRefs[x].ref;
			}
		anim->numTagRefs = numItems;
		if (!(anim->fileName =(char *)
				MALLOC(strlen(fileName)+1))){
			ErrMesg("Out of Memory storing animation name");
			return;
			}
		strcpy(anim->fileName,fileName);
		if (anim->creationComplete)
			FinishReading(anim);
		}
	else
		anim->delayedRead = FALSE;
}

/*ARGSUSED*/
static void
CBCancelDialog(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	XtDestroyWidget(w);
}

static void
CBMagnify(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	Animation *anim = (Animation *)client_data;
	Data *data;
	int xmag, ymag;
	XmSelectionBoxCallbackStruct *call_select =
	  (XmSelectionBoxCallbackStruct *)call_data;
	char *value;

        XmStringGetLtoR(call_select->value, XmSTRING_DEFAULT_CHARSET, &value);

	sscanf(value," %d %d", &xmag, &ymag);
	XtFree(value);

	data = anim->data;
	if (xmag > 1)
		data->expandX = (float)xmag;
	anim->expandX = data->expandX;
	if (ymag > 1)
		data->expandY = (float)ymag;
	anim->expandY = data->expandY;

	XtUnmanageChild(w);

	currentAnim = anim;

	useCurrent = True;
	NetSendAnimation(0,data,TRUE /* shouldCopy */,
			 TRUE /*distributeInternally*/,0);
	useCurrent = False;

	XtDestroyWidget(XtParent(w));
	return;
} /* CBMagnify() */


static void
GetMagnification(data, fileName, tagRefs, numItems)
     Data *data;
     char *fileName;
     tag_ref_ptr tagRefs;
     int numItems;
{
	Animation *anim;
	Cardinal i;
	Arg argList[15];
	Widget dialog;
	XmString label, valLabel;
	char buff[512];
	char value[512];

	sprintf(buff, "X Y Magnification Levels for %s\n(must be greater than 0)", data->label);
	sprintf(value, "%d %d", 1, 1);

        label = XmStringCreateLtoR(buff, XmSTRING_DEFAULT_CHARSET);
        valLabel = XmStringCreateSimple(value);
        i = 0;
	XtSetArg(argList[i], XtNtitle, "Define X and Y Magnification"); i++;
        XtSetArg(argList[i], XmNselectionLabelString, label); i++;
        XtSetArg(argList[i], XmNtextString, valLabel); i++;
        dialog = XmCreatePromptDialog(rootWidget, "magnifyDialog", argList, i);

	XmStringFree(label);
	XmStringFree(valLabel);
        if (!(anim = (Animation *) MALLOC(sizeof(Animation)))) {
                ErrMesg("Out of Memory: Can't load new animation\n");
                return;
                }
	anim->creationComplete = FALSE;
	anim->data = data;
	SetDelayedRead(anim,fileName,tagRefs,numItems);
        XtAddCallback(dialog, XmNokCallback, CBMagnify, (caddr_t)anim);
        XtAddCallback(dialog, XmNcancelCallback, CBCancelDialog,
		      (caddr_t)anim);
	XtManageChild(dialog);
	return;
} /* GetMagnification() */

void AnimLoadNewAnimation(fileName,tagRefs,numItems)
char *fileName;
tag_ref_ptr tagRefs;
int numItems;
{
Animation *anim;
Data *data;

	if (numItems < 1) {
		return;
		}
	data = ReadHDFObject(fileName,tagRefs[0].tag, tagRefs[0].ref, True);
	if (!data) {
		ErrMesg("Bad data object selected for animation");
		return;
		}
	if (data->dot !=  DOT_Array) {
		ErrMesg("Can't animate this data object"); 
		return;
		}
	for (anim = (Animation *) ListHead(animList);
	     anim && strcmp(anim->title,data->label);
	     anim = (Animation *) ListNext(animList))
	  ;
	if (!anim && data->dost != DOST_Char) {
		/* new animation, with INT or FLOAT data */
		GetMagnification(data, fileName,tagRefs,numItems);
		return;
	      }
	/* distribute data */
	if (anim)
		data->expandX = anim->expandX,
		data->expandY = anim->expandY;
	NetSendAnimation(0,data,TRUE /*shouldCopy*/,
			 TRUE /*distributeInternally*/,0);
	/* NewAnimation has been called by NetAnimationDistribute */
	/* and set currentAnim */
	SetDelayedRead(currentAnim,fileName,tagRefs,numItems);

	return;
} /* AnimLoadNewAnimation() */



void ChangeAnimation(aMesg,garbage)
AnimMesg *aMesg;
caddr_t garbage;
{
#ifdef  DEBUG
	printf("ChangeAnimation(): I've been called \n");
#endif
	NewAnimation(aMesg,garbage);
}

static AnimPal *
AnimSearchForPaletteByName(name)
char *name;
{
AnimPal *pal;
	
	pal = (AnimPal *) ListHead(palList);
	while(pal) {
		if (!strcmp(name,pal->title)) {
			return(pal);
			}
		pal = (AnimPal *) ListNext(palList);
		}

	return(0);
}


static void
AnimSetNewPalette(title,pdata)
/* Add this palette to the animation pal list */
char *title;		/* name of palette */
unsigned char *pdata;   /* 768 byte palette */
{
AnimPal *pal;
AnimPalGroup *apg;
Animation *anim;
Widget b;
Arg argList[10];
register int x;

	if (pal = AnimSearchForPaletteByName(title)) {
		ConvertToXColors(pdata,pal->ccells);
		anim = (Animation *) ListHead(animList);
		while(anim) {
			if (anim->displayNewPalette) {
				for (x= 0; x< 256; x++)  {
					anim->ccells[x].pixel = x;
					cpccell(anim->ccells[x],pal->ccells[x]);
					}
				AnimStoreColors(anim->useAllEntries,
						anim->ccells, anim->cmap);
				}
			anim = (Animation *) ListNext(animList);
			}
		return;
		}
	
	/* it's new */
	if (!(pal = (AnimPal *) MALLOC(sizeof(AnimPal)))) {
		ErrMesg("Out of Memory receiving new animation palette\n");
		return;
		}
	if (!(pal->title = (char *) MALLOC(strlen(title) +1))) {
		ErrMesg("Out of Memory receiving new animation palette\n");
		return;
		}
	strcpy(pal->title,title);

	for (x= 0; x< 256; x++)  {
		pal->ccells[x].pixel = x;
		pal->ccells[x].red = 0;
		pal->ccells[x].green = 0;
		pal->ccells[x].blue = 0;
		pal->ccells[x].flags = 0;
		}
	
	ConvertToXColors(pdata,pal->ccells);

	ListAddEntry(palList,pal);

	
        pal->motifName = XmStringCreateLtoR(title,XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[0],XmNlabelString,pal->motifName);
	anim = (Animation *) ListHead(animList);
	while (anim) {
		if (!(apg = (AnimPalGroup *) MALLOC(sizeof(AnimPalGroup)))) {
		  ErrMesg("Out of Memory receiving new animation palette\n");
		  return;
		}

		apg->anim = anim;
		apg->pal = pal;
		b = XmCreatePushButtonGadget(anim->pulldown[2],
					"menuButton",argList,1);
		XtAddCallback(b,XmNactivateCallback,CBAnimSetPal,(caddr_t)apg);
		XtManageChild(b);
		if (anim->displayNewPalette) {
			for (x= 0; x< 256; x++)  {
				anim->ccells[x].pixel = x;
				cpccell(anim->ccells[x],pal->ccells[x]);
				}
			AnimStoreColors(anim->useAllEntries,anim->ccells,
					anim->cmap);
			}

		anim = (Animation *) ListNext(animList);
		}
}

AnimNewPalette(d,garbage)
Data *d;
caddr_t garbage;
{
	if (d->dot != DOT_Palette8) {
#ifdef DEBUG
  	  printf("AnimNewPalette(): Bogus, called without a palette....\n");
#endif
		return;
		}
	AnimSetNewPalette(d->label,d->data);
	
}

int AnimExit()
{
Animation *anim;

	anim = (Animation *) ListHead(animList);
	while (anim) {
		CBAnimationDone(0,anim,0);
		anim = (Animation *) ListCurrent(animList);
		}

	if (pixmapCreated) {
		XFreePixmap(myDpy,fwdPixmap);
		XFreePixmap(myDpy,revPixmap);
		XFreePixmap(myDpy,pausePixmap);
		XFreePixmap(myDpy,fstepPixmap);
		XFreePixmap(myDpy,rstepPixmap);
		}
	return(1);
}
