.bp
.so include.n
.pn 1
.fo ``-C.%-``
.po 
.nh
.ls 2
.nr s 11
.sp 2
.ce
Appendix C
.ce
Error Messages
.he ``Error Messages``
.pp
Error messages in REDTEN protect the user from invalid arguments
and illegal operations. Each REDTEN error message consists of the
words error or warning, followed by a cryptic explanation of the
problem, and one or more of the parameters or values that are in
error. In the error message listing below, these parameters are
enclosed in angle brackets.
A warning message indicates that the function which
gave the message may attempt to continue, although many functions
simply exit with nil. A fatal error causes a throw to the top level
driver, and aborts all pending operations. 
.sp 3
.br
.in 5
.sp 1
.ne 3
.ti 0
warning: DIV requires vector: <tnsr> (from div)
.br
The function \*Bdiv\fR can only compute the divergence of a vector.
.sp 1
.ne 3
.ti 0
error: LIE requires a vector: <vec> (from lie)
.br
The function \*Blie\fR requires a vector in order to compute the directional
derivative. 
.sp 1
.ne 3
.ti 0
warning: bad IMPLICIT value <implicit> <tnsr> (from mktnsr*)
.br
The \*Bimplicit\fR parameter <implicit> input to \*Bmktnsr\fR for the 
construction of the object <name> is invalid. It is either not an
atom, not an integer or, if not <name>, then it is not the name of 
another indexed object, or the \*Bconcov\fR list of the object does not
match the \*Bconcov\fR list of <name>. 
.sp 1
.ne 3
.ti 0
error: bad block size: <block size>, <symmetry> (from chksym)
.br
The block-size <block-size> of the independent symmetry 
<symmetry> is not an integer.
.sp 1
.ne 3
.ti 0
error: bad concov element: <n> (from getindices)
.br
The indicated integer from a \*Bconcov\fR list is not one of the allowed
values 0, 1, 2, 3, or 4. 
.sp 1
.ne 3
.ti 0
error: bad connection: <name> (from setcon)
.br
The object <name> is not a valid connection. It is is either not of type
\*Bconnection\fR or its first index is not contravariant.
.sp 1
.ne 3
.ti 0
error: bad derivative operator (from parsebar)
.br
The parser has encountered three `|' in a row.
.sp 1
.ne 3
.ti 0
error: bad input: <exp> (from <function>)
.br
The expression <exp> input to the routine <function> was not an
indexed object. 
.sp 1
.ne 3
.ti 0
error: bad metric: <name> (from setmet)
.br
The object <name> is not a valid metric: its type is 
not \*Bmetric\fR or it does not have two covariant indices. The metric 
inverse cannot be used in the \*BLisp:currentmetric\fR list.
.sp 1
.ne 3
.ti 0
error: bad pointer: <pointer> <symmetry> (from chksym)
.br
The pointer <pointer> in the independent symmetry <symmetry> is
not a positive non-zero integer. 
.sp 1
.ne 3
.ti 0
error: can't make spin matrices -- sorry (from spinmat)
.br
Spinmat is currently only able to create the spin matrices for diagonal 
metrics.
.sp 1
.ne 3
.ti 0
error: cannot assign to <name> (from equalparse1)
.br
The object <name> to the left of a "\(eq\(eq" operator is not a valid 
indexed object, and cannot be assigned.
.sp 1
.ne 3
.ti 0
error: cannot create conjugate <name> (from mkconj)
.br
The object <name> is indexed and protected. \*Bmkconj\fR wishes to use <name>
for a conjugate object, but is unable to. <name> will be of the form
<basename>#cnj.
.sp 1
.ne 3
.ti 0
warning: cannot create object: <name> (from mktnsr)
.br
The object <name> is already indexed and is also delete-protected so
that \*Bmktnsr\fP cannot remove it.
.sp 1
.ne 3
.ti 0
warning: cannot open save file: <file> (from SAVEIC)
.br 
The save file specified in a call to either \*Bsavei\fP or \*Bsavec\fP
cannot be opened. 
.sp 1
.ne 3
.ti 0
error: cannot symmetrize more than 4 indices
.br
A symmetrization operation extending over more than 4 indices
has been attempted. 
.sp 1
.ne 3
.ti 0
error: connection does not exist: <n> (from getcon)
.br
The connection coefficient of type <n> does not exist (n \(eq 1, 2, 3).
.sp 1
.ne 3
.ti 0
warning: coord-indice  mis-match:  <coords>, <indiceten> (from mktnsr)
.br
The tensor index run, stored on the global variable \*BLisp:indiceten\fR does
not match the length of the current system coordinates, stored on the
global variable \*BLisp:coords\fR.
.sp 1
.ne 3
.ti 0
error: derivative op illegal in index (from pdf)
.br
The index passed to \*Bpdf\fP may not have derivative operators in
it; the index is implicitly preceded by a `|' to indicate that a
partial derivative is being taken.
.sp 1
.ne 3
.ti 0
error: free indice: <indice> <name> (from mapindex)
.br
The indice <indice>, in the index of the object <name> does not
match an indice in the output index, and is not a contraction indice. 
.sp 1
.ne 3
.ti 0
error: improper blocks for hermitian symmetry: <symmetry> (from chksym)
.br
A block of the hermitian symmetry <symmetry> does not consist of
an undotted-dotted index pair. 
.sp 1
.ne 3
.ti 0
error: improper contraction:  <index> <indice> (from contract)
.br
A contraction is implied over two indices which are either not of 
the same type; or, if \*BLisp:extendedsum\fR is nil, are both covariant or 
contravariant. The offending indice is <indice> and the problem occurs 
in the combined index <index>.
.sp 1
.ne 3
.ti 0
error: improper structure for hermitian symmetry: <symmetry> (from chksym)
.br
The symmetry intended to be hermitian is not composed of spinor
dotted-spinor pairs.
.sp 1
.ne 3
.ti 0
error: improper symmetry: <symmetry> (from chksym)
.br
A CONCOV sublist for a block of the independent symmetry 
<symmetry> is different from the remaining sublists.
.sp 1
.ne 3
.ti 0
error: inconsistent indices: <value> <expression> (from chkconcov)
.br
The net \*Bconcov\fR list of <value> does not match the \*Bconcov\fR lists of 
other terms of the input expression.
.sp 1
.ne 3
.ti 0
error: index cannot be shared: <index> (from parselsqb)
.br
The index <index> is a shared object in REDUCE. Indices must not be
shared.
.sp 1
.ne 3
.ti 0
error: index wrong length: <name> <index> (from simprdr)
.br
An index (<index>) with either too few or too many indices has
been applied to the object <name>. 
.sp 1
.ne 3
.ti 0
warning: indices do not match (from evaltnsr1)
.br
The net \*Bconcov\fR list of the input expression does not match the 
\*Bconcov\fR list of the output object. This error only occurs when the 
output object was indexed before the assignment was made.
.sp 1
.ne 3
.ti 0
error: input name required (from <function>)
.br
A required input to the function <function> has been omitted. The
input value is nil, and cannot be used. 
.sp 1
.ne 3
.ti 0
error: invalid index: <index> (from pdf)
.br
The index passed to \*Bpdf\fP is not properly constructed; enclose
the index in square brackets.
.sp 1
.ne 3
.ti 0
error: invalid line element (from metric)
.br
\*Bmetric\fR requires that the line-element be a sum.
.sp 1
.ne 3
.ti 0
error: invalid pointers for hermitian symmetry: <symmetry> (from chksym)
.br
The pointers specified for a hermitian symmetry do not point to pairs
of dotted - undotted spinor indices.
.sp 1
.ne 3
.ti 0
error: invalid symmetry: <symmetry> (from chksym)
.br
A block size for an independent symmetry has been found which is smaller than
those previously seen. Independent symmetries should be ordered from smallest
to largest block size.
.sp 1
.ne 3
.ti 0
error: metric does not exist: <n> (from getmet)
.br
The metric of type <n> does not exist (n \(eq 1, 2, 3, 4).
.sp 1
.ne 3
.ti 0
warning: missing conjugate for <name> being created.
.br
The conjugate object for the spinor <name> is missing. It will be re-created by
the system.
.sp 1
.ne 3
.ti 0
warning: missing differential: d(<expression>) (from d)
.br
The total derivative of <expression> is zero, this term will disappear from
the line-element.
.sp 1
.ne 3
.ti 0
error: missing inverse: <name>#inv (from getmet)
.br
There is no inverse for the metric <name>.
.sp 1
.ne 3
.ti 0
warning: no such offspring for <object> (from simprdr)
.br
A request for a specific element of an offspring object has
failed, because the object does not exist. 
.sp 1
.ne 3
.ti 0
error: non-atomic indice: <name> <index> (from mkrdr)
.br
The index <index> to the object <name> contains an indice which is 
not an atom and which is not a shifted indice.
.sp 1
.ne 3
.ti 0
error: object must have two indices: <name> (from <function>)
.br
The function <function> (either \*Bdet\fR, \*Bdeterm\fR or
\*Bcofactor\fR) will only accept 
a rank-2 object as input.
.sp 1
.ne 3
.ti 0
error: output <name> is protected (from copy)
.br
\*Bcopy\fR has failed to copy to the name <name> because <name> is 
indexed and is protected.
.sp 1
.ne 3
.ti 0
error: overlapping blocks: <symmetry> (from chksym)
.br
At least one block in the independent symmetry <symmetry> overlaps 
another.
.sp 1
.ne 3
.ti 0
error: pointer out of order: <symmetry> (from chksym)
.br
The pointers in the independent symmetry <symmetry> are not in 
ascending order.
.sp 1
.ne 3
.ti 0
warning: singular matrix: <name> (from <function>)
.br
The rank-2 object <name> is singular. This error comes from either 
\*Bdet\fR or \*Bdeterm\fR and will usually be followed
by a REDUCE zero denominator error.
.sp 1
.ne 3
.ti 0
warning: subscript out of bounds: <object>
.br
An integer indice in the index of <object> is not within the 
allowed run of indices. The object is replaced with 0.
.sp 1
.ne 3
.ti 0
error: symmetry too long: <symmetry> (from chksym)
.br
The independent symmetry <symmetry> refers to an indice whose 
position is incompatible with the rank of the object.
.sp 1
.ne 3
.ti 0
error: too few pointers: <symmetry> (from chksym)
.br
The independent symmetry <symmetry> has fewer than two pointers.
.sp 1
.ne 3
.ti 0
error: too many contraction indices:  <index> <indice> (from contract)
.br
A simultaneous contraction is implied over more than two indices.
The offending indice is <indice> and the problem occurs in the
combined index <index>.
.sp 1
.ne 3
.ti 0
warning: unmatched coordinates: <name>, <expression> (from processvalue)
.br
The object <name> is defined in the coordinates <coords>, which
are different from the current coordinates as stored in \*BLisp:coords\fR.
.sp 1
.ne 3
.ti 0
warning: <name> cannot be assigned (from ias)
.br
The input <name> to \*Bias\fR is either not an indexed object or is 
write-protected.
.sp 1
.ne 3
.ti 0
error: <name> does not have metric structure. (from metric)
.br
The object <name> is not a rank-2 covariant tensor and \*Bmetric\fR cannot
make it into a metric tensor.
.sp 1
.ne 3
.ti 0
error: <name> is already defined (from newnme)
.br
A call to a general relativity routine has specified an output name 
<name> which is already indexed. Change the default name for the 
function, or delete the current definition of <name>, or specify a 
different input name.
.sp 1
.ne 3
.ti 0
warning: <name> is write-protected (from writetnsr or evaltnsr1)
.br
The object <name> is write-protected and cannot have new elements written
to it.
